/*
 * web.c
 * ~~~~~ web page.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <dirent.h>
#include <time.h>
#include <unistd.h>

#include "player.h"
#include "proto.h"
#include "config.h"

/*---------------------------Player Web Page--------------------------*/
/*                  Create Indavidual Users Web Page                  */
int make_web_player(player* p)
{
 char fname[MAX_LINE];
 FILE* han;

 #ifndef WEB_PAGE
   send_pager(p," Sorry Web Pages have not be turned on!\n");
   return(0);
 #endif

 sprintf(fname,WEB_PATH,p->lower_name);
 han=fopen(fname,"w");
 if (!han) return(0);

 /* web header file */
 fprintf(han,"<HTML>\n");
 fprintf(han,"<HEAD>\n<TITLE>\nDragon Code User's Web Page. %s\n</TITLE>\n</HEAD>\n",p->name);
 fprintf(han,"<BODY BGCOLOR=\"black\" TEXT=\"yellow\" LINK=\"red\" VLINK=\"blue\" ALINK=\"blue\">\n");

 /* Start Player Details */
 fprintf(han,"<CENTER><H1>%s</H1></CENTER>\n<HR>",p->name);
 fprintf(han,"<CENTER><H3>\n");
 if (p->prefix) fprintf(han,"%s ",p->prefix);
 if (p->name)   fprintf(han,"%s ",p->name);
 if (p->title)  fprintf(han,"%s ",p->title);
 fprintf(han,"</H1></CENTER>\n");
 fprintf(han,"<CENTER>");

 if (p->desc) fprintf(han,"<HR>Description:<BR>%s<HR>\n",p->desc);
 if (p->pensflags&ENGAGED) fprintf(han,"%s is engaged to %s<HR>\n",p->name,p->marry);
 if (p->pensflags&MARRIED) fprintf(han,"%s is married to %s<HR>\n",p->name,p->marry);
 if (p->pensflags&PROPOSE) fprintf(han,"%s is proposing to %s<HR>\n",p->name,p->marry);

 fprintf(han,"%s was last seen on %s<BR>\n",p->name,time2asc(p->last_login));
 fprintf(han,"Total login time %s \n",time2str(p->login_time));
 fprintf(han,"of which %s was spent idle<BR><BR>\n",time2str(p->login_idle));

 if (p->email && !(p->pensflags&PRIVATE)) 
    fprintf(han,"email <A HREF=\"mailto:%s\">%s</A><BR>\n",p->email,p->email);
 else fprintf(han,"email set as Private<BR>\n");
 if (p->url) fprintf(han,"URL: <A HREF=\"%s\"> %s</A><BR>\n",p->url,p->url);
 fprintf(han,"%s has %d Newmails<BR>\n",p->name,p->newmail);
 if (p->plan) fprintf(han,"<HR>Plan:<BR>%s<HR>\n",p->plan);
 fprintf(han,"</CENTER>");

 /* Web footer Details */
 fprintf(han,"\n\n");
 fprintf(han,"<A HREF=\"index.html\">Back to Main Page</A>\n\n</BODY></HTML>");

 /* close and quit */
 fclose(han);
 return(1);
}

/*----------------------------Index Web Page--------------------------*/
/*         Creates the users/index.html page listing all users        */
int make_web_index(player*p,char* str)
{
 DIR* dr;
 FILE* han;
 char* pname;
 char* wname;
 char* dpath;
 char  fname[MAX_LINE];
 int   count=0;

 #ifndef WEB_PAGE
   send_pager(p," Sorry Web Pages have not be turned on!\n");
   return(0);
 #endif

 dpath=strdup(PFILES_DIR);
 wname=strdup("index");

 #if defined(CODE)
   send_pager(p," Sorry. This Command Does not Work on the Test Code.\n");
   return(0);
 #endif

 sprintf(fname,WEB_PATH,wname);
 han=fopen(fname,"w");
 if (!han) return(0);

 /* web header file */
 fprintf(han,"<HTML>\n");
 fprintf(han,"<HEAD>\n<TITLE>\nDragon Code User's Web Page's.\n</TITLE>\n</HEAD>\n");
 fprintf(han,"<BODY BGCOLOR=\"black\" TEXT=\"yellow\" LINK=\"red\" VLINK=\"blue\" ALINK=\"blue\">\n");

 /* What This page is */
 fprintf(han,"<CENTER><BR>\n");
 fprintf(han,"User Pages.<BR>\n");
 fprintf(han,"These Pages are updated automatically.<BR><BR>\n");
 fprintf(han,"Current User Pages:-.</CENTER><BR>\n");

 /* Player List */
 fprintf(han,"<HR>\n");
 dr=lsr_start(dpath);
 while ((pname=lsr_next(dr)))
       {
	if (count>1) fprintf(han,"<A HREF=\"%s.html\">%s</A>,  \n",pname,pname);
        count++;
       }
 fprintf(han,"<HR>\n");

 /* Web footer Details */
 fprintf(han,"\n\n<BR><BR>");
 fprintf(han,"<A HREF=\"../index.html\">Back to Main Page</A>\n\n</BODY></HTML>");

 /* close and quit */
 fclose(han);
 su_wall(p,"has re-created the index.html file",WEB);
 sprintf(mssg,"%s has updated the web index.\n",p->name);
 tolog("web",mssg);
 return(make_players(p,NULL));
}

/*-----------------------Update Player Web Page's---------------------*/
/*                Auto-Update all residents Web Pages!!!              */
int make_players(player* p,char* str) 
{
 player* who;
 DIR* dr;
 char* pname;
 char* dpath;
 int count=0;

 dpath=strdup(PFILES_DIR);
 dr=lsr_start(dpath);
 while ((pname=lsr_next(dr)))
       {
	if (count>1)
	{
	 who=find_player_hard(pname);
	 unload_hard(who);
	}
        count++;
       }
 su_wall(p,"has re-created the Player.html files",WEB);
 sprintf(mssg,"%s has updated the player files.\n",p->name);
 tolog("web",mssg);
 return(1);
}
