/*
 * tag.c
 * ~~~~~ tags tags and more tags
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "player.h"
#include "proto.h"
#include "config.h"

char* tag2str(player* rel,Tag t)
{
 static char* mem=NULL;

 if (!mem) mem=malloc(TAG2STR_MEM);
 if (!mem || !t || !*t) return("Nobody");

 *mem=0; /* Zero memory */

 /* OKay is rel on the list or not */

 if (isin_tag(rel,t))
    {
     strcat(mem,"you");
    }
 else
    {
     /* Add on first name */
     strcat(mem,(*t)->name); t++; 
    }

 while (*t)
       {
        if (*t!=rel)
           {
            if ( !(*(t+1)) ||
                ( (*(t+1))==rel && !(*(t+2)) )
               )
               strcat(mem," and ");
            else
               strcat(mem,", ");
            strcat(mem,(*t)->name);
           }
        t++;
       }
 return(mem);
}

int isin_tag(player* p,Tag t)
{
 while (*t)
       {
        if (*t==p) return(1);
        t++;
       }
 return(0);
}

int send_tag(Tag t,char* str)
{
 while (*t)
       {
        send_pager(*t,str); 
        t++;
       }
 return(1);
}

int send_flexi(player*p,char* names,char* str)
{
 player **tag;
 tag=tag_byname(p,str);
 if (!tag) return(0);
 send_tag(tag,str);
 free(tag);
 return(1);
}

Tag tag_byname(player* p,char* names)
{
 return(tag_byname_multi(p,names,0));
}

Tag tag_byname_hard(player* p,char* names)
{
 return(tag_byname_multi(p,names,1));
}

Tag tag_byname_multi(player* p,char* names,int hard)
{
 Tag tags;
 char* nm;
 int res;

 tags=tag_new();

 while (1)
       {
        nm=next_pname(&names);

        if (!nm) goto skip_out;

        if (!strcasecmp(nm,"everyone"))
            res=add_tag_everyone(p,tags,hard);
        else
        if (!strcasecmp(nm,"friends"))
            res=add_tag_friends(p,tags,hard);
        else
        if (!strcasecmp(nm,"sus"))
            res=add_tag_privs(p,SU,tags,hard);
        else 
        if (!strcasecmp(nm,"staff"))
            res=add_tag_privs(p,SU|LA|ADMIN,tags,hard);
        else 
        if (!strcasecmp(nm,"admin"))
            res=add_tag_privs(p,LA|ADMIN,tags,hard);
        else 
            res=add_tag_name(p,nm,tags,hard);

        if (!res) {free(tags); return(NULL);}
       }
 skip_out:

 if (!*tags)
    {
     send_pager(p," Nobody of that description is online right now.\n");
     free_tag(tags);
     return(NULL);
    }
 return(tags);
}

int free_tag(Tag tag)
{
 player** tp;

 tp=tag;
 while (*tp)
       {
        unload_hard(*tp);
        tp++;
       }
 free(tag);
 return(1);
}

int tag_plus_tag(Tag tag,Tag ad)
{
 while (*ad)
       {
        add_tag(*ad,tag);
        ad++;
       }
 return(1);
}

int tag_minus_tag(Tag tag,Tag mn)
{
 while (*mn)
       {
        remove_tag(*mn,tag);
        mn++;
       } 
 return(1);
}

int add_tag_name(player* p,char* name,Tag tag,int hard)
{
 player* fp;

 if (hard)
    fp=find_player_hard(name);
 else
    fp=find_player_soft(name);

 if (!fp)
    {
     sprintf(mssg," No-one of the name '%s' is on at the moment.\n",name);
     send_pager(p,mssg);
     return(0);
    }

 if (fp==p)
    {
     send_pager(p," Talking to yourself again?\n");
     return(0);
    }

 if (isignore(p,fp))
    {
     sprintf(mssg," %s is ignoring you.\n",fp->name);
     send_pager(p,mssg);
     return(0);
    }

 add_tag(fp,tag);
 return(1);
}

int add_tag_zchan(player* p,Tag tag,int hard)
{
 player* f;
 f=first_player;
 while (f)
       {
        if (f!=p && f->active&GAME && !strcmp(p->zchan,f->zchan))
           {
            if (!isignore(p,f))
               add_tag(f,tag);
           }
        f=f->next;
       } 
 return(1);
}

int add_tag_privs(player* p,int privs,Tag tag,int hard)
{
 player* f;
 f=first_player;
 while (f)
       {
        if (f!=p && f->active&GAME && f->privs&privs && f->pensflags&SU_DUTY)
           {
            if (!isignore(p,f))
               add_tag(f,tag);
           }
        f=f->next;
       } 
 return(1);
}

int add_tag_chan_privs(player* p,int privs,Tag tag,int hard)
{
 player* f;
 f=first_player;
 while (f)
       {
        if (f!=p && f->active&GAME && f->privs&privs && f->pensflags&SU_DUTY)
           {
            if (!isignore(p,f) && !(f->pensflags&hard))
               add_tag(f,tag);
           }
        f=f->next;
       } 
 return(1);
}

int add_tag_everyone(player* p,Tag tag,int hard)
{
 player* f;

 if (!(p->privs&RESIDENT))
    {
     send_pager(p," Sorry, only residents can address everyone.\n");
     return(0);
    }

 f=first_player;
 while (f)
       {
        if (f!=p && f->active&GAME)
           {
            if (!isignore(p,f))
               add_tag(f,tag);
           }
        f=f->next;
       } 
 return(1);
}

int remove_tag(player* p,Tag tag)
{
 Tag place;
 place=find_tag(p,tag);
 if (!place) return(0);

 while (*place)
       {
        *place=*(place+1);
        place++;
       }
 return(1);
}

Tag find_tag(player* p,Tag tag)
{
 while (*tag)
       {
        if (*tag==p) return(tag);
        tag++;
       }
 return(NULL);
}

int add_tag(player* p,Tag tag)
{
 int cnt=1;

 while (*tag)
       {
        if (*tag==p) return(0);
        tag++;
        cnt++;
       }
 if (cnt>=MAX_TAGS) return(0);

 *tag=p;
 return(1);
}

Tag tag_new(void)
{
 Tag tg=calloc(sizeof(player*),MAX_TAGS);
 return(tg);
}

char* next_pname(char** txt)
{
 char* t;
 static char pnam[MAX_LINE];
 char* o;

 t=*txt;
 if (!t) return(NULL);

 if (*t==',') t++; /* Skip leading comma */

 o=pnam;
 while (*t && isalpha(*t)) *o++=*t++;
 *o=0;

 if (!*pnam) return(NULL);
 *txt=t;
 return(pnam);
}
