/*
 * Sucom.c
 * ~~~~~~~  Su commands
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "player.h"
#include "proto.h"
#include "config.h"

/*--------------------------Miscellaneous-----------------------------*/
int snew(player* p,char* txt)
{
 return(show_file(p,"snew"));
}

int sumotd_check(player* p,char* str)		 
{
 send_pager(p,global_data[G_SUMOTD]);
}

int reset_session(player* p,char* str)
{
 player* who;

 session_time=0;

 if (!*str)
   strcpy(session_is,"<---Dragon Code--->");
 else
   strcpy(session_is,str);
 strcpy(session_did,p->name);

 who=first_player;
 while(who)
 {
  if (who->comment) who->comment[0]=0;
  who=who->next;
 }

 su_wall(p,"resets the session",SU);
 return(0);
}

/*------------------------------Blank---------------------------------*/
int blank(player* p, char* str)
{
 player* who;
 int did=0;

 if (!*str)
    {
     send_pager(p," Format: blank <player> <command>\n");
     send_pager(p," Commands:\n");
     send_pager(p," plan,url,title,desc,prefix,rlloc,rlname,"
		  "entermsg,loginmsg,logoutmsg,ownpriv\n");
     return(0);
    }

 who=player_arg_hard(p,&str);
 if (!who) return(0);

 if (!bestprivsloud(p,who)) return(0);

 if (!strcmp("plan",str)) {if(who->plan)who->plan[0]=0;did=1;}
 if (!strcmp("url",str)) {if(who->url)who->url[0]=0;did=1;}
 if (!strcmp("title",str)) {if(who->title)who->title[0]=0;did=1;}
 if (!strcmp("desc",str)) {if(who->desc)who->desc[0]=0;did=1;}
 if (!strcmp("prefix",str)) {if(who->prefix)who->prefix[0]=0;did=1;}
 if (!strcmp("rlname",str)) {if(who->rlname)who->rlname[0]=0;did=1;}
 if (!strcmp("rlloc",str)) {if(who->rlloc)who->rlloc[0]=0;did=1;}
 if (!strcmp("entermsg",str)) {if(who->emsg)who->emsg[0]=0;did=1;}
 if (!strcmp("loginmsg",str)) {if(who->loginmsg)who->loginmsg[0]=0;did=1;}
 if (!strcmp("logoutmsg",str)) {if(who->logoutmsg)who->logoutmsg[0]=0;did=1;}
 if (!strcmp("ownpriv",str)) {if(who->ownpriv)who->ownpriv[0]=0;did=1;}

 if (!did)
    {
     send_pager(p," Format: blank <player> <command>\n");
     send_pager(p," plan,url,title,desc,prefix,rlloc,rlname,"
		  "entermsg,loginmsg,logoutmsg,ownpriv\n");
    return(0);
    }

 sprintf(mssg,"%s blanks %s '%s'\n",p->name,who->name,str);
 su_wall2(p,"blanks %s '%s'",who->name,str,SU);
 tolog("blank",mssg);
 unload_hard(who);
 return(0);
}

/*-----------------------------SU Duty--------------------------------*/
int on_su(player* p,char* str)
{
 if (p->pensflags&SU_DUTY)
    {
     send_pager(p," You are on duty.   DOH!!!!!\n");
     return(1);
    }
 su_wall(p,"returns to duty!",SU);
 p->pensflags|=SU_DUTY;
 send_pager(p," You return to duty.\n");
 return(1);
}

int off_su(player* p,char* str) 
{
 if (p->pensflags&SU_DUTY)
    {
     send_pager(p," You go off duty.\n");
     p->pensflags&=~SU_DUTY;
     su_wall(p,"goes off duty!.",SU);
     return(0);
    }
 send_pager(p," You are off duty.  DOH!!!!!\n\n");
 return(0);
}

/*-----------------------------Resident-------------------------------*/
int resident(player* p,char* str)
{
 player* t;

 if (!*str)
    {
     send_pager(p," Format: resident <name>\n");
     return(0);
    }

 t=player_arg(p,&str);
 if (!t) return(0);

 if (t->privs&RESIDENT)
    {
     sprintf(mssg," %s is already a resident.\n",t->name);
     send_pager(p,mssg);
     return(0);
    }

 t->privs|=PRIV_RESIDENT_GRANT;
 sprintf(mssg," -=> %s has made you a resident.\n",p->name);
 send_pager(t,mssg);
 
 sprintf(mssg,"%s grants residency to %s\n",p->name,t->name);
 tolog("residency",mssg);
 
 su_wall1(p,"grants residency to '%s'",t->name,SU);

 t->privs&=~NEWBIE;
 t->pensflags|=PRIVATE;
 t->pensflags|=SU_DUTY;
 t->roomflags|=RRESIDENT;
 save_player(t);
 send_pager(t,"Right Lets set up some Information!!\n");
 return(get_email(t)); 
}

int dibbs(player* p,char* str) 
{
 player* who;

  if (!*str)
     { 
	send_pager(p," Format: dibbs <player>\n");
       	return(0);
     }

 who=player_arg(p,&str);
 if (!who) return(0);
 if(!bestprivsloud(p,who)) return(0);

 if (who->active&DIBBS)
    {
     sprintf(mssg," Sorry you cant call dibbs on %s\n",who->name);
     send_pager(p,mssg);
     return(0);
    }
 who->active|=DIBBS;
 su_wall1(p," Calls Dibbs on %s..  Hands OFF!!!",who->name,SU);
 return(0);
}

int assist(player* p, char* str)	
{
 player* who;
 char* oldstack;
 char msg[MAX_LINE];

 if (!*str)
    {
     send_pager(p," Format: Assist <Player>\n");
     return(0);
    }

 who=player_arg(p,&str);
 if (!who) return(0);
 if(!bestprivsloud(p,who)) return(0);

 SLINK(oldstack);
 sprintf(stack,global_data[G_ASSIST],p->name,p->name);
 SNEXT; SEND;
 send_pager(who,oldstack);
 SUNLINK(oldstack);
 su_wall1(p,"assists %s please state any objections.",who->name,SU);
 return(1);
}

/*--------------------------Player Commands---------------------------*/
int confirm_res(player* p,char* str)
{
 player* who;
 char*   oldstack;

 if (!*str)
 {
   send_pager(p," Format: confirm <player>\n");
   return(0);
 }

 who=player_arg(p,&str);
 if (!who) return(0);

 SLINK(oldstack);

 if (who->email)
     sprintf(stack," Email set.\n");
 else
     sprintf(stack," Email not set.\n");
 SNEXT;
 if (who->pass)
     sprintf(stack," Password set.\n");
 else
     sprintf(stack," Password not set.\n");
 SNEXT;
 if (who->email && who->pass)
     sprintf(stack," Character '%s' will be saved.\n",who->name);
 else
     sprintf(stack," Character '%s' will not be saved.\n",who->name);

 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(0);
}

int rm_bop(player* p,char* str)
{
 player* who;

 if (!*str)
 {
   send_pager(p," Format: rm_bop <player>\n");
   return(0);
 }
 
 who=player_arg_hard(p,&str);
 if (!who) return(0);

 if(!bestprivsloud(p,who)) return(0);

 if (who->pensflags&BOP)
    {
      who->pensflags&=~BOP;
      sprintf(mssg," -=> %s lets you bop again!\n",p->name);
      send_pager(who,mssg);
      su_wall1(p,"returns %s's bop command",who->name,SU);
      sprintf(mssg,"%s un - rm_bops %s\n",p->name,who->name);
      tolog("rm_bop",mssg);
      sprintf(mssg," You return bops to %s\n",who->name);
      send_pager(p,mssg);
    }
 
 else
    {
      who->pensflags|=BOP;
      sprintf(mssg," -=> %s prevents you from boping!\n",p->name);
      send_pager(who,mssg);
      su_wall1(p,"removes %s's bop command",who->name,SU);
      sprintf(mssg,"%s rm_bops %s\n",p->name,who->name);
      tolog("rm_bop",mssg);
      sprintf(mssg," You remove bop from %s\n",who->name);
      send_pager(p,mssg);
    }

 unload_hard(who);
 return(1);
}

int rm_shout(player* p,char* str)
{
 player* who;

 if (!*str)
 {
   send_pager(p," Format: rm_shout <player>\n");
   return(0);
 }
 
 who=player_arg_hard(p,&str);
 if (!who) return(0);

 if(!bestprivsloud(p,who)) return(0);

 if (who->pensflags&SHOUT)
    {
      who->pensflags&=~SHOUT;
      sprintf(mssg," -=> %s lets you shout again!\n",p->name);
      send_pager(who,mssg);
      su_wall1(p,"returns %s's shout command",who->name,SU);
      sprintf(mssg,"%s un - rm_shouts %s\n",p->name,who->name);
      tolog("rm_shout",mssg);
      sprintf(mssg," You return shouts to %s\n",who->name);
      send_pager(p,mssg);
    }
 
 else
    {
      who->pensflags|=SHOUT;
      sprintf(mssg," -=> %s prevents you from shouting!\n",p->name);
      send_pager(who,mssg);
      su_wall1(p,"removes %s's shout command",who->name,SU);
      sprintf(mssg,"%s rm_shouts %s\n",p->name,who->name);
      tolog("rm_shout",mssg);
      sprintf(mssg," You remove shouts from %s\n",who->name);
      send_pager(p,mssg);
    }

 unload_hard(who);
 return(1);
}

int rm_sing(player* p,char* str)
{
 player* who;

 if (!*str)
 {
   send_pager(p," Format: rm_sing <player>\n");
   return(0);
 }
 
 who=player_arg(p,&str);
 if (!who) return(0);

 if(!bestprivsloud(p,who)) return(0);

 if (who->active&SING)
    {
      who->active&=~SING;
      sprintf(mssg," -=> %s lets you sing again!\n",p->name);
      send_pager(who,mssg);
      su_wall1(p,"returns %s's sing command",who->name,SU);
      sprintf(mssg," You return sings to %s\n",who->name);
      send_pager(p,mssg);
    }
 
 else
    {
      who->active|=SING;
      sprintf(mssg," -=> %s prevents you from singing!\n",p->name);
      send_pager(who,mssg);
      su_wall1(p,"removes %s's sing command",who->name,SU);
      sprintf(mssg," You remove sings from %s\n",who->name);
      send_pager(p,mssg);
    }

 return(1);
}

int gag(player* p,char* str)
{
 player* who;
 
 if (!*str)
 {
   send_pager(p," Format: gag <player>\n");
   return(0);
 }

 who=player_arg(p,&str);
 if (!who) return(0);

 if(!bestprivsloud(p,who)) return(0);

 if (who->active&GAG)
    {
     send_pager(p," That player is already wearing a gag.   DOH!!!!!\n");
     return(1);
    }

 who->active|=GAG;
 sprintf(mssg," -=> %s gags you!\n",p->name);
 send_pager(who,mssg);
 su_wall1(p,"gags %s",who->name,SU);
 sprintf(mssg,"%s gags %s\n",p->name,who->name);
 tolog("gag",mssg);
 sprintf(mssg," You gag %s\n",who->name);
 send_pager(p,mssg);
 return(1);
}

int ungag(player* p,char* str)
{
 player* who;
 
 if (!*str)
 {
   send_pager(p," Format: ungag <player>\n");
   return(0);
 }

 who=player_arg(p,&str);
 if (!who) return(0);

 if(!bestprivsloud(p,who)) return(0);

 if (!who->active&GAG)
    {
     send_pager(p," That player is not wearing a gag.   DOH!!!!!\n");
     return(1);
    }

 who->active&=~GAG;
 sprintf(mssg," -=> %s ungags you. Please behave.\n",p->name);
 send_pager(who,mssg);
 su_wall1(p,"ungags %s",who->name,SU);
 sprintf(mssg,"%s ungags %s\n",p->name,who->name);
 tolog("gag",mssg);
 sprintf(mssg," You ungag %s\n",who->name);
 send_pager(p,mssg);
 return(1);
}

int yoyo(player* p,char* str)
{
 player* who;
 int rold,i;

 if (!*str)
 {
  send_pager(p," Format: yoyo <player>\n");
  return(0);
 }

 who=player_arg(p,&str);
 if(!who) return(0);

 if(!bestprivsloud(p,who)) return(0);
 rold=who->room;

 sprintf(mssg,"%s is picked up and used as a yoyo\n",who->name);
 send_room_wall(who,mssg,rold);
 for(i=0;i<4;i++)
 {
  who->room=i;
  look(who,NULL);
 }
 who->room=rold;
 sprintf(mssg,"%s lands back in the room with a bump!\n",who->name);
 send_room_wall(who,mssg,rold);
 su_wall1(p,"plays yoyo with %s.",who->name,SU);
 return(0);
}

int unjail(player* p,char* str)                        
{
 player* who;
 int rold;

 if (!*str)
 {
  send_pager(p," Format: unjail <player>\n");
  return(0);
 }

 who=player_arg(p,&str);
 if(!who) return(0);
 if(!bestprivsloud(p,who)) return(0);
 rold=who->room;
 who->room=0;
 sprintf(mssg,"%s %s\n",who->name,rooms[0].emsg);
 send_room_wall(who,mssg,rold);
 sprintf(mssg,"%s %s.\n",who->name,who->emsg);
 send_room_wall(who,mssg,who->room);
 look(who,NULL);
 who->privs|=ROOM;
 su_wall1(p,"unjails %s.",who->name,SU);
 return(0);
}

int jail(player* p,char* str) 
{
 player* who;
 int rold;

 if (!*str)
 {
  send_pager(p," Format: jail <player> <reason>\n");
  return(0);
 }

 who=player_arg(p,&str);
 if(!who) return(0);
 if(!bestprivsloud(p,who)) return(0);
 rold=who->room;
 who->room=7;

 sprintf(mssg,"%s %s\n",who->name,rooms[7].emsg);
 send_room_wall(who,mssg,rold);
 sprintf(mssg,"%s is grabbed into the room.\n",who->name);
 send_room_wall(who,mssg,who->room);
 look(who,NULL);
 who->privs&=~ROOM;
 sprintf(mssg,"%s jails %s '%s'\n",p->name,who->name,str);
 su_wall1(p,"puts %s in jail.",who->name,SU);
 tolog("jail",mssg);
 return(0);
}

int showhelp(player* p,char* str) 
{
 player* who;
 char* txt;
 char* buf;
 char* fname;
 char   hlevel;

 if (!*str)
 {
  send_pager(p," Format: showhelp <player> <help file>\n");
  return(0);
 }

 who=player_arg(p,&str);
 if(!who) return(0);
 if (!*str)
 {
  send_pager(p," Format: showhelp <player> <help file>\n");
  return(0);
 }

 if(!bestprivsloud(p,who)) return(0);

 txt=str; while (isalnum(*txt) || *txt=='_') txt++; *txt=0;
 if (!*str) str="help";
 fname=malloc(strlen(str)+1+strlen(HELP_PATH));
 sprintf(fname,HELP_PATH,str);
 buf=strap_file(fname); free(fname);
 if (!buf)
    {
     sprintf(mssg," There is no help on the subject of '%s'\n",str);
     send_pager(p,mssg);
     return(0);
    }
 hlevel=buf[0];
 if(((*buf=='S') && !(p->privs&SU))||((*buf=='L') && !(p->privs&LA))||
    ((*buf=='A') && !(p->privs&ADMIN))||((*buf=='H') &&!(p->privs&HCADMIN)))
    {
     send_pager(p," Sorry You Can not Read that Help File!\n");
     return(0);
    }
 buf[0]=13;
 send_pager(who,buf);
 free(buf);
 su_wall2(p," shows %s help %s",who->name,str,SU);
 return(1);
}

int saved_warn(player* p,char* str)           
{
 player* who;

 if (!*str)
 {
  send_pager(p," Format: swarn <player> <reason>\n");
  return(0);
 }

 who=player_arg_hard(p,&str);
 if (!who) return(0);

 if (!bestprivsloud(p,who)) return(0);

 if (who->swarn && !(who->swarn[0]==0))
  {
  send_pager(p," Sorry that person already has a Saved Warning\n");
  return(0);
  }

 sprintf(mssg,"%s: %s",p->name,str);
 who->swarn=strdup(mssg);

 su_wall1(p,"leaves a saved Warning for %s.",who->name,SU);
 sprintf(mssg,"%s swarns %s -=> '%s'\n",p->name,who->name,str);
 tolog("warn",mssg);

 unload_hard(who);
 return(0);
}

int warn(player* p,char* str) 
{
 Tag who,lp;
 char* oldstack;

 if (!*str)
    {
     send_pager(p," Format: warn <player> <msg>\n");
     return(0);
    }

 who=player_arg_tag(p,&str);
 if (!who) return(0);

 if (!*str)
    {
     send_pager(p," Format: warn <player> <msg>\n");
     return(0);
    }

 SLINK(oldstack);
 sprintf(stack," You warn %s -=> '%s'\n",tag2str(p,who),str);
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 su_wall2(p,"Warns %s -=> '%s'",tag2str(p,who),str,SU);
 
 sprintf(mssg,"%s warns %s -=> '%s'\n",p->name,tag2str(p,who),str);
 tolog("warn",mssg);

 /* Loop on the tag */

 lp=who;
 while (*lp)
       {
        sprintf(stack,"> %s warns %s -=> '%s'",fullname(p),tag2str(p,who),str);
        SNEXT; SEND;

        bold(*lp,1); send_pager(*lp,oldstack);
        bold(*lp,0); send_pager(*lp,"\n");
        lp++;
        SUNLINK(oldstack);
       }
 free_tag(who); /* Free tags */
 return(1);
}

int trace(player* p, char* str)	
{
 player* who;
 char* oldstack;

 if (!*str)
    {
     send_pager(p," Format: trace <player>\n");
     return(0);
    }

 who=player_arg_hard(p,&str);
 if (!who) return(0);

 SLINK(oldstack);

 sprintf(stack," %s was last connected from --->\n          ",who->name); 
 SNEXT;

 stackoldip(who);

 SEND; send_pager(p,oldstack);
 SUNLINK(oldstack);
 unload_hard(who);
 return(1);
}

int recap(player* p,char* str)
{
 player* who;
 char* orgstr;

 orgstr=str;

 if (!*str)
    {
     send_pager(p," Format: recap <playername>.\n");
     return(0);
    }

 who=player_arg_hard(p,&str);
 if (!who) return(0);

 /* Priv check */

 if (who!=p)
    {
     if (!bestprivsloud(p,who))
        {
         unload_hard(who);
         return(0);
        }
    }

 /* Change the name details */

 free(who->name); who->name=strdup(orgstr);

 if (who==p)
     {
     sprintf(mssg," You recap your name to '%s'\n",who->name);
     send_pager(p,mssg);
     }
 else
     {
      sprintf(mssg," -=> %s has recapped your name to '%s'\n",p->name,who->name);
      send_pager(who,mssg);
      su_wall1(p,"recaps '%s'",who->name,SU);
     }

 unload_hard(who);
 return(1);
}

int rename_cmd(player* p,char* str)	
{
 player* who,*who2;
 char* t;

 if (!*str)
    {
     send_pager(p," Format: rename <player> <name>.\n");
     return(0);
    }

 who=player_arg_hard(p,&str);
 if (!who) return(0);

 if (!bestprivsloud(p,who))
    {
     unload_hard(who);
     return(0);
    }

 t=str;
 while (isalnum(*t)) t++; *t=0;

 if (!*str)
    {
     unload_hard(who);
     send_pager(p," Format: rename <player> <name>.\n");
     return(0);
     } 

 if ((who2=find_player_hard_nosoft(str)))
    { 
     unload_hard(who2);
     send_pager(p,"That name is already taken.\n");
     unload_hard(who);
     return(1);
    }

 su_wall2(p,"renames '%s' to '%s'",who->name,str,SU);
 sprintf(mssg,"%s renames '%s' to '%s'\n",p->name,who->name,str);
 tolog("rename",mssg);

 delete_player(who->name);
 who->name=strdup(str);
 who->lower_name=strdup(str);
 makelower(who->lower_name);

 sprintf(mssg,"-=> %s renames you to '%s'\n",p->name,str);
 send_pager(who,mssg);
 save_player(who);
 unload_hard(who);
 return(1);
}

int nuke(player* p,char* str)	
{
 player* who;
 char* pname;
 char* nname; 

 if (!*str)
    {
     send_pager(p," Format: nuke <player> <reason>\n");
     return(0);
    }

 who=player_arg_hard(p,&str);
 if (!who) return(0);

 if (!*str)
    {
     send_pager(p," Format: nuke <player> <reason>\n");
     return(0);
    }


 if (!bestprivsloud(p,who))
    {
     unload_hard(who);
     return(0);
    }

 pname=strdup(who->lower_name);
 nname=strdup(p->lower_name);
 unload_hard(who);

 who=find_player(pname);
 if (who) 
    {
     sprintf(mssg,"%s is nuked to a crisp. Toasty Time!!!!\n",p->name);
     send_room_wall(p,mssg,p->room);
     send_pager(who,global_data[G_NUKE]);
     kill_player(who);
     unload_hard(who);
    }

 delete_player(pname);

 su_wall1(p,"nukes '%s'\n",pname,SU);

 sprintf(mssg,"%s nuked %s '%s'\n",nname,pname,str);
 tolog("nuke",mssg);

 free(pname);
 return(0);
}

int scare(player* p,char* str)	
{
 player* who;
 char* pname;
 
 if (!*str)
    {
     send_pager(p," Format: scare <playername>\n");
     return(0);
    }

 who=player_arg(p,&str);
 if (!who) return(0);

 if (!bestprivsloud(p,who))
    {
     unload_hard(who);
     return(0);
    }

 pname=strdup(who->lower_name);
 unload_hard(who);

 who=find_player(pname);
 if (who)
    {
     send_pager(who,global_data[G_NUKE]);
     su_wall1(p,"scares the shit out of '%s'\n",pname,SU);

     sprintf(mssg,"%s scares %s\n",p->name,pname);
     tolog("scare",mssg);

     logoff_player(who);
    }

 free(pname);
 return(0);
}

int drag(player* p,char* str)
{
 player* who;
 char* pname;

 if (!*str)
    {
     send_pager(p," Format: drag <playername>\n");
     return(0);
    }

 who=player_arg_hard(p,&str);
 if (!who) return(0);

 if (!bestprivsloud(p,who))
    {
     unload_hard(who);
     return(0);
    }

 pname=strdup(who->lower_name);
 unload_hard(who);

 who=find_player(pname);

 su_wall1(p,"drags %s off the talker.",pname,SU);

 sprintf(mssg,"%s dragged %s of the talker\n",p->name,pname);
 tolog("drag",mssg);

 if (who)
    {
     send_pager(who,global_data[G_DRAG]);
     save_player(who);
     kill_player(who);
    }

 free(pname);
 return(0);
}

/*-------------------------Settable Commands--------------------------*/
int su_comment(player* p,char* str)           
{
 player* who;

 if (!*str)
 {
  send_pager(p," Format: sucomment <player> <comment>\n");
  return(0);
 }

 who=player_arg_hard(p,&str);
 if(!who) return(0);
 if(!bestprivsloud(p,who)) return(0);
 sprintf(mssg,"(%s) %s",p->name,str);
 who->sucom=strdup(mssg);
 su_wall1(p,"sets a SU comment for %s.",who->name,SU);
 unload_hard(who);
 return(0);
}

int validate_email(player* p,char* str)           
{
 player* who;

 if (!*str)
 {
  send_pager(p," Format: validate_email <player>\n");
  return(0);
 }

 who=player_arg_hard(p,&str);
 if(!who) return(0);
 if(!bestprivsloud(p,who)) return(0);
 who->email=strdup("validated set.");
 su_wall1(p,"sets a validated email for %s.",who->name,SU);
 unload_hard(who);
 return(0);
}

