/*
 * socket.c
 * ~~~~~~~~
 */

#include <unistd.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/errno.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <arpa/telnet.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>

#include "player.h"
#include "proto.h"
#include "config.h"
#include "colour.h"

/*---------------------------Miscellaneous----------------------------*/
int rootfd=-1;
int restart_scan=0;
int told_ignore=0;

char* stack=NULL;
char* root_stack=NULL;
player* current_player=NULL;

int shutdown_time=-1;
char shutdown_reason[MAX_LINE];

int session_time=-1;
int robot_auto=-1;
char robot[30];
char session_is[MAX_LINE];
char session_did[MAX_LINE];

char NEWLINE[]={'\r','\n',0};
int port_no=DEFAULT_PORT;

struct terminal terms[] = {
   {"vt100", "\033[1m", "\033[m", "50\033[;H\0332J"},
   {"ansi", "\033[1m", "\033[0m", "50\033[;H\0332J"},
   {"xterm", "\033[1m", "\033[m", "\033[H\033[2J"},
   {"vt220", "\033[1m", "\033[m", "\033[H\033[J"},
   {"vt102", "\033[1m", "\033[m", "50\033["},
   {"wyse-30", "\033G4", "\033G0", ""},
   {"tvi912", "\033l", "\033m", "\032"},
   {"sun", "\033[1m", "\033[m", "\014"},
   {"adm", "\033)", "\033(", "1\032"},
   {"hp2392", "\033&dB", "\033&d@", "\033H\033J"},
   {"", "", "", ""}
};

int bold_tag(player **p,int onoff)
{
 while (*p)
       {
        bold(*p,onoff); p++;
       }
 return(1);
}

int bold(player* p,int onoff)
{
 if (onoff)
     send_player_real(p,terms[p->termtype].bold);
 else
     send_player_real(p,terms[p->termtype].off);
 return(1);
}

int password_mode(player* p,int onoff)
{
 if (onoff)
    {send_pager(p, "\377\373\001"); p->prompt_up=1;}
 else
    {send_pager(p, "\377\374\001"); p->prompt_up=0;}
 return(1);
}

int makelower(char* str)
{
 while (*str) *str++=tolower(*str);
 return(0);
}

int killendjunk(char* str)
{
 char* p;
 p=str;
 while (*p) p++; p--;
 while (p>=str && isspace(*p)) {*p=0; p--;}
 return(0);
}

int killendcr(char* str)
{
 char* p;
 p=str;
 while (*p) p++; p--;
 while (p>=str && *p=='\n') {*p=0; p--;}
 return(0);
}

int send_prompt(player* p)
{
 if (!p->prompt_up)
    {
     send_player_real(p,p->prompt);
     send_itsprompt(p);
    }
 p->prompt_up=1;
 return(1);
}

int send_room_wall(player* org,char* txt, int room)
{
 player* p;
 p=first_player;
 while (p)
       {
	if(p!=org && p->active&GAME && (p->room==room))
         {
           send_pager(p,txt);
         } 
        p=p->next;
       }
 return(1);
}

int send_room_wall_bar(player* org,player* who,char* txt, int room)
{
 player* p;
 p=first_player;
 while (p)
       {
	if(p!=org && p!=who && p->active&GAME && (p->room==room))
         {
           send_pager(p,txt);
         } 
        p=p->next;
       }
 return(1);
}

int send_wall(char* txt,int isbold)
{
 player* p;
 p=first_player;
 while (p)
       { 
        if(p->active&GAME)
        {
 	 if(isbold) bold(p,1);
         send_pager(p,txt);
        }
        p=p->next;
       }
 return(1);
}

int send_wall_bar(player* bar,char* txt,int isbold)
{
 player* p;
 p=first_player;
 while (p)
       { 
        if(p->active&GAME && p!=bar)
        {
 	 if(isbold) bold(p,1);
         send_pager(p,txt);
        }
        p=p->next;
       }
 return(1);
}

int send_player_real(player* p,char* txt)
{
 player* who;

  if (p->fd<0) return(0);
  if (!(p->active&QUIET))
     {
         while (*txt)
               {
                if (*txt=='\n')
                   write(p->fd,NEWLINE,strlen(NEWLINE));
                else if (*txt=='^')
		   {
		   	txt++;
			if      (*txt=='k')	write(p->fd,BLK,strlen(BLK));
			else if (*txt=='r') 	write(p->fd,RED,strlen(RED));
			else if (*txt=='g') 	write(p->fd,GRN,strlen(GRN));
			else if (*txt=='y') 	write(p->fd,YEL,strlen(YEL));
			else if (*txt=='b') 	write(p->fd,BLU,strlen(BLU));
			else if (*txt=='m') 	write(p->fd,MAG,strlen(MAG));
			else if (*txt=='c') 	write(p->fd,CYN,strlen(CYN));
			else if (*txt=='w') 	write(p->fd,WHT,strlen(WHT));
			else if (*txt=='n') 	write(p->fd,NOR,strlen(NOR));
			else if (*txt=='K')	write(p->fd,HBLK,strlen(HBLK));
			else if (*txt=='R') 	write(p->fd,HRED,strlen(HRED));
			else if (*txt=='G') 	write(p->fd,HGRN,strlen(HGRN));
			else if (*txt=='Y') 	write(p->fd,HYEL,strlen(HYEL));
			else if (*txt=='B') 	write(p->fd,HBLU,strlen(HBLU));
			else if (*txt=='M') 	write(p->fd,HMAG,strlen(HMAG));
			else if (*txt=='C') 	write(p->fd,HCYN,strlen(HCYN));
			else if (*txt=='W') 	write(p->fd,HWHT,strlen(HWHT));
			else if (*txt=='N') 	write(p->fd,NOR,strlen(NOR));
			else	write(p->fd,txt,1);
		   }
                else
                   write(p->fd,txt,1);
                txt++;
               }
         write(p->fd,txt,strlen(txt));
         p->prompt_up=0;
     }
 return(1);
}

/*---------------------------Socket Stuff-----------------------------*/
int main(int argc,char** argv)
{
 player* p;
 root_stack=malloc(STACK_SIZE);
 if (!root_stack) exit(0);
 stack=root_stack;

 if (argc>1)
    sscanf(argv[1],"%d",&port_no);

 rootfd=setupsock();
 if (rootfd<0) exit(0); 

 start_timer();

 if (chdir(ROOT))
   {
      printf("Can't change to root directory.\n");
      exit(1);
   }

 sprintf(mssg,"Loading globals.\n");
 tolog("bootup",mssg);
 load_globals();

 sprintf(mssg,"Loading rooms.\n");
 tolog("bootup",mssg);
 load_rooms();

 load_counter();      /* Load notes counter */
 strcpy(session_is,"<---Dragon Code--->");
 strcpy(session_did,"Pendragon");
 strcpy(robot,"robby");

 load_news_counter(); /* Load News */

 atexit(clean_exit); /* Catch exit() */
 catch_signals();

 /* spool_net();  The talker dont have external mail now */

 sprintf(mssg,"Talker up and running..\n");
 tolog("bootup",mssg);


 /* Hopefully add's sommit :P */

 while (shutdown_time !=0)
       {
        stack=root_stack;
        scan_new();
        scan_socks();
        sigpause(0);
       }
 sprintf(mssg,"Talker shutting down..\n");
 tolog("bootup",mssg);

 clean_exit();
 exit(0);  
}

int catch_signals()
{
 signal(SIGTERM,signal_exit);
 signal(SIGINT,signal_exit);
 signal(SIGHUP,signal_exit);
 signal(SIGILL,signal_exit);
 signal(SIGBUS,signal_exit);
 signal(SIGPIPE,signal_exit);
 signal(SIGFPE,signal_exit);
 signal(SIGABRT,signal_exit);
 return(1);
}

void signal_exit(int sig)
{
 sprintf(mssg,"Got signal %d\n",sig);
 tolog("bootup",mssg);
 exit(0); 
}

void clean_exit(void)
{
 save_counter();       /* Save notes */
 save_news_counter();  /* save news */
 logoff_all();         /* Save all players */
 close(rootfd);        /* Close the root fd */
}

int scan_new()
{
 int new=-1;
 int dummy=1;
 int dtlen;
 struct sockaddr_in dt={0};
 struct hostent* hp;
 player* p;

 dtlen = sizeof(dt);
 new=accept(rootfd,(struct sockaddr*)&dt,&dtlen);
 if (new<0) return(0);
 /* Non block */

 ioctl(new,FIONBIO,&dummy);

 /* New player */

 p=new_player();
 p->fd=new;

 /* Get ip adde */
 p->ip_num=strdup(inet_ntoa(dt.sin_addr));
 if(check_sitebanish(p)) return(1);;

 /* resolve to name */

 
 hp=gethostbyaddr((char*)&(dt.sin_addr.s_addr)
                  ,sizeof(dt.sin_addr.s_addr),AF_INET); 
 

 /*hp=NULL;  Hack out due to hanging NS */

 if (hp)
    p->ip_name=strdup(hp->h_name);
 else
    p->ip_name=strdup(p->ip_num);

 /* Start the login */

 start_login(p);

 return(1);
}

int send_itsprompt(player* p)
{
 char buf[3];
 int oldactive;

 if (p->telnetopts&EOR_ON)
    {
     buf[0]=IAC;
     buf[1]=EOR;
     buf[2]=0;
    }
 else
 if (p->telnetopts&IAC_ON)
    {
     buf[0]=IAC;
     buf[1]=GA;
     buf[2]=0;
    }
 else
    {
     buf[0]=IAC;
     buf[1]=GA;
     buf[2]=0;
    }

 /* Send -- but ignore quiet flag */

 oldactive=p->active; p->active&=~QUIET;
 send_player_real(p,buf);
 p->active=oldactive;
 return(1);
}

int backspace(player* p)
{
 p->bufpt--;
 if (p->bufpt<p->buf) p->bufpt=p->buf;
 return(1);
}

int telnet_options(player* p)
{
 unsigned char c;

 if (read(p->fd,&c,1)!=1) return(0);

 switch (c)
        {
         case EC:
              backspace(p);
              /* Backspace */
              return(1);
         case EL:
              /* Zero */
              p->bufpt=p->buf;
              return(1);
         case IP:
              /* Quit */
	      do_debug("code","telnet_options: Recieved Quit!:\n");
              logoff_player(p);
              return(1);
         case DO:
              if (read(p->fd,&c,1)!=1) return;
              switch (c)
                     {
                      case TELOPT_ECHO:
                           break;
                      case TELOPT_SGA:
                           break;
                      case TELOPT_EOR:
                           p->telnetopts|= EOR_ON;
                           p->telnetopts&=~IAC_ON;
                           send_player_real(p,"\377\031");
                           break;
                     }
              break;
         case DONT:
              if (read(p->fd,&c,1)!=1) return;
              switch (c)
                     {
                      case TELOPT_ECHO:
                           break;     
                      case TELOPT_SGA:
                           break;    
                      case TELOPT_EOR:
                           p->telnetopts&=~EOR_ON;
                           p->telnetopts|=IAC_ON;
                           break;
                     }
        }
 return(1);
}

int scan_socks()
{
 player* p;
 int sz,res;
 signed char c;
 int chars_ready;

 restart_scan=0;

 p=first_player;
 while (p)
       {
        current_player=p; told_ignore=0;
        if (p->active&SCAN && p->fd>=0)
           {
            while (!restart_scan && (sz=read(p->fd,p->bufpt,1))==1)
                  {
                   c=*p->bufpt;
/* OK c==-1 aint working atm.. spooning in delete!! */
		   if(c==8)
		     {
		      backspace(p);
		      return;
		     }
		   else
                   if (c==-1)
                      {
                       telnet_options(p);
			return;
                      }
                   else
                   if ((c=='\n' && p->lastchar!='\r') ||
                       (c=='\r' && p->lastchar!='\n'))
                      {
                       *p->bufpt=0; p->prompt_up=0;
                       p->lastchar=c;

                       unidle(p);

                       /* Dispatch the command */

                       if (p->iofunc)
                          {
                           killendcr(p->buf);
                           /* if (strlen(p->buf)) */
                              res=p->iofunc(p,p->buf);
                          }
                       else
                            res=entered_line(p,p->buf);

                       if (!restart_scan)
                          p->bufpt=p->buf; *p->bufpt=0;
                      } 
                   else
                   if (c<32)
                      {
                       p->lastchar=0;
                      }
                   else
                      {
                       if (p->bufpt-p->buf<MAX_LINE)
                          {
                           p->bufpt++;
                           *p->bufpt=0;
                           p->lastchar=c;
                          }
                      }
                  }
            }

        if (!restart_scan && !p->prompt_up && !p->iofunc) send_prompt(p);
        if (!restart_scan && (sz<0 && errno!=EWOULDBLOCK))
           {
            sprintf(mssg,"%s loses socket (sz=%d errno=%d)\n",p->name,sz,errno);
            tolog("connect",mssg);
	    do_debug("code","Socket Scan: Socket lost!\n");
            logoff_player_hard(p);
           }

        if (!restart_scan && sz==0)
	   {
            do_debug("code","Socket Scan: sz==0\n");
            do_debug("code","Error: Killing Player!!!!!!!!\n");
            logoff_player_hard(p);
	   }

        if (restart_scan)
           {
            restart_scan=0;
            p=first_player;
           }
        else
           p=p->next;
       }
 current_player=NULL;
}

int entered_line(player* p,char* txt)
{
 char ol[3];
 char* cmd;

 if (!p) return(0);

 /* Clean up */

 killendcr(txt);

 /* Get the command name */

 if (*txt && !isalnum(*txt))
    {
     cmd=ol;
     cmd[0]=*txt++;
	if (isalnum(*txt)||isspace(*txt))  cmd[1]=0;
	else { cmd[1]=*txt++; cmd[2]=0; }
     while (isspace(*txt)) txt++;
    }
 else
    {
     cmd=nextword(&txt);
     if (!cmd) return(0);
    } 

 /* Compare commands */

 dispatch_command(p,cmd,txt);

 txt[0]=0;
 current_player=NULL;
 return(1);
}

int setupsock()
{
 int iosock;
 int dummy=1;
 struct sockaddr_in dt={0};
 struct hostent* he=0;

 iosock=socket(PF_INET,SOCK_STREAM,0);
 if (iosock<0)
    {
     sprintf(mssg,"Can't create a socket.\n");
     tolog("socket",mssg);
     return;
    }

 setsockopt(iosock,SOL_SOCKET,SO_REUSEADDR,(char*)&dummy,sizeof(dummy));

 dt.sin_port=htons(port_no); dt.sin_family=AF_INET;  
 if (bind(iosock,(struct sockaddr*)&dt,sizeof(struct sockaddr_in))<0)
    { 
     close(iosock); iosock=-1;
     sprintf(mssg,"Can't bind to socket.\n");
     tolog("socket",mssg);
     return(-1);
    }
     
 if (listen(iosock,10)<0)
    {
     close(iosock); iosock=-1;
     sprintf(mssg,"Can't listen to socket.\n");
     tolog("socket",mssg);
     return(-1);
    }
  ioctl(iosock,FIONBIO,&dummy);

  return(iosock);
}
