/*
 * socs.c
 * ~~~~~~  socials
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "player.h"
#include "proto.h"
#include "config.h"
#include "slist.h"

/*----------------------------List Socials----------------------------*/
int list_socials(player* p,char* str)
{
 int cnt=0;
 const struct soc_struct* ss;
 char* oldstack; SLINK(oldstack);

 ss=socs;
 send_pager(p,"Socials available to you are:-\n");
 stackbar();
 while (ss->name)
       {
            if (cnt>65) {*stack++='\n'; cnt=0;}
            if (cnt)
               sprintf(stack,", %s",ss->name);
            else
               sprintf(stack," %s",ss->name);
            cnt+=strlen(stack);
            SNEXT;
        ss++;
       }
 sprintf(stack,"\n"); SNEXT;
 stackbar(); SNEXT;
 *stack++='\n'; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(1);
}

/*------------------------------Do Social-----------------------------*/
int do_social(player* p,char* cmd,char* arg) 
{
 player* who;
 const struct soc_struct* ss;
 ss=socs;

 while (ss->name)
 {
   if (!mystrcasecmp(ss->name,cmd))
   {
     if ((!*arg) && (ss->type!=0))
     {
       sprintf(mssg," Format: %s <player>\n",ss->name);
       send_pager(p,mssg);
       return(1);
     }
     
     if (ss->type==0)
     {
       sprintf(mssg,"%s %s\n",fullname(p),ss->maction);
       send_player_ignore(p,mssg,SAY);
       sprintf(mssg,"%s\n",ss->action);
       send_pager(p,mssg);
       return(1);
     }

     else
     if (ss->type==1)
     {
        who=find_player_soft(arg);
        if (!who) return(1);
        sprintf(mssg,"%s %s\n",fullname(p),ss->maction);
        bold(who,1); 
	send_pager(who,mssg);
        bold(who,0); 
	send_pager(who,"\n");
        sprintf(mssg,ss->action,who->name);
        send_pager(p,mssg);
        send_pager(p,"\n");
        return(1);
     }
     if (ss->type==2)
     {
        who=find_player_soft(arg);
        if (!who) return(1);
        sprintf(mssg,"%s %s\n",fullname(p),ss->maction);
        bold(who,1);
        send_pager(who,mssg);
        bold(who,0);
        send_pager(who,"\n");
        sprintf(mssg,ss->action,who->name);
        send_pager(p,mssg);
        send_pager(p,"\n");
        sprintf(mssg,ss->raction,p->name,who->name);
        send_room_wall_bar(p,who,mssg,p->room);
        send_room_wall_bar(p,who,"\n",p->room);
        return(1);
     }
   }
   ss++;
 }
 return(0);
}

