/*
 * room.c
 * ~~~~~~ room commands
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "player.h"
#include "config.h"
#include "proto.h"

/*------------------------Room Files/Structure------------------------*/
char* room_files[]={
                      "Pmain.txt",          /* ROOM1    0 */
                      "Pnewbie.txt",        /* ROOM2    1 */
                      "Proom1.txt",         /* ROOM3    2 */
                      "Proom2.txt",         /* ROOM4    3 */
                      "Proom3.txt",         /* ROOM5    4 */
                      "Pstaff.txt",         /* ROOM6    5 */
                      "Proom4.txt",         /* ROOM7    6 */
                      "Pjail.txt",          /* ROOM8    7 */
                      "Proom5.txt",         /* ROOM9    8 */
                      NULL,NULL
                     };
char* room_data[MAX_GLOBAL]={NULL};

/* Room Structure!
 *
 *    "room1",2,ROOM3,RRESIDENT,"enters a room.","is in room1",
 *       |    |   |       |            |              |
 *       |    |   |       |            |              |---> Where Msg
 *       |    |   |       |            |------------------> Enter msg
 *       |    |   |       |-------------------------------> Room Priv
 *       |    |   |---------------------------------------> Room TXT File
 *       |    |-------------------------------------------> Room Number
 *       |------------------------------------------------> Room Name
 */

const struct room_struct rooms[]={
"main",0,ROOM1,RRESIDENT,"enters the main room","is in tha main room",
"newbie",1,ROOM2,RRESIDENT,"enters the newbie area.","is in the newbie area.",
"room1",2,ROOM3,RRESIDENT,"enters a room.","is in room1",
"room2",3,ROOM4,RRESIDENT,"enters a room.","is in room2",
"room3",4,ROOM5,RRESIDENT,"enters a room.","is in room3",
"staff",5,ROOM6,RSU,"visits the staff room.","is in the staff room!!",
"room4",6,ROOM7,RRESIDENT,"enters a room.","is in room4",
"jail",7,ROOM8,RSU,"is sent to jail.","has been sent to jail!",
"room5",8,ROOM9,RRESIDENT,"enters a room.","is in room5",
NULL,0,0,0,NULL,NULL,
                             };

/*------------------------Load Rooms to Memory------------------------*/
int load_rooms(void)
{
 char **fil,**dat;
 FILE* han;
 char* buf;
 char fname[MAX_LINE];

 dat=room_data;
 fil=room_files;

 while (*fil)
       {
        if (*dat) {free(*dat); *dat=NULL;}
        sprintf(fname,ROOM_PATH,(*fil)+1);
        buf=strap_file(fname);
        if (!buf)
           {
            sprintf(mssg,"Unable to open %s for read.\n",*fil);
            tolog("globals",mssg);
            *dat=strdup("<null>");
           }
        else
           {
            *dat=strdup(buf);
            if ((*fil)[0]=='L') killendcr(*dat);
           }
        fil++; dat++;
       }
 return(1);
}

/*---------------------------Room Commands----------------------------*/
int go(player* p,char* cmd)
{
 int rold=p->room;
 const struct room_struct* rs;
 rs=rooms;
 
 while (rs->name)
       {
        if (!mystrcasecmp(rs->name,cmd))
           {
	    if (!(p->roomflags&rs->priv))
	    {
		send_pager(p," Sorry that room is locked.\n");
		return(0);
	    }
	    if (p->room==rs->room)
	    {
 	        send_pager(p," You are already in that room!!\n");
		return(0);
	    }
	    sprintf(mssg,"%s %s\n",p->name,p->emsg);
 	    send_room_wall(p,mssg,rs->room);
	    p->room=rs->room;
            sprintf(mssg,"%s %s\n",p->name,rs->emsg);
            send_room_wall(p,mssg,rold);
	    look(p,NULL);
            return(0);
            }
        rs++;
       }
 send_pager(p,"Unknown room. \n");
 return(list_rooms(p,NULL));
}

int list_rooms(player* p,char* str)
{
 int cnt=0;
 const struct room_struct* rs;
 char* oldstack; SLINK(oldstack);

 rs=rooms;
 send_pager(p,"Rooms available to you are:-\n");
 while (rs->name)
       {
	if((p->roomflags&rs->priv)==rs->priv)
	 {
            if (cnt>65) {*stack++='\n'; cnt=0;}
            if (cnt)
               sprintf(stack,", %s",rs->name);
            else
               sprintf(stack," %s",rs->name);
            cnt+=strlen(stack);
            SNEXT;
	 }
        rs++;
       }
 *stack++='\n'; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(1);
}

int grab(player* p,char* str)   
{
 player* who;

 if (!*str)
 {
  send_pager(p," Format: grab <player>\n");
  return(0);
 }

 who=player_arg(p,&str);
 if(!who) return(0);
 if(!bestprivsloud(p,who)) return(0);

 sprintf(mssg,"%s is grabbed from the room.\n",who->name);
 send_room_wall(who,mssg,who->room);
 who->room=p->room;
 sprintf(mssg,"%s is grabbed into the room.\n",who->name);
 send_room_wall(who,mssg,who->room);
 look(who,NULL);
 return(0);
}

int go_main(player* p,char* str) 
{
 sprintf(mssg,"%s %s\n",p->name,rooms[0].emsg);
 send_room_wall(p,mssg,p->room);
 p->room=0;
 sprintf(mssg,"%s %s\n",p->name,p->emsg);
 send_room_wall(p,mssg,p->room);
 look(p,NULL);
 return(0);
}

int go_comfy(player* p,char* str) 
{
 sprintf(mssg,"%s %s\n",p->name,rooms[5].emsg);
 send_room_wall(p,mssg,p->room);
 p->room=5;
 sprintf(mssg,"%s %s\n",p->name,p->emsg);
 send_room_wall(p,mssg,p->room);
 look(p,NULL);
 return(0);
}

int join(player* p,char* str)   
{
 player* who;

 if (!*str)
 {
  send_pager(p," Format: join <player>\n");
  return(0);
 }

 who=player_arg(p,&str);
 if(!who) return(0);

 if(!(p->roomflags&rooms[who->room].priv))
 {
  send_pager(p," Sorry you can not enter that room.\n");
  return(0);
 }
 sprintf(mssg,"%s %s\n",p->name,rooms[who->room].emsg);
 send_room_wall(p,mssg,p->room);
 p->room=who->room;
 sprintf(mssg,"%s %s\n",p->name,p->emsg);
 send_room_wall(p,mssg,p->room);
 look(p,NULL);
 return(0);
}

int go_home(player* p,char* str)
{
 if (p->home) 
	return(go(p,p->home));
 else
 if (p->room==0)
	{
	  send_pager(p," You are already in that room.\n");
	  return(0);
	}
 else
	return(go_main(p,NULL));
}

int set_home(player* p,char* str)
{
 sprintf(mssg," You set your home to be '%s'\n",rooms[p->room].name);
 send_pager(p,mssg);
 p->home=strdup(rooms[p->room].name);
 return(0);
}

