/*
 * Robot.c
 * ~~~~~~~  Robot code
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "player.h"
#include "proto.h"
#include "config.h"

/*-----------------------Miscalaneous Commands------------------------*/

/*--------------------------Robot Commands----------------------------*/
int robot_do(player* p, char* str)
{
 player* 	who;
 char*		cmd;

 if (!*str)
 {
   send_pager(p," Format: robot <sub command>\n");
   send_pager(p," see help robot\n");  
   return(0);
 }

 if (!strcmp(str,"load"))
 {
   load_robot(p,robot);
   return(0);
 }

 who=find_player(robot);
 if (!who)
 {
   send_pager(p," No robot Loaded!!!\n");
   return(0);
 }

 cmd=nextword(&str);
 dispatch_command(who,cmd,str);

 return(0);
}

/*-----------------------Load-save-quit Robot-------------------------*/
int load_robot(player* p, char* name)
{
 player* who;

 who=find_player_hard(name);
 who->active|=GAME;
 who->active|=IS_ROBOT;

 /* Announce the arival of the Robot */
 sprintf(mssg,"%s %s\n",who->name,who->emsg);
 send_room_wall(who,mssg,who->room);

 return(0);
}

int save_robot(player* p, player* name)
{
 return(save_player(name));
}

int logoff_robot(player* p, player* name)
{
 return(logoff_player(name));
}
