/*
 * Proto.h
 * ~~~~~~~       Extern's & Proto's
 */

/*-------------------------Genral Definitions-------------------------*/
	#define 	AND_STRING	"AND "
	#define 	AND_STRING_LEN	4
	#define 	BUT_STRING	"BUT "
	#define 	BUT_STRING_LEN	4
	#define 	SLINK(x)	{x=stack;}
	#define 	SUNLINK(x)	{stack=x;}
	#define 	SNEXT		{stack=strchr(stack,0);}
	#define 	SEND		{*(stack++)=0;}
	#define 	MAX_TAGS 	256
	#define 	TAG2STR_MEM 	MAX_TAGS*10
	#define		MAX_PASS_FAIL	3
	#define 	PAGER_PAGE 	23
	#define 	STACK_SIZE 	4096
	#define 	MAX_IDLE_NOCOUNT 50*6
	#define 	EOR_ON  	(1<<0)
	#define 	IAC_ON  	(1<<1)
	#define 	GLOBAL_BUFFER   8192
	#define 	MAX_GLOBAL      30
	#define 	G_PICTURE       0
	#define 	G_LOGINMSG      1
	#define 	G_SITEBAN       2
	#define 	G_BYE           3
	#define 	G_NUKE          4
	#define 	G_MOTD          5
	#define 	G_SUMOTD        6
	#define 	G_DRAG          7
	#define 	G_ASSIST        8
	#define 	G_BAN           9
	#define 	G_VERSION       10
	#define		G_RCOUNT	11
	#define		G_NEWBIEMSG	12
	#define 	ROOM1         	0
	#define		ROOM2		1
	#define		ROOM3		2
	#define		ROOM4		3
	#define		ROOM5		4
	#define		ROOM6		5
	#define		ROOM7		6
	#define		ROOM8		7
        #define         ROOM9         	8
        #define 	CCOMMS  	(1<<0)
        #define 	CMOVE   	(1<<1)
        #define 	CINFO   	(1<<2)
        #define 	CCUST   	(1<<3)
        #define 	CMISC   	(1<<4)
        #define 	CLIST   	(1<<5)
        #define 	CSU     	(1<<6)
        #define 	CADMIN  	(1<<7)
        #define 	CCODER  	(1<<8)
        #define 	CLAW    	(1<<9)
        #define 	CMIN    	(1<<10)
        #define 	CWEB    	(1<<11)
        #define 	CROBOT   	(1<<12)

        extern int      robot_auto;
        extern char     robot[30];

	typedef player** Tag;
	char	 	mssg[MAX_LINE];
	char		cmsg[MAX_LINE];

/*------------------------------Adcom.c-------------------------------*/
	int 		watch_player(player*,char*);
	int 		watch_list(player*,char*);
	int 		genelist(player*,char*);
	int		rm_move(player*,char*);
	int		force(player*,char*);
	int 		check_info(player*,char*);
	int		snew(player*,char*);
	int		set_ipnum(player*,char*);
	int		vbanish(player*,char*);
	int		set_ipname(player*,char*);
	int		debug(player*,char*);
	int 		reset_motd(player*,char*);
	int 		reset_sumotd(player*,char*);
	int		do_backup(player*,char*);
	int		list_pen_flags(player*,char*);
	int 		set_lsu(player*,char*);	
	int		bump(player*,char*);
	int 		hc_comment(player*,char*);
	int		edtime(player*,char*);
	int 		adhide(player*,char*);
	int 		reset_idle(player*,char*);
	int 		banish_site(player*,char*);
	int 		unbanish_name(player*,char*);
	int 		banish_name(player*,char*);
	int 		aecho(player*,char*);
	int 		becho(player*,char*);
	int 		vlog(player*,char*);
	int 		wall_talker(player*,char*);
	int		wall_su(player*,char*);
	int		wall_admin(player*,char*);
	int		wall_hcadmin(player*,char*);
	int 		reload(player*,char*);
	int 		abort_shutdown(player*,char*);
	int 		shutdown_talker(player*,char*);

/*------------------------------Base.c--------------------------------*/
	player* 	player_arg(player*,char**);
	player* 	player_arg_hard(player*,char**);
	Tag 		player_arg_tag(player*,char**);
	Tag 		player_arg_tag_hard(player*,char**);
	Tag 		player_arg_tag_multi(player*,char**,int);
	int		repeat(player*,char*);
	int 		update_newnews(player*,char*);
	int 		show_file(player*,char*);
	int		do_debug(char*,char*);
	int 		tolog(char*,char*);
	int 		log_count(player*,char*);
	int 		su_wall(player*,char*,int);
	int 		reset_flag(player*,char*,int);
	int 		su_wall1(player*,char*,char*,int);
	int 		su_wall2(player*,char*,char*,char*,int);
	int 		telltime(player*,char*);
	void 		stackbar(void);
	void		stackwhere(player*);
	void		stackwhereadmin(player*);
	void 		stackfullname(player*);
	void 		stackdesc(player*);
	void 		stackemail(player*,player*);
	void 		stacksucomment(player*,player*);
	void 		stackurl(player*);
	void 		stackirl(player*);
	void		stackmarry(player*);
	void 		stackplan(player*);
	void 		stacklogintime(player*);
	void 		stackidletime(player*);
	void 		stackip(player*);
	void 		stackoldip(player*);
	void 		stackcurrentlogin(player*p);
	void 		stackoldip(player* who);
	char* 		nextword(char**);
	char* 		strap_file(char* name);
	char* 		fullname(player*);
	char*           bit_string(int);

/*---------------------------Basic(2).c-------------------------------*/
	int		helpme(player*,char*);
	int		comment(player*,char*);
	int		comments(player*,char*);
	int		session(player*,char*);
	int		saved_msg(player*,char*);
	int 		hide(player*,char*);
	int		whois(player*,char*);
	int		pinfo(player*,char*);
	int		shout(player*,char*);
	int 		version(player*,char*);
	int 		seeecho(player*,char*);
	int 		echo(player*,char*);
	int 		recho(player*,char*);
	int 		idea_report(player*,char*);
	int		back(player*,char*);
	int		ownpriv(player*,char*);
	int		birthday(player*,char*);
	int 		see_session(player*,char*);
	int 		private(player*,char*);
	int 		toggle(player*,char*);
	int		bop(player*,char*);
	int		rbop(player*,char*);
	int 		bug_report(player*,char*);
	int 		motd_check(player*,char*);
	int 		who(player*,char*);
	int		where(player*,char*);
	int 		examine(player*,char*);
	int 		finger(player*,char*);
	int 		quit(player*,char*);
	int 		tell(player*,char*);
	int 		title(player*,char*);
	int 		prefix(player*,char*);
	int		rlname(player*,char*);
	int		rlloc(player*,char*);
	int 		desc(player*,char*);
	int		age(player*,char*);
	int 		email(player*,char*);
	int		loginmsg(player*,char*);
	int		logoutmsg(player*,char*);
	int		entermsg(player*,char*);
	int 		url(player*,char*);
	int 		plan(player*,char*);
	int 		prompt(player*,char*);
	int 		password(player*,char*);
	int 		save(player*,char*);
	int 		say(player*,char*);
	int 		sing(player*,char*);
	int 		rsing(player*,char*);
	int 		commands(player*,char*);
	int 		pemote(player*,char*);
	int 		emote(player*,char*);
	int 		think(player*,char*);
	int 		remote(player*,char*);
	int 		premote(player*,char*);
	int 		rthink(player*,char*);
	int 		help(player*,char*);
	int 		vnew(player*,char*);
	int 		disclaimer(player*,char*);
	int 		rules(player*,char*);
	int 		res_count(player*,char*);
	int 		look(player*,char*);
	int 		ignore(player*,char*);
	int 		whisper(player*,char*);
	int 		wake(player*,char*);
	int 		set_gender(player*,char*);
        extern int      session_time;
        extern char     session_is[];
        extern char     session_did[];

/*----------------------------Channel.c-------------------------------*/
	int		zz_list(player*,char*);
	int		zz_who(player*,char*);
	int		zz_join(player*,char*);
	int 		zz_tell(player*,char*);
	int 		zz_emote(player*,char*);
	int 		zz_think(player*,char*);
	int 		zz_sing(player*,char*);
	int 		zz_echo(player*,char*);
	int 		zz_pemote(player*,char*);
	int 		hc_tell(player*,char*);
	int 		hc_emote(player*,char*);
	int 		hc_think(player*,char*);
	int 		hc_sing(player*,char*);
	int 		hc_echo(player*,char*);
	int 		hc_pemote(player*,char*);
	int 		robot_tell(player*,char*);
	int 		robot_emote(player*,char*);
	int 		robot_emote2(player*,char*);
	int 		robot_think(player*,char*);
	int 		robot_sing(player*,char*);
	int 		robot_echo(player*,char*);
	int 		robot_pemote(player*,char*);
	int 		au_tell(player*,char*);
	int 		au_emote(player*,char*);
	int 		au_think(player*,char*);
	int 		au_sing(player*,char*);
	int 		au_echo(player*,char*);
	int 		au_pemote(player*,char*);
	int 		spod_tell(player*,char*);
	int 		spod_emote(player*,char*);
	int 		spod_think(player*,char*);
	int 		spod_sing(player*,char*);
	int 		spod_echo(player*,char*);
	int 		spod_pemote(player*,char*);
	int 		su_tell(player*,char*);
	int 		su_emote(player*,char*);
	int 		su_think(player*,char*);
	int 		su_sing(player*,char*);
	int 		su_echo(player*,char*);
	int 		su_pemote(player*,char*);
	int 		channel_tell(player*,char*,Tag,char*);
	int 		channel_emote(player*,char*,Tag,char*);
	int 		channel_think(player*,char*,Tag,char*);
	int 		channel_sing(player*,char*,Tag,char*);
	int 		channel_echo(player*,char*,Tag,char*);
	int 		channel_pemote(player*,char*,Tag,char*);

/*-----------------------------Check.c--------------------------------*/
	int		do_check(player*,char*);

/*-----------------------------Clock.c--------------------------------*/
	int 		shutdown_messages(void);
	int 		check_uptime(player*,char*);
	int 		current_time(void);
	void 		timer_expires(int);
	char* 		sec2str(int);
	char* 		time2str(int);
	char* 		time2strshort(int);
	char* 		time2asc(int);

/*----------------------------Commands.c------------------------------*/
	int 		dispatch_command(player*,char*,char*);
	int 		mystrcasecmp(char*,char*);

/*-----------------------------Editor.c-------------------------------*/
	int 		editor_line(player*,char*);
	int 		editor_on(player*,int (*done)(player*,char*,void*),void*);

/*-----------------------------Friends.c------------------------------*/
	friend* 	friend_find(player*,char*);
	int 		friend_cmd(player*,char*);
	int 		friend_add(player*,char*,int);
	int 		friend_list(player*,char*);
	int 		tf(player*,char*);
	int 		rf(player*,char*);
	int 		rfo(player*,char*);
	int 		tfo(player*,char*);
	int 		add_tag_friends(player*,Tag,int);
	int 		clist(player*,char*);
	int 		friend_flags(player*,char*);
	int 		fwho(player*,char*);
	int 		friend_remove(player*,friend*);
	int 		isignore(player*,player*);

/*----------------------------Globals.c-------------------------------*/
	int 		load_globals(void);
	extern char* 	global_data[];
	extern int 	uptime;
	extern int 	numlogins;
	extern int 	spodtime;

/*------------------------------List.c--------------------------------*/
	int		list_newbies(player*,char*);
	int		list_lawyer(player*,char*);
	int		list_minister(player*,char*);
	int		list_spods(player*,char*);
	int 		list_su(player*,char*);
	int		list_admin(player*,char*);
	int 		list_idle(player*,char*);
	int		list_site(player*,char*);
	int		make_list(player*,char*,int);

/*-----------------------------Login.c--------------------------------*/
	int 		login_message(player*);
	int 		get_email(player*);
	int 		got_email(player*,char*);
	int 		check_banish(player*);
	int 		check_sitebanish(player*);
	int 		get_name(player*);
	int 		got_name(player*,char*);
	int 		start_login(player*);
	int 		get_pass(player*);
	int 		got_pass(player*,char*);

/*------------------------------Make.c--------------------------------*/
	int		make_hfile(player*,char*,int);
	int		make_hfile2(player*,char*);

/*-----------------------------Marry.c--------------------------------*/
	int		medit(player*,char*);
	int 		propose(player*,char*);
	int		engage(player*,char*);
	int		unengage(player*,char*);
	int		marry(player*,char*);
	int		divorce(player*,char*);				
	int		anull_eng(player*,char*);
	int		anull_mar(player*,char*);

/*----------------------------Muffle.c--------------------------------*/
	int		muffle_chan(player*,char*);

/*------------------------------News.c--------------------------------*/
	#ifndef notes_h
 	 #define notes_h
	#endif

	char* 		string2arg(char*);
	int 		strlento(char*,char);
	int		load_counter(void);
	int		save_counter(void);
	int		load_news_counter(void);
	int		save_news_counter(void);
	int		ad_post(player*,char*);
	int		ad_read(player*,char*);
	int 		sunews_cmd(player*,char*);
	int 		sunews_check(player*,char*);
	int 		sunews_post(player*,char*);
	int 		sunews_dopost(player*,char*,void*);
	int 		sunews_read(player*,char*);
	int 		sunews_delete(player*,char*);
	int 		news_cmd(player*,char*);
	int 		news_check(player*,char*);
	int 		news_post(player*,char*);
	int 		news_dopost(player*,char*,void*);
	int 		news_read(player*,char*);
	int 		news_delete(player*,char*);
	int 		mail_cmd(player*,char*);
	int 		mail_check(player*,char*);
	int 		mail_post(player*,char*);
	int 		mail_dopost(player*,char*,void*);
	int 		mail_read(player*,char*);
	int 		mail_delete(player*,char*);
	int 		notes_create(char*,char*,char*,char*);
	char* 		notes_load(int,char**,char**,char**);
	int 		notes_read(player*,char*);
	int 		notes_remove(int);
	int 		notes_listload(int*,char*);
	int 		notes_listsave(int*,FILE*);
	int 		notes_unlink(int*,int);
	int 		notes_link(int*,int);
	
/*------------------------------Pager.c-------------------------------*/
	char* 		next_line(char**,int*);
	int 		send_pager(player*,char*);
	int 		pager_nextpage(player*,char*);

/*----------------------------Player.c--------------------------------*/
	extern player* 	first_player;
	extern char* 	stack;
	player*		new_player(); 
	player*		load_player(player*,char*);
	player*		find_player(char*);
	player*		find_player_soft(char*);
	player*		find_player_hard(char*);
	player*		find_player_hard_nosoft(char*);
	int 		update_players(player*,char*);
	int		save_player(player*);
	int 		kill_player(player*);
	int 		logoff_player(player*);
	int 		logoff_player_hard(player*);
	int 		logoff_all(void);
	int 		send_player_ignore(player*,char*,int);
	int 		delete_player(char*);
	int 		unidle(player* p);
	DIR* 		lsr_start();
	char* 		lsr_next(DIR*);
	void 		lsr_end(DIR*);
				
/*------------------------------Privs.c-------------------------------*/
	int		list_privs(player*);
	int 		bestprivsloud(player*,player*);
	int 		revokep(player*,char*);
	int 		grant(player*,char*);
	int 		privs(player*,char*);
	int		list_priv_flags(player*,char*);

/*------------------------------robot.c-------------------------------*/
	int		robot_do(player*,char*);
	int		load_robot(player*,char*);
	int		save_robot(player*,player*);
	int		logoff_robot(player*,player*);

/*-------------------------------room.c-------------------------------*/
	int		go_home(player*,char*);
	int		set_home(player*,char*);
        int             load_rooms(void);
        extern char*    room_data[];
	int 		go(player* p,char* cmd);
	int 		list_rooms(player* p,char* str);
	int		grab(player*,char*);
	int		go_main(player*,char*);
	int		go_comfy(player*,char*);
	int		join(player*,char*);

/*-----------------------------Socket.c-------------------------------*/
	int 		send_room_wall(player*,char*,int);
	int 		send_room_wall_bar(player*,player*,char*,int);
	int 		send_wall(char*,int);
	int 		send_wall_bar(player*,char*,int);
	int 		bold(player*,int);
	int 		bold_tag(Tag,int);
	int 		scan_socks();
	int 		scan_new();
	int 		setupsock();
	int 		main(int,char**);
	int 		entered_line(player*,char*);
	int 		killendjunk(char*);
	int 		killendcr(char*);
	int 		makelower(char*);
	int 		send_player_real(player*,char*);
	int 		send_itsprompt(player*);
	int 		password_mode(player*,int);
	int 		telnet_options(player*);
	void 		signal_exit(int);
	void 		clean_exit(void);
	void		do_alive_ping();
	extern player* 	current_player;
	extern int 	shutdown_time;
	extern char 	shutdown_reason[];
	extern int 	restart_scan;

/*----------------------------Social.c--------------------------------*/
	int 		do_social(player*,char*,char*);
	int		list_socials(player*,char*);

/*------------------------------sucom.c-------------------------------*/
	int		reset_session(player*,char*);
	int		confirm_res(player*,char*);
	int		rm_bop(player*,char*);
	int		rm_shout(player*,char*);
	int		rm_sing(player*,char*);
	int		gag(player*,char*);
	int		ungag(player*,char*);
	int		validate_email(player*,char*);
	int		saved_warn(player*,char*);
	int 		sumotd_check(player*,char*);
	int		yoyo(player*,char*);
	int 		su_comment(player*,char*);
	int		jail(player*,char*);
	int		unjail(player*,char*);
	int		showhelp(player*,char*);
	int 		on_su(player*,char*);
	int 		off_su(player*,char*);
	int 		blank(player*,char*);
	int 		warn(player*,char*);
	int 		trace(player*,char*);
	int 		assist(player*,char*);
	int 		dibbs(player*,char*);
	int 		drag(player*,char*);
	int 		resident(player*,char*);
	int 		nuke(player*,char*);  
	int 		scare(player*,char*);  
	int 		rename_cmd(player*,char*);
	int 		recap(player*,char*);

/*------------------------------Tag.c---------------------------------*/
	#ifndef tag_h
	 #define tag_h
	#endif

	char* 		next_pname(char**);
	char* 		tag2str(player*,Tag);
	Tag 		tag_byname(player*,char*);
	Tag 		tag_byname_hard(player*,char*);
	Tag 		tag_byname_multi(player*,char*,int);
	Tag 		find_tag(player*,Tag);
	Tag 		tag_new(void);
	int 		send_flexi(player*,char*,char*);
	int 		send_tag(Tag,char*);
	int 		add_tag(player*,Tag);
	int 		free_tag(Tag);
	int 		add_tag_name(player*,char*,Tag,int);
	int 		add_tag_everyone(player*,Tag,int);
	int 		add_tag_privs(player*,int,Tag,int);
	int 		add_tag_chan_privs(player*,int,Tag,int);
	int 		add_tag_zchan(player*,Tag,int);
	int 		isin_tag(player*,Tag);
	int 		remove_tag(player*,Tag);
	int 		tag_minus_tag(Tag,Tag);
	int 		tag_plus_tag(Tag,Tag);

/*------------------------------Web.c---------------------------------*/
	int		make_web_player(player*);
	int 		make_web_index(player*,char*);
	int 		make_players(player*,char*);
