/*
 * privs.c
 * ~~~~~~~  Grant - Revoke - Priv checking
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "player.h"
#include "proto.h"
#include "config.h"

/*---------------------------Priv Structure---------------------------*/

/* example:-
 *	"mail","is able to use mail.",0,MAIL,MAIL,SU,
 *	  |            |              |  |    |    |--> Priv Needed to Grant.
 *	  |            |              |  |    |-------> Actual Priv.
 *	  |            |              |  |------------> Privs Given.
 *	  |            |              |---------------> Room Priv Given.
 *	  |            |------------------------------> Statement of 'Privs'.
 *	  |-------------------------------------------> Priv Name.
 */

struct priv_item priv_table[]=
 {
  "banish","is a banished Character.",0,BANISHED,BANISHED,SU,
  "resident","is a resident.",RRESIDENT,RESIDENT,PRIV_RESIDENT_GRANT,SU,
  "list","has a friends list.",0,LIST,LIST,SU,
  "mail","is able to use mail.",0,MAIL,MAIL,SU,
  "echo","is able to echo.",0,ECHOPRIV,ECHOPRIV,SU,
  "room","is able to use rooms.",0,ROOM,ROOM,SU,
  "trace","is able to trace login sites.",0,TRACE,TRACE,SU,
  "tester","is able to test new commands.",0,TESTER,TESTER,TESTER,
  "shutdown","is able to shutdown the talker.",0,SHUTDOWN,SHUTDOWN,LA,
  "nuke","is able to nuke people.",0,NUKE,NUKE,ADMIN,
  "hide","is able to hide.",0,CAN_HIDE,CAN_HIDE,ADMIN,
  "spod","is a Spod.",0,SPOD,SPOD,ADMIN,
  "vlog","is able to view the talker log files.",0,VLOG,VLOG,ADMIN,
  "web","is a webmaster.",0,WEB,WEB,WEB,
  "minister","is a minister",0,MINISTER,MINISTER,MINISTER,
  "lawyer","is a lawyer",0,LAWYER,LAWYER,LAWYER,
  "siteadmin","is a Site Admin.",0,SADMIN,SADMIN,ADMIN,  
  "psu","is a Trainee Super User",RSU,PSU,PSU,LA,
  "su","is a Super User.",RSU,SU,SU|TRACE,LA,
  "loweradmin","is a Lower Administrator.",0,LA,LA|VLOG|SHUTDOWN|NUKE,ADMIN,
  "admin","is an Administrator.",RADMIN,ADMIN,ADMIN,HCADMIN,
  "coder","is a Coder.",0,CODER,CODER,CODER,
  "robot","is a Robotics Expert",0,ROBOT_MASTER,ROBOT_MASTER,ROBOT_MASTER,
  "spook","is a Spook.",0,SPOOK,SPOOK,SPOOK,
  "hcadmin","is a Hard Coded Administrator.",RHCADMIN,HCADMIN,HCADMIN|HIDE,HCADMIN,
   NULL,NULL,0,0,0,0
};

/*---------------------------Priv Checking----------------------------*/
int bestprivsloud(player* p,player* who)
{
char privmsg[100];
 if (!strcmp(who->lower_name,"admin"))
    {
     send_pager(p," You do not have permissions to do that to Admin.\n");
     return(0);
    }
 else 
 if ((p->privs>who->privs) || (p==who && p->privs&HCADMIN) || (!strcmp(p->lower_name,"admin")))
    {
     return(1);
    }
 else
    {
     sprintf(privmsg," You do not have permissions to do that to '%s'\n",who->name);
     send_pager(p,privmsg);
     return(0);
    }
}

/*--------------------------Priv Grant/Revoke-------------------------*/
int revokep(player* p,char* str)
{
 char* newstr;
 int res;

 newstr=malloc(strlen(str)+2);
 *newstr='-';
 strcpy(newstr+1,str);
 res=grant(p,newstr);
 free(newstr);
 return(res);
}

int grant(player* p,char* str)
{
 struct priv_item* pv;
 player* who;
 int revoke=0;

 if (*str=='-' && p->privs&ADMIN)
    {
     str++; revoke=1;
    }

 if (*str)
    {
     who=player_arg_hard(p,&str);
     if (!who) return(0);
    }
 else
    {
     if (revoke)
        send_pager(p," Format: revoke <player> <privs>\n");
     else
        send_pager(p," Format: grant <player> <privs>\n");
     list_privs(p);
     return(0);
    }

 if (!*str)
    {
     if (revoke)
        send_pager(p," Format: revoke <player> <privs>\n");
     else
        send_pager(p," Format: grant <player> <privs>\n");
     list_privs(p);
     unload_hard(who);
     return(0);
    }

 if (!bestprivsloud(p,who))
    {
     unload_hard(who);
     return(0);
    }

 pv=priv_table;
 while (pv->name)
       {
        if (!strcasecmp(pv->name,str))
           {
            if (p->privs&pv->priv || p->privs&HCADMIN)
               {
                if (revoke)
                   {
                    who->privs&=~pv->gives;
		    who->roomflags&=~pv->room;
                    sprintf(mssg," -=> %s has revoked your '%s' permissions.\n",p->name,pv->name);
		    send_pager(who,mssg);
                    sprintf(mssg," You revoke '%s' permissions from %s.\n",pv->name,who->name);
		    send_pager(p,mssg);
                    su_wall2(p,"revokes '%s' permissions from %s.",pv->name,who->name,SU);
                    sprintf(mssg,"%s revokes '%s' from %s\n",p->name,pv->name,who->name);
                    tolog("grant",mssg);
                   }
                else
                   {
                    who->privs|=pv->gives;
		    who->roomflags|=pv->room;
		    who->pensflags|=SU_DUTY;
                    sprintf(mssg," -=> %s has granted you '%s' permissions.\n",p->name,pv->name);
		    send_pager(who,mssg);
                    sprintf(mssg," You grant %s '%s' permissions.\n",who->name,pv->name);
		    send_pager(p,mssg);
                    su_wall2(p,"grants '%s' permissions to %s.",pv->name,who->name,SU);
                    sprintf(mssg,"%s grants '%s' to %s\n",p->name,pv->name,who->name);
                    tolog("grant",mssg);
                   }

                unload_hard(who);
                return(1);
               }
            else
               { 
                if (revoke)
                   sprintf(mssg," You do not have permissions to revoke '%s' permissions.\n",pv->name);
                else
                   sprintf(mssg," You do not have permissions to grant '%s' permissions.\n",pv->name);
		send_pager(p,mssg);
                unload_hard(who);
                return(0);
               }
           }
        pv++;
       }
 send_pager(p," Can not find that permission.\n");
 list_privs(p);
 unload_hard(who);
 return(0);
}

/*------------------------------Show Priv-----------------------------*/
int list_privs(player* p)
{
 int cnt=0;
 struct priv_item* pv;
 char* oldstack; SLINK(oldstack);

 pv=priv_table;
 send_pager(p,"Privs Grantable by you:-\n");
 while (pv->name)
       {
	if((p->privs&pv->require)==pv->require)
	 {
            if (cnt>65) {*stack++='\n'; cnt=0;}
            if (cnt)
               sprintf(stack,", %s",pv->name);
            else
               sprintf(stack," %s",pv->name);
            cnt+=strlen(stack);
            SNEXT;
	 }
        pv++;
       }
 *stack++='\n'; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(1);
}

int privs(player* p,char* str)
{
 struct priv_item* pv;
 player* who;
 char* oldstack;

 SLINK(oldstack);

 if ((*str)&&p->privs&SU)
    {
     who=player_arg_hard(p,&str);
     if (!who) return(0);
    }
 else
     who=p;

 *stack=0;

 pv=priv_table;
 while (pv->name)
       {
        if ((pv->priv&who->privs)==pv->priv)
           {
               sprintf(stack," %s %s\n",who->name,pv->desc); 
            SNEXT;
           }
        pv++;
       }

 if (stack==oldstack)
    {
     sprintf(stack,"%s does not have any privs.\n",who->name);
     SNEXT;
    }

 SEND;
 send_pager(p,oldstack);

 SUNLINK(oldstack);
 unload_hard(who);

 return(1);
}

int list_priv_flags(player* p,char* str)
{
 player* who;
 char* oldstack;

 if (!*str)
 {
    send_pager(p," Format: list_priv <player>\n");
    return(0);
 }

 who=player_arg_hard(p,&str);
 if (!who) return(0);

 SLINK(oldstack);

 stackbar();
 sprintf(stack,"Priv flags for player %s\n",who->name);
 SNEXT;
 stackbar();
 sprintf(stack,"  |Res|       misc     | staff|\n");
 SNEXT;
 sprintf(stack,"BNRMLErTS ssntV MLW    SLARCshH\n");
 SNEXT;
 sprintf(stack,"0123456789012345678901234567890\n");
 SNEXT;
 sprintf(stack,bit_string(who->privs));
 SNEXT;
 sprintf(stack,"\n");
 SNEXT;
 stackbar();

 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 unload_hard(who);
 return(0);
}

