/*
 * player.h 
 * ~~~~~~~~      Player Setup.
 */

#include <dirent.h>

/*General Define's */
	#define NOTES_LIST_MAX	40
	#define MAX_LINE 	512

/*Active Flags (Non-Saveable) */
	#define SCAN 		(1<<0)   
	#define GAME 		(1<<1)
	#define QUIET 		(1<<2)
	#define VERIFY_PASS 	(1<<3)
	#define DIBBS 		(1<<4)
	#define TEMP  		(1<<5)
	#define GAG		(1<<6)
	#define SING		(1<<7)
	#define WATCHED		(1<<8)
	#define IS_ROBOT	(1<<9)
	#define MORPHED		(1<<10)

/*Priv Flags*/
 	#define BANISHED   	(1<<0)
	#define NEWBIE     	(1<<1)
	#define RESIDENT       	(1<<2)
	#define MAIL       	(1<<3)
	#define LIST            (1<<4)
	#define ECHOPRIV        (1<<5)
	#define ROOM     	(1<<6)
	#define TESTER     	(1<<7)
	#define SPOD       	(1<<8)
        #define SPARE3		(1<<9)
	#define SADMIN          (1<<10)
	#define SHUTDOWN   	(1<<11)
	#define NUKE       	(1<<12)
	#define TRACE      	(1<<13)
	#define VLOG       	(1<<14)
	#define SPARE4          (1<<15)
	#define MINISTER        (1<<16)
	#define LAWYER          (1<<17)
	#define WEB             (1<<18)
	#define SPARE8          (1<<19)
	#define SPARE9          (1<<20)
	#define SPARE10         (1<<21)
	#define PSU             (1<<22)
	#define SU         	(1<<23)
	#define LA         	(1<<24)
	#define ADMIN		(1<<25)
        #define ROBOT_MASTER	(1<<26)
	#define CODER		(1<<27)
	#define SPOOK		(1<<28)
	#define CAN_HIDE       	(1<<29)
	#define HCADMIN    	(1<<30)

	#define HCADMININIT (PRIV_RESIDENT_GRANT|NUKE|TRACE|SPOD|SHUTDOWN|VLOG|WEB|LAWYER|MINISTER|TESTER|SPOOK|CAN_HIDE|ROBOT_MASTER|SU|LA|ADMIN|CODER|HCADMIN)
	#define PRIV_RESIDENT_GRANT (RESIDENT|LIST|MAIL|ROOM|ECHOPRIV)

/*Ignore Flags*/
	#define LOGIN		(1<<0)
	#define SAY		(1<<1)
	#define FRIENDS		(1<<2)
	#define TELL		(1<<3)
	#define MARRY_PROP	(1<<4)
	#define SHOUTS		(1<<5)

/*Pens Flags*/
	#define PRIVATE         (1<<0)
	#define SEE_ECHO        (1<<1)
	#define HIDE            (1<<2)
	#define DEBUG           (1<<3)
	#define SU_DUTY         (1<<4)
	#define PROPOSE		(1<<5)
	#define ENGAGED		(1<<6)
	#define MARRIED		(1<<7)
	#define NEW_MOTD	(1<<8)
	#define NEW_SUMOTD      (1<<9)
	#define PENSPARE5       (1<<10)
	#define PENSPARE6       (1<<11)
	#define PENSPARE7       (1<<12)
	#define PENSPARE8       (1<<13)
	#define SEE_SESS        (1<<14)
	#define IP_PUB          (1<<15)
	#define PENSPARE11      (1<<16)
	#define PENSPARE12      (1<<17)
	#define PENSPARE13      (1<<18)
	#define PENSPARE14      (1<<19)
	#define SHOUT           (1<<20)
	#define BOP             (1<<21)
	#define PENSPARE17      (1<<22)
	#define PENSPARE18      (1<<23)
	#define PENSPARE19      (1<<24)
	#define PENSPARE20      (1<<25)
	#define M_SPOD          (1<<26)
	#define M_SU            (1<<27)
	#define M_ADMIN         (1<<28)
	#define M_HCADMIN       (1<<29)
	#define M_ROBOT         (1<<30)

/*Gender Flags*/
	#define UNKNOWN		0
	#define MALE		1
	#define FEMALE		2

/*Room Flags*/
        #define RNEWBIE         (1<<0)
        #define RRESIDENT       (1<<1)
        #define RSU             (1<<2)
        #define RADMIN          (1<<3)
        #define RHCADMIN        (1<<4)
        #define PRIVATE1        (1<<5)
        #define PRIVATE2        (1<<6)
        #define PRIVATE3        (1<<7)
        #define PRIVATE4        (1<<8)
        #define PRIVATE5        (1<<9)
        #define PRIVATE6        (1<<10)

/*Friend Structure*/
	struct friend_struct {
                      char* name;
                      int flags;
                      struct friend_struct* next;
                      struct friend_struct* prev;
                     };
	typedef struct friend_struct friend;

	#define FRIEND		1
	#define IGNORE		2


/*Player Structure*/
	struct player_struct {
               int fd,active;
               char buf[MAX_LINE];
               char repeat_type[MAX_LINE];
               char repeat_str[MAX_LINE];
               char* bufpt;
               struct player_struct* next;
               struct player_struct* prev;

               int (*iofunc)(struct player_struct*,char*);

               char* pagerbuf;

               /* Non saved data */

               	char 	lastchar;
               	char* 	ip_num;
               	char* 	ip_name;
               	char* 	oldpass;
		char*	comment;
		char*	who_spook;
               	int 	pass_fail;
               	int 	telnetopts;
               	int 	currentidle;
		int 	currentlogin;
		int 	room;
		int	hcip;

               char* editor_page;
               int (*editor_done)(struct player_struct*,char*,void*);	
               void* editor_extra;

               /* Start of saved data */

               	int 	privs;
               	int 	login_time;
               	int 	login_idle;
               	int 	last_login;
               	int 	pensflags;
	       	int 	roomflags;
               	int 	prompt_up;
               	int 	ignore;

               	int 	termtype;

               	char* 	name;   
               	char* 	lower_name;
               	char* 	title;
               	char* 	prefix;
               	char* 	desc;
               	char* 	prompt;
	       	char* 	pass;
               	char* 	email;
	       	char* 	url;
	       	char* 	emsg;
		char*	loginmsg;
		char*	logoutmsg;
	       	char* 	plan;
	       	char* 	zchan;
		int	age;
		int     gender;
		char*	bday;
		char*	star_sign;
	       	char* 	marry;
		char*	rlname;
		char*	rlloc;
	       	char* 	old_ip;
		char*	sucom;
		char*	hccom;
		char*   back;
		char*	lsu;
		char*	ownpriv;
               	friend*	friends;
               	int 	mail[NOTES_LIST_MAX];
               	int 	newmail;
		int	newnews;
		int	newsunews;
		char*	morph;
		char*	home;
		char*	smess;
		char*	swarn;
              };
	typedef struct player_struct player;

/*Priv Structure*/
	struct 	priv_item {
                   	char* name;
                   	char* desc;
			int room;
                   	int priv;
                   	int gives;
                   	int require;
               	};

	extern struct priv_item priv_table[];

/*Command Structure*/
	struct 	command_struct {
              		char* name;
              		int (*func)(player*,char*);
			int comtype;
              		int privs;
             	};

	const extern struct command_struct cmds[];

/*Make Structure*/
        struct  make_struct {
                        char*   name;
                        int     priv;
                };

     	const extern struct make_struct make[];

/*Muffle Structure*/
        struct  muffle_struct {
                        char*   name;
                        int     chan;
			int	priv;  
              };

        const extern struct muffle_struct muffle[];

/*Check Structure*/
        struct  check_struct {
                        char*   name;
                        int (*func)(player*,char*);
                        int     priv;
                };

        const extern struct check_struct check[];

/*Room Structure*/
        struct  room_struct {
                        char* 	name;
                        int   	room;
                        int 	desc;
			int 	priv;
			char*	emsg;
			char* 	where;
                };

     	const extern struct room_struct rooms[];		

/*Terminal Structure*/
	struct terminal		/* Terminal definitions */
	{
   		char           *name;
   		char           *bold;
   		char           *off;
   		char           *cls;
	};

/*Social Structure*/
	struct  soc_struct {
                        char*   name;
			int	type;
                        char*   maction;
                        char*   action;
                        char*   raction;
                };

     	const extern struct soc_struct socs[];

