/*
 * Player.c
 * ~~~~~~~~
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <dirent.h>
#include <time.h>
#include <unistd.h>

#include "player.h"
#include "proto.h"
#include "config.h"

player* first_player=NULL;

/*----------------------------Miscellaneous---------------------------*/
int unidle(player* p)
{
 /* Unidle the player */

 if (p->currentidle<MAX_IDLE_NOCOUNT)
     p->login_idle-=p->currentidle;
 p->currentidle=0;
 return(1);
}

/*----------------------------Dir Commands----------------------------*/
void lsr_end(DIR* dr)
{
 closedir(dr);
}

char* lsr_next(DIR* dr)
{
 struct dirent* de;
 de=readdir(dr);
 if (!de) {lsr_end(dr); return(NULL);}
 return (de->d_name);
}

DIR* lsr_start(char* dpath)
{
 DIR* dr;
 dr=opendir(dpath);
 return(dr); 
}

/*-------------------------Load - Save Player-------------------------*/
player* load_player(player* to,char* name)
{
 char fname[MAX_LINE];
 FILE* han;
 player* p;
 char line[MAX_LINE*2];
 char vu[MAX_LINE];
 char* rest;
 int flags;
 const struct room_struct* rs;
 rs=rooms;

 p=to;

 rest=strdup(name); makelower(rest);
 sprintf(fname,PFILES_PATH,rest);
 free(rest); rest=NULL;

 han=fopen(fname,"r");
 if (!han) return(NULL);

 if (!p) p=new_player();
 if (!p) {fclose(han); return(NULL);}
 
 p->room=0;

 while (!feof(han))
       {
        *line=0; fgets(line,1023,han); killendcr(line);
        *vu=0; sscanf(line,"%s",vu);        
        rest=line+strlen(vu); while (isspace(*rest)) rest++;

        if (!strcmp("friend",vu))
           {
            *vu=0; flags=0;
            sscanf(rest,"%s %d",vu,&flags);
            if (*vu) friend_add(p,vu,flags);
           }
        else
        if (!strcmp("name",vu)) p->name=strdup(rest);
        else
        if (!strcmp("lower_name",vu)) p->lower_name=strdup(rest);
        else
        if (!strcmp("prompt",vu)) p->prompt=strdup(rest);
        else
        if (!strcmp("login_time",vu)) p->login_time=atoi(rest);
        else
        if (!strcmp("login_idle",vu)) p->login_idle=atoi(rest);
        else
        if (!strcmp("last_login",vu)) p->last_login=atoi(rest);
        else
        if (!strcmp("privs",vu)) p->privs=atoi(rest);
        else
        if (!strcmp("termtype",vu)) p->termtype=atoi(rest);
        else
        if (!strcmp("newmail",vu)) p->newmail=atoi(rest);
        else
        if (!strcmp("newnews",vu)) p->newnews=atoi(rest);
        else
        if (!strcmp("newsunews",vu)) p->newsunews=atoi(rest);
        else
        if (!strcmp("title",vu)) p->title=strdup(rest);
        else
        if (!strcmp("ip_num",vu)) { p->ip_num=strdup(rest); p->hcip=1;}
        else
        if (!strcmp("ip_name",vu)){ p->ip_name=strdup(rest); p->hcip=1;}
	else
        if (!strcmp("prefix",vu)) p->prefix=strdup(rest);
        else
        if (!strcmp("desc",vu)) p->desc=strdup(rest);
        else
        if (!strcmp("pass",vu)) p->pass=strdup(rest);
        else
        if (!strcmp("email",vu)) p->email=strdup(rest);
        else
        if (!strcmp("url",vu)) p->url=strdup(rest);
        else
        if (!strcmp("plan",vu)) p->plan=strdup(rest);
        else
        if (!strcmp("home",vu)) p->home=strdup(rest);
        else
        if (!strcmp("pensflags",vu)) p->pensflags=atoi(rest);
        else
        if (!strcmp("roomflags",vu)) p->roomflags=atoi(rest);
        else
        if (!strcmp("gender",vu)) p->gender=atoi(rest);
        else
        if (!strcmp("old_ip",vu)) p->old_ip=strdup(rest);
        else
        if (!strcmp("mail",vu)) notes_listload(p->mail,rest);
        else
        if (!strcmp("sucom",vu)) p->sucom=strdup(rest);
        else
        if (!strcmp("hccom",vu)) p->hccom=strdup(rest);
        else
        if (!strcmp("emsg",vu)) p->emsg=strdup(rest);
        else
        if (!strcmp("loginmsg",vu)) p->loginmsg=strdup(rest);
        else
        if (!strcmp("logoutmsg",vu)) p->logoutmsg=strdup(rest);
        else
        if (!strcmp("age",vu)) p->age=atoi(rest);
        else
        if (!strcmp("bday",vu)) p->bday=strdup(rest);
        else
        if (!strcmp("star",vu)) p->star_sign=strdup(rest);
        else
        if (!strcmp("rlname",vu)) p->rlname=strdup(rest);
        else
        if (!strcmp("rlloc",vu)) p->rlloc=strdup(rest);
        else
        if (!strcmp("lsu",vu)) p->lsu=strdup(rest);
        else
        if (!strcmp("marry",vu)) p->marry=strdup(rest);
        else
        if (!strcmp("zchan",vu)) p->zchan=strdup(rest);
        else
        if (!strcmp("smess",vu)) p->smess=strdup(rest);
        else
        if (!strcmp("swarn",vu)) p->swarn=strdup(rest);
        else
        if (!strcmp("back",vu)) p->back=strdup(rest);
        else
        if (!strcmp("ownpriv",vu)) p->ownpriv=strdup(rest);
       }
 fclose(han);

 if(p->ip_num) 
 {
  sprintf(mssg,"%s (%s)",p->ip_num,p->ip_name);
  p->old_ip=strdup(mssg);
 }

 if (p->home)
 {
    while (rs->name)
       {
        if (!mystrcasecmp(rs->name,p->home))
                p->room=rs->room;
        rs++;
        }
 }

 return(p);
}

int save_player(player* p)
{
 char fname[MAX_LINE];
 FILE* han;
 friend* fp;

 unidle(p);

 /* Can't save a non ressie */

 if (!p) return(0);
 if (!(p->privs&RESIDENT)) return(0);

 /* Get the file */

 sprintf(fname,PFILES_PATH,p->lower_name);
 han=fopen(fname,"w");
 if (!han) return(0);


 /* Write out data to pfile*/

 fprintf(han,"login_time %d\n",p->login_time);
 fprintf(han,"login_idle %d\n",p->login_idle);
 fprintf(han,"last_login %d\n",p->last_login);
 fprintf(han,"privs %d\n",p->privs);
 fprintf(han,"pensflags %d\n",p->pensflags);
 fprintf(han,"roomflags %d\n",p->roomflags);
 fprintf(han,"gender %d\n",p->gender);
 fprintf(han,"termtype %d\n",p->termtype);
 fprintf(han,"age %d\n",p->age);
 fprintf(han,"newmail %d\n",p->newmail);
 fprintf(han,"newnews %d\n",p->newnews);
 fprintf(han,"newsunews %d\n",p->newsunews);
 fprintf(han,"old_ip %s\n",p->old_ip);
 if (p->name) fprintf(han,"name %s\n",p->name);
 if (p->lower_name) fprintf(han,"lower_name %s\n",p->lower_name);
 if (p->prompt) fprintf(han,"prompt %s\n",p->prompt);
 if (p->title) fprintf(han,"title %s\n",p->title);
 if (p->prefix) fprintf(han,"prefix %s\n",p->prefix);
 if (p->desc) fprintf(han,"desc %s\n",p->desc);
 if (p->pass) fprintf(han,"pass %s\n",p->pass);
 if (p->email) fprintf(han,"email %s\n",p->email);
 if (p->url) fprintf(han,"url %s\n",p->url);
 if (p->plan) fprintf(han,"plan %s\n",p->plan);
 if (p->sucom) fprintf(han,"sucom %s\n",p->sucom);
 if (p->hccom) fprintf(han,"hccom %s\n",p->hccom);
 if (p->home) fprintf(han,"home %s\n",p->home);
 if (p->emsg) fprintf(han,"emsg %s\n",p->emsg);
 if (p->loginmsg) fprintf(han,"loginmsg %s\n",p->loginmsg);
 if (p->logoutmsg) fprintf(han,"logoutmsg %s\n",p->logoutmsg);
 if (p->rlname) fprintf(han,"rlname %s\n",p->rlname);
 if (p->rlloc) fprintf(han,"rlloc %s\n",p->rlloc);
 if (p->lsu) fprintf(han,"lsu %s\n",p->lsu);
 if (p->zchan) fprintf(han,"zchan %s\n",p->zchan);
 if (p->marry) fprintf(han,"marry %s\n",p->marry);
 if (p->smess) fprintf(han,"smess %s\n",p->smess);
 if (p->swarn) fprintf(han,"swarn %s\n",p->swarn);
 if (p->bday) fprintf(han,"bday %s\n",p->bday);
 if (p->star_sign) fprintf(han,"star %s\n",p->star_sign);
 if (p->back) fprintf(han,"back %s\n",p->back);
 if (p->ownpriv) fprintf(han,"ownpriv %s\n",p->ownpriv);
 if (p->hcip) 
 {
   fprintf(han,"ip_num %s\n",p->ip_num);
   fprintf(han,"ip_name %s\n",p->ip_name);
 }
/* write out friends */

 fp=p->friends;
 while (fp)
       {
        fprintf(han,"friend %s %d\n",fp->name,fp->flags);
        fp=fp->next;
       } 

 /* write out notes */

 fprintf(han,"mail ");
 notes_listsave(p->mail,han);



 /* Close and quit */

 fclose(han);

 /* write out player webpage */
 #if defined(LIVE)
    #if defined(WEB_PAGE)
      make_web_player(p);
    #endif
 #endif

 return(1);
}

player* new_player()
{
 player* p;

 if (!first_player)
    {
     p=calloc(sizeof(player),1);
     first_player=p;
    }
 else
  {
     p=calloc(sizeof(player),1);
     first_player->prev=p;
     p->next=first_player;
     first_player=p;
    }

 /* Fd */
 
 p->fd=-1;

 /* room */
 p->room=1;

 /* Buffer */
 
 p->bufpt=p->buf;

 /* Basic junk */  
     
 p->privs|=NEWBIE;
 p->iofunc=NULL;
 p->prompt=strdup("Dragon> ");
 p->title=strdup("is new here, so be very nice");
 p->prefix=strdup("");
 p->desc=strdup("I should set a Description");  
 p->plan=strdup("I have no Plan in life!");
 p->emsg=strdup("enters the room.");
 p->loginmsg=strdup("enters the talker!");
 p->logoutmsg=strdup("quits the talker!");
 return(p);
}

/*---------------------------Logoff Player----------------------------*/
int kill_player(player* p)
{
 friend* fp;

 if (!p) return(0);

 if (!p->name) p->name=strdup("<null>");

 if (p==current_player) restart_scan=1;

 p->active=0;

 if (p==first_player)
    {
     first_player=first_player->next;
     if (first_player) first_player->prev=NULL;
    }
 else
    {
     if (p->prev)
        p->prev->next=p->next;
     if (p->next)
        p->next->prev=p->prev;
    }

 /* Free up stuff */

 if (p->fd>=0) {close(p->fd); p->fd=-1;}
 if (p->name) free(p->name);
 if (p->prompt) free(p->prompt);
 if (p->title) free(p->title);
 if (p->prefix) free(p->prefix);
 if (p->desc) free(p->desc);
 if (p->url) free(p->url);
 if (p->plan) free(p->plan);
 if (p->home) free(p->home);
 if (p->old_ip) free(p->old_ip);
 if (p->sucom) free(p->sucom);
 if (p->hccom) free(p->hccom);
 if (p->emsg) free(p->emsg);
 if (p->loginmsg) free(p->loginmsg);
 if (p->logoutmsg) free(p->logoutmsg);
 if (p->rlname) free(p->rlname);
 if (p->rlloc) free(p->rlloc);
 if (p->lsu) free(p->lsu);
 if (p->zchan) free(p->zchan);
 if (p->marry) free(p->marry);
 if (p->smess) free(p->smess);
 if (p->swarn) free(p->swarn);
 if (p->bday) free(p->bday);
 if (p->star_sign) free(p->star_sign);
 if (p->back) free(p->back);
 if (p->ownpriv) free(p->ownpriv);
 if (p->who_spook) free(p->who_spook);

 /* Free up friends */

 fp=p->friends;
 while (fp)
       {
        friend* fpn;
        fpn=fp->next;
        if (fp->name) free(fp->name);
        free(fp); fp=fpn;
       }

 free(p);
 return(1);
}

int unload_hard(player* p)
{
 if (!p->active)
    {
     save_player(p);
     kill_player(p);
     return(1);
    }
 return(1);
}

int logoff_all(void)
{
 player* p;

 p=first_player;
 while (p)
       {
        logoff_player(p);
        p=first_player;
       }
 return(0);
}

int logoff_player(player *p)
{
 char* oldstack;

 if (p->name)
     {
     sprintf(mssg,"%s has disconnected (%s).\n",p->name,p->ip_name);
     tolog("connect",mssg);
     }
 else
     {
     sprintf(mssg,"%s has disconnected..\n",p->ip_name);
     tolog("connect",mssg);
     }

 if (p->active&GAME)
    {
     p->last_login=time(NULL); /* Store last login time */

     SLINK(oldstack);
     bold(p,1);
     sprintf(stack,"<=- %s %s -=>\n",p->name,p->logoutmsg);
     bold(p,0); 
     SNEXT; SEND;
     send_player_ignore(p,oldstack,LOGIN);
     SUNLINK(oldstack);
    }

 send_pager(p,global_data[G_BYE]);
 save_player(p);
 kill_player(p);

 return(1);
}

int logoff_player_hard(player *p)
{
 char* name;
 
 if (p->name) name=strdup(p->name);
 kill_player(p);

 if (name)
     {
       sprintf(mssg,"%s has disconnected.\n",name);
       tolog("connect",mssg);
     }
 else
     {
     sprintf(mssg,"socket has disconnected..\n");
     tolog("connect",mssg);
     }

 return(1);
}

/*----------------------------Find Player-----------------------------*/
player* find_player_hard_nosoft(char* name)
{
 player* p;

 if (!*name) return(NULL);

 p=find_player(name);
 if (p) return(p);

 p=load_player(NULL,name);

 return(p);
}

player* find_player_hard(char* name)
{
 player* p;

 if (!*name) return(NULL);

 p=find_player_soft(name);
 if (p) return(p);

 p=load_player(NULL,name);

 return(p);
}

player* find_player_soft(char* name)
{
 player* p;
 p=find_player(name);
 if (p) return(p);

 p=first_player;

 while (p)
       {
        if (p->active&GAME &&
             !strncasecmp(name,p->name,strlen(name)))
           return(p);
        p=p->next;
       }
 return(NULL); 
}

player* find_player(char* name)
{
 player* p;
 p=first_player;

 if (!strcasecmp("me",name)) return(current_player);

 while (p)
       {
        if (p->active&GAME && !strcasecmp(name,p->name))
           return(p);
        p=p->next;
       }
 return(NULL);
}

/*----------------------------Send Player-----------------------------*/
int send_player_ignore(player* org,char* msg,int ignore)
{
 player* p;
 p=first_player;

 while (p)
       {
        if (p!=org && p->active&GAME && !(ignore&p->ignore) &&(p->room==org->room))
           {
            send_pager(p,msg);
           }
        p=p->next;
       }
 return(1);
}

/*---------------------------Delete Player----------------------------*/
int delete_player(char* name)
{
 char* fname;
 char* rest;
 int res;

 rest=strdup(name); 
 makelower(rest);
 fname=malloc(strlen(name)+strlen(PFILES_PATH)+1);
 sprintf(fname,PFILES_PATH,rest);
 res=unlink(fname);  
 free(fname);
 fname=malloc(strlen(name)+strlen(WEB_PATH)+1);
 sprintf(fname,WEB_PATH,rest);
 res=unlink(fname);  
 free(fname);
 if (!res) return(1);
 free(rest); 
 rest=NULL;
 return(0);
}

/*---------------------------Update Player----------------------------*/
int update_players(player*p,char* str)
{
 player* who;
 DIR* dr;
 char* pname;
 char* dpath;
 int count=0;

 dpath=strdup(PFILES_DIR);

 dr=lsr_start(dpath);
 while ((pname=lsr_next(dr)))
       {
 	if(count>1) 
	 {
	 who=find_player_hard(pname);
	 /* Add changes here!!*/
         unload_hard(who);
	 }
        count++;
       }
 su_wall(p,"updates all pfiles to new format.",ADMIN);
 return(1);
}




