/*
 * pager.c
 * ~~~~~~~
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "player.h"
#include "proto.h"
#include "config.h"

int send_pager(player* p,char* txt)
{
 player* who;
 char* str;
 who=NULL;

 /* Check for Watch */
 if (p->active&WATCHED && strcmp(txt,"\n"))
 {
     who=find_player(p->who_spook);
     send_pager_real(who,"[WATCH](");
     send_pager_real(who,p->name);
     send_pager_real(who,")");
     send_pager_real(who,txt);
     send_pager_real(who,"\n");
 }


 if (p->active&IS_ROBOT && strcmp(txt,"\n"))
 {
   str=strdup(txt);
   killendcr(str);
   robot_emote(p,str);
 }

 /* Do base send Pager */
 send_pager_real(p,txt);
 return(0);
}

int send_pager_real(player* p,char* txt)
{
 int nolines=0,endcr;
 char *nl,*in,*inorg, *wwho;

 inorg=in=strdup(txt);

 while (nolines<PAGER_PAGE && *in)
       {
        nl=next_line(&in,&endcr);
        send_player_real(p,nl);
        if (endcr)
        {
          bold(p,0);
          send_player_real(p,"\n");
        }
        nolines++;
       }
 if (nolines<PAGER_PAGE || !*in) {free(inorg); return(1);}

 if (p->pagerbuf) free(p->pagerbuf);
 p->pagerbuf=strdup(in); free(inorg);

 send_player_real(p,"[Pager - Hit Enter for next page or 'q' to quit] ");
 send_itsprompt(p);
 p->iofunc=pager_nextpage;
 return(1);
}

int pager_nextpage(player* p,char* str)
{
 char* rest=p->pagerbuf;
 p->iofunc=NULL;
 p->pagerbuf=NULL;

 send_player_real(p,"\n");

 if (tolower(*str)=='q')
    {
     if (rest) free(rest);
     return(1); 
    }
 else
 if (tolower(*str)=='n' || !*str)
    {
     if (!rest) return(1);
     send_pager(p,rest);
     free(rest);
     return(1);
    }
 send_player_real(p,"[Pager - Hit Enter for next page or 'q' to quit] ");
 send_itsprompt(p);

 p->iofunc=pager_nextpage;
 p->pagerbuf=rest;
 return(1);
}

char* next_line(char** txtin,int* endcr)
{
 char* txt=*txtin;
 char* org=txt;

 *endcr=0;

 while (*txt && *txt!='\n') txt++;
 if (*txt)
    {
     *endcr=1;
     *txt=0; txt++;
    }
 *txtin=txt;
 return(org);
}
