/*
 * news.c
 * ~~~~~~ News - SU News - Mail
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "player.h"
#include "proto.h"
#include "config.h"

int note_next=1;
int news[NOTES_LIST_MAX];
int sunews[NOTES_LIST_MAX];

/*---------------------------------Misc-------------------------------*/
char* string2arg(char* str)
{
 while (*str && !isspace(*str)) str++;
 if (isspace(*str)) {*str=0; str++;}
 while (isspace(*str)) str++;
 return(str);
}

int strlento(char* str,char c)
{
 int len=0;
 while (*str || *str!=c) {str++; len++;}
 return(len);
}

/*--------------------------Hash/News Counters-------------------------*/
int load_counter(void)
{
 FILE* han;

 han=fopen(NOTES_COUNTFILE,"r");
 if (!han)
    {
     note_next=1;
     sprintf(mssg,"Warning: Could not load notes counter file.\n");
     tolog("notes",mssg);
     return(0);
    }

 fscanf(han,"%d",&note_next);
 fclose(han);
 sprintf(mssg,"The next note is %d\n",note_next);
 tolog("bootup",mssg);
 do_debug("code","Loading Notes Counter\n");
 return(1);
}

int save_counter(void)
{
 FILE* 	han;
 int 	fd;
 char	*oldstack;

 oldstack = stack;

 han=fopen(NOTES_COUNTFILE,"w");
 if (!han)
    {
     sprintf(mssg,"Warning: Could not save the notes index counter (%d)\n",note_next);
     tolog("notes",mssg);
     fclose(han);
     return(0);
    }
 fprintf(han,"%d\n",note_next);
 fclose(han);
 do_debug("code","Saving Notes Counter\n");
 return(1);
}

int load_news_counter(void)
{
 FILE* han;
 char line[MAX_LINE*2];
 char vu[MAX_LINE];
 char* rest;

 han=fopen(NOTES_NEWSFILE,"r");
 if (!han)
    {
     sprintf(mssg,"Warning: Could not load news file.\n");
     tolog("notes",mssg);
     return(0);
    }

 while (!feof(han))
       {
        *line=0; fgets(line,1023,han); killendcr(line);
        *vu=0; sscanf(line,"%s",vu);        
        rest=line+strlen(vu); while (isspace(*rest)) rest++;

        if (!strcmp("news",vu)) notes_listload(news,rest);
        else
        if (!strcmp("sunews",vu)) notes_listload(sunews,rest);
       }
 fclose(han);
 do_debug("code","Loading News Counter\n");
 return(1);
}

int save_news_counter(void)
{
 FILE* 	han;
 int 	fd;
 char	*oldstack;

 oldstack = stack;

 han=fopen(NOTES_NEWSFILE,"w");
 if (!han)
    {
     sprintf(mssg,"Warning: Could not save the news file\n");
     tolog("notes",mssg);
     fclose(han);
     return(0);
    }

 fprintf(han,"news ");
 notes_listsave(news,han);
 fprintf(han,"\n");
 fprintf(han,"sunews ");
 notes_listsave(sunews,han);
 fclose(han);
 do_debug("code","Saving News Counter\n");
 return(1);
}

/*------------------------------Admin News----------------------------*/

int ad_post(player* p, char* str)	 
{
 FILE* han;
 char* oldstack;
 char file2[60];

 SLINK(oldstack);

 if (!*str)
    {
      send_pager(p," Format: adpost <message>\n");
      return(0);
    }

 sprintf(stack,"%s: %s \n",p->name,str);
 SNEXT; SEND;

 su_wall(p,"posts an admin memo!.",LA);
 sprintf(file2,TXT_PATH,"adnews");
 han=fopen(file2,"a");
 if (!han) return(0);
 fprintf(han,oldstack);
 fclose(han);

 SUNLINK(oldstack);
 return(1);
}  

int ad_read(player* p,char* txt)	 
{
 return(show_file(p,"adnews"));
}

/*-------------------------------SU-News------------------------------*/
int sunews_cmd(player* p,char* str)
{
 char* cmdname;

 if (!*str)
    {
     show_fmt:

     send_pager(p,"Format: sunews check\n");
     send_pager(p,"        sunews post <subject>\n");
     send_pager(p,"        sunews read <item>\n");
     send_pager(p,"        sunews delete <item>\n");
     return(0);
    }

 cmdname=str;
 str=string2arg(str);

 if (!strcasecmp("check",cmdname))
    return(sunews_check(p,str));
 if (!strcasecmp("post",cmdname))
    return(sunews_post(p,str));
 if (!strcasecmp("read",cmdname))
    return(sunews_read(p,str));
 if (!strcasecmp("delete",cmdname))
    return(sunews_delete(p,str));

 goto show_fmt;
}

int sunews_check(player* p,char* str)
{
 int *nl;
 char *txt=NULL,*sub=NULL,*from=NULL,*to=NULL;
 char* oldstack;
 int nn;
 
 nl=sunews;
 if (!*nl)    
    {
     send_pager(p," No SU News articles have been posted.\n");
     return(1);
    }

 SLINK(oldstack);

 nn=1;
 while (*nl)
       {
        txt=notes_load(*nl,&sub,&from,&to);
        sprintf(stack,"(%d) [%d] %s (%s)\n",*nl,nn,sub,from); SNEXT;
        if (txt) free(txt); txt=NULL;
        if (sub) free(sub); txt=NULL;
        if (from) free(from); txt=NULL;
        if (to) free(to); txt=NULL;
        nl++; nn++;
       }
 SEND;
 send_pager(p,oldstack); SUNLINK(oldstack);
 p->newsunews=0; /* Clear newsunews flag */

 unload_hard(who);
 return(1);
}

int sunews_post(player* p,char* str)
{
 char* orgstring;

 if (!*str)
    {
     send_pager(p,"Format: sunews post <subject>\n");
     return(0);
    }

 orgstring=strdup(str);

 sprintf(mssg," Sending talker SU - News.\n");
 send_pager(p,mssg);

 if (!*str)
    {
     send_pager(p,"Format: sunews post <subject>\n");
     free(orgstring); return(0);
    }

 editor_on(p,sunews_dopost,(void*)orgstring);
 update_newnews(p,"sunews");

 return(1);
}


int sunews_dopost(player* p,char* txt,void* dat)
{
 char* str,*orgstr;
 int nt;

 orgstr=str=(char*)dat;

 nt=notes_create(txt,str,p->name,"sunews");
 if (!notes_link(sunews,nt))
 {
   sprintf(mssg,"too many sunews articles.\n");
   send_pager(p,mssg);
 }
 else
   send_wall("-=> New SU News Article Posted <=-\n",1);

 free(txt); free(orgstr);

 return(1);
}

int sunews_read(player* p,char* str)
{
 int no=0;
 char* txt;

 if (!*str)
    {
     send_pager(p," Format: sunews read <number>\n");
     return(0);
    }

 sscanf(str,"%d",&no);
 if (no<=0 || no>=NOTES_LIST_MAX || sunews[no-1]==0)
    {
     send_pager(p," Invalid sunews number.\n");
     return(0);
    }
 no--;

 txt=notes_load(sunews[no],NULL,NULL,NULL);
 send_pager(p,txt);
 free(txt);
 return(1); 
}

int sunews_delete(player* p,char* str)
{
 int f,no=0;
 char *txt=NULL,*sub=NULL,*from=NULL,*to=NULL;

 if (!*str)
    {
     send_pager(p," Format: sunews delete <number>\n");
     return(0);
    }

 sscanf(str,"%d",&no);
 if (no<=0 || no>=NOTES_LIST_MAX || sunews[no-1]==0)
    {
     send_pager(p," Invalid mail number.\n");
     return(0);
    }
 no--;

 /* Remove the file */

 txt=notes_load(sunews[no],&sub,&from,&to);
 if (strcmp(p->name,from) && !(p->privs&ADMIN))
 {
   send_pager(p," Sorry you can not remove other users Postings!\n");
   if (txt) free(txt); txt=NULL;
   if (sub) free(sub); txt=NULL;
   if (from) free(from); txt=NULL;
   if (to) free(to); txt=NULL;
   return(1);
 }

 notes_remove(sunews[no]);

 for (f=no; f<(NOTES_LIST_MAX-1); f++)
      sunews[f]=sunews[f+1];
 sunews[NOTES_LIST_MAX-1]=0;

 send_pager(p," SU-News removed.\n");
 return(1);
}

/*---------------------------------News-------------------------------*/
int news_cmd(player* p,char* str)
{
 char* cmdname;

 if (!*str)
    {
     show_fmt:

     send_pager(p,"Format: news check\n");
     send_pager(p,"        news post <subject>\n");
     send_pager(p,"        news read <item>\n");
     send_pager(p,"        news delete <item>\n");
     return(0);
    }

 cmdname=str;
 str=string2arg(str);

 if (!strcasecmp("check",cmdname))
    return(news_check(p,str));
 if (!strcasecmp("post",cmdname))
    return(news_post(p,str));
 if (!strcasecmp("read",cmdname))
    return(news_read(p,str));
 if (!strcasecmp("delete",cmdname))
    return(news_delete(p,str));

 goto show_fmt;
}

int news_check(player* p,char* str)
{
 int *nl;
 char *txt=NULL,*sub=NULL,*from=NULL,*to=NULL;
 char* oldstack;
 int nn;
 
 nl=news;
 if (!*nl)    
    {
     send_pager(p," No News articles have been posted.\n");
     return(1);
    }

 SLINK(oldstack);

 nn=1;
 while (*nl)
       {
        txt=notes_load(*nl,&sub,&from,&to);
        sprintf(stack,"(%d) [%d] %s (%s)\n",*nl,nn,sub,from); SNEXT;
        if (txt) free(txt); txt=NULL;
        if (sub) free(sub); txt=NULL;
        if (from) free(from); txt=NULL;
        if (to) free(to); txt=NULL;
        nl++; nn++;
       }
 SEND;
 send_pager(p,oldstack); SUNLINK(oldstack);
 p->newnews=0; /* Clear newnews flag */

 unload_hard(who);
 return(1);
}

int news_post(player* p,char* str)
{
 char* orgstring;

 if (!*str)
    {
     send_pager(p,"Format: news post <subject>\n");
     return(0);
    }

 orgstring=strdup(str);

 sprintf(mssg," Sending talker news.\n");
 send_pager(p,mssg);

 if (!*str)
    {
     send_pager(p,"Format: news post <subject>\n");
     free(orgstring); return(0);
    }

 editor_on(p,news_dopost,(void*)orgstring);
 update_newnews(p,"news");

 return(1);
}


int news_dopost(player* p,char* txt,void* dat)
{
 int nt;
 char* str,*orgstr;

 orgstr=str=(char*)dat;

 nt=notes_create(txt,str,p->name,"news");
 if (!notes_link(news,nt))
 {
   sprintf(mssg,"too many news articles.\n");
   send_pager(p,mssg);
 }
 else
   send_wall("-=> New News Article Posted <=-\n",1);

 free(txt); free(orgstr);

 return(1);
}

int news_read(player* p,char* str)
{
 int no=0;
 char* txt;

 if (!*str)
    {
     send_pager(p," Format: news read <number>\n");
     return(0);
    }

 sscanf(str,"%d",&no);
 if (no<=0 || no>=NOTES_LIST_MAX || news[no-1]==0)
    {
     send_pager(p," Invalid news number.\n");
     return(0);
    }
 no--;

 txt=notes_load(news[no],NULL,NULL,NULL);
 send_pager(p,txt);
 free(txt);
 return(1); 
}

int news_delete(player* p,char* str)
{
 int f,no=0;
 char *txt=NULL,*sub=NULL,*from=NULL,*to=NULL;

 if (!*str)
    {
     send_pager(p," Format: news delete <number>\n");
     return(0);
    }

 sscanf(str,"%d",&no);
 if (no<=0 || no>=NOTES_LIST_MAX || news[no-1]==0)
    {
     send_pager(p," Invalid mail number.\n");
     return(0);
    }
 no--;

 /* Remove the file */

 txt=notes_load(news[no],&sub,&from,&to);
 if (strcmp(p->name,from) && !(p->privs&ADMIN))
 {
   send_pager(p," Sorry you can not remove other users Postings!\n");
   if (txt) free(txt); txt=NULL;
   if (sub) free(sub); txt=NULL;
   if (from) free(from); txt=NULL;
   if (to) free(to); txt=NULL;
   return(1);
 }

 notes_remove(news[no]);

 for (f=no; f<(NOTES_LIST_MAX-1); f++)
      news[f]=news[f+1];
 news[NOTES_LIST_MAX-1]=0;

 send_pager(p," News removed.\n");
 return(1);
}

/*---------------------------------Mail-------------------------------*/
int mail_cmd(player* p,char* str)
{
 char* cmdname;

 if (!*str)
    {
     show_fmt:

     send_pager(p,"Format: mail check\n");
     send_pager(p,"        mail post <player(s)> <subject>\n");
     send_pager(p,"        mail read <item>\n");
     send_pager(p,"        mail delete <item>\n");
     return(0);
    }

 cmdname=str;
 str=string2arg(str);

 if (!strcasecmp("check",cmdname))
    return(mail_check(p,str));
 if (!strcasecmp("post",cmdname))
    return(mail_post(p,str));
 if (!strcasecmp("read",cmdname))
    return(mail_read(p,str));
 if (!strcasecmp("delete",cmdname))
    return(mail_delete(p,str));

 goto show_fmt;
}

int mail_check(player* p,char* str)
{
 int *nl;
 char *txt=NULL,*sub=NULL,*from=NULL,*to=NULL;
 char* oldstack;
 int nn;
 player* who;

 if (*str && p->privs&ADMIN)
    {
     who=player_arg_hard(p,&str);
     if (!who) return(0);
    } 
 else
    who=p;

 nl=who->mail;
 if (!*nl)    {
     who->newmail=0; /* Clear newmail flag */

     if (who==p)
        sprintf(mssg," You have not received any mails.\n");
     else
        sprintf(mssg," %s has not received any mails.\n",who->name);
     send_pager(p,mssg);
     unload_hard(who);
     return(1);
    }

 SLINK(oldstack);

 nn=1;
 while (*nl)
       {
        txt=notes_load(*nl,&sub,&from,&to);
        sprintf(stack,"(%d) [%d] %s (%s)\n",*nl,nn,sub,from); SNEXT;
        if (txt) free(txt); txt=NULL;
        if (sub) free(sub); txt=NULL;
        if (from) free(from); txt=NULL;
        if (to) free(to); txt=NULL;
        nl++; nn++;
       }
 SEND;
 send_pager(p,oldstack); SUNLINK(oldstack);
 if (who==p) who->newmail=0; /* Clear newmail flag */

 unload_hard(who);
 return(1);
}

int mail_post(player* p,char* str)
{
 player **who;
 char* orgstring;

 if (!*str)
    {
     send_pager(p,"Format: mail post <player(s)> <subject>\n");
     return(0);
    }

 orgstring=strdup(str);

   if (strchr(str,'@'))
    {
     char* tp;
    
     send_pager(p,"Address to user not valid - invalid character @\n");
     return(1);
    }
 
 /* Basic email to chars on the program */

 who=player_arg_tag_hard(p,&str);
 if (!who) {free(orgstring);return(0);}


 /* Okay, tell the player who we are emailing */

 sprintf(mssg," Sending talker mail to %s.\n",tag2str(p,who));
 send_pager(p,mssg);
 free_tag(who);

 if (!*str)
    {
     send_pager(p,"Format: mail post <player(s)> <subject>\n");
     free(orgstring); return(0);
    }

 editor_on(p,mail_dopost,(void*)orgstring);

 return(1);
}


int mail_dopost(player* p,char* txt,void* dat)
{
 player** who,**lp;
 char* str,*orgstr;

 orgstr=str=(char*)dat;

 /* Standard talker mail */

 who=player_arg_tag_hard(p,&str);
 if (!who) {free(orgstr); return(0);}

 lp=who;
 while (*lp)
       {
        int nt;
        nt=notes_create(txt,str,p->name,tag2str(p,who));
        if (!notes_link((*lp)->mail,nt))
	 {
            sprintf(mssg,"%s has too many mails.\n",(*lp)->name);
 	    send_pager(p,mssg);
	 }
        else
           {
            (*lp)->newmail++;
            bold(*lp,1);
            sprintf(mssg," -=> New mail from %s",p->name);
	    send_pager(*lp,mssg);
            bold(*lp,0); send_pager(*lp,"\n");
           }
        lp++;
       }
 free(txt); free(orgstr);
 free_tag(who);

 return(1);
}

int mail_read(player* p,char* str)
{
 int no=0;
 char* txt;

 if (!*str)
    {
     send_pager(p," Format: mail read <number>\n");
     return(0);
    }

 sscanf(str,"%d",&no);
 if (no<=0 || no>=NOTES_LIST_MAX || p->mail[no-1]==0)
    {
     send_pager(p," Invalid mail number.\n");
     return(0);
    }
 no--;

 txt=notes_load(p->mail[no],NULL,NULL,NULL);
 send_pager(p,txt);
 free(txt);
 return(1); 
}

int mail_delete(player* p,char* str)
{
 int f,no=0;

 if (!*str)
    {
     send_pager(p," Format: mail delete <number>\n");
     return(0);
    }

 sscanf(str,"%d",&no);
 if (no<=0 || no>=NOTES_LIST_MAX || p->mail[no-1]==0)
    {
     send_pager(p," Invalid mail number.\n");
     return(0);
    }
 no--;

 /* Remove the file */

 notes_remove(p->mail[no]);

 for (f=no; f<(NOTES_LIST_MAX-1); f++)
      p->mail[f]=p->mail[f+1];
 p->mail[NOTES_LIST_MAX-1]=0;

 send_pager(p," Mail removed.\n");
 return(1);
}

/*---------------------------------Notes------------------------------*/
int notes_create(char* txt,char* sub,char* from,char* to)
{
 FILE* han;
 char fname[MAX_LINE];
 int this_note;

 this_note=note_next++;

 sprintf(fname,NOTES_DIR,this_note);
 han=fopen(fname,"w");
 if (!han)
    {
     sprintf(mssg,"Unable to create note number %d\n",note_next);
     tolog("notes",mssg);
     return(0);
    }

 if (from) fprintf(han,"From: %s\n",from); 
 if (to) fprintf(han,"To: %s\n",to);
 if (sub) fprintf(han,"Subject: %s\n",sub); 
 if (from || to || sub) fprintf(han,"\n");
 fputs(txt,han);
 fclose(han);

 save_counter();
 save_news_counter();
 return(this_note);
}

char* notes_load(int no,char** sub,char** from,char** to)
{
 char fname[MAX_LINE];
 char *txt,*in,*orgtxt,*rettxt;
 int yesno;

 sprintf(fname,NOTES_DIR,no);
 orgtxt=txt=strap_file(fname);

 if (!txt)
     orgtxt=txt=strdup("From: mailer-deamon\nTo: you\nSubject: Bad Email\n");

 rettxt=strdup(orgtxt);

 in=next_line(&txt,&yesno);
 while (in && *in)
       {
        if (!strncasecmp("From: ",in,6))
           {if (from) *from=strdup(in+6);}
        else
        if (!strncasecmp("To: ",in,4))
           {if (to) *to=strdup(in+4);}
        else
        if (!strncasecmp("Subject: ",in,9))
           {if (sub) *sub=strdup(in+9);}
        in=next_line(&txt,&yesno);
       }

 free(orgtxt);
 return(rettxt);
}

int notes_read(player* p,char* str)
{
 int no=0;
 char* txt;

 if (!*str)
    {
     send_pager(p," Format: note_read <number>\n");
     return(0);
    }

 sscanf(str,"%d",&no);
 if (no<=0)
    {
     send_pager(p," Invalid note number.\n");
     return(0);
    }

 txt=notes_load(no,NULL,NULL,NULL);
 send_pager(p,txt);
 free(txt);
 return(1); 
}

int notes_remove(int no)
{
 char fname[MAX_LINE];
 sprintf(fname,NOTES_DIR,no);
 if (unlink(fname)<0) return(0);
 return(1);
}

int notes_listload(int* list,char* txt)
{
 int f=0;
 int no;

 while (f<NOTES_LIST_MAX && *txt)
       {
        while (isspace(*txt)) txt++;
        no=0; sscanf(txt,"%d",&no);
        while (*txt && !isspace(*txt)) txt++; 
        if (no) list[f++]=no;
       }
 return(1);
}

int notes_listsave(int* list,FILE* han)
{
 int f;
 for (f=0; f<NOTES_LIST_MAX; f++)
     {
      if (list[f]) fprintf(han," %d",list[f]);
     } 
 fprintf(han,"\n");
 return(1);
}

int notes_unlink(int* list,int no)
{
 int f;
 for (f=0; f<NOTES_LIST_MAX; f++)
     {
      if (list[f]==no)
         {
          list[f]=0;
          return(1);
         }
     }
 return(0);
}

int notes_link(int* list,int no)
{
 int f;
 for (f=0; f<NOTES_LIST_MAX; f++)
     {
      if (!list[f])
         {
          list[f]=no;
          return(1);
         }
     }
 return(0);
}
