/*
 * Muffle.c
 * ~~~~~~~~ Muffle things..
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "player.h"
#include "proto.h"
#include "config.h"

/*-------------------------Muffle Structure----------------------------*/
const struct muffle_struct muffle[]={
		"admin",M_ADMIN,ADMIN,
		"hcadmin",M_HCADMIN,HCADMIN,
		"robot",M_ROBOT,ROBOT_MASTER,
		"spod",M_SPOD,SPOD,
		"su",M_SU,SU,
		NULL,0,0,
		};

/*------------------------------Pick Make-----------------------------*/
int muffle_chan(player* p,char* str)
{
 char* oldstack; 
 int cnt=0;
 const struct muffle_struct* ms;
 ms=muffle;

 SLINK(oldstack);

 while (ms->name)
       {
         if (!mystrcasecmp(ms->name,str))
         {
	   if (!p->privs&ms->priv)
	   {
	      send_pager(p," Sorry you do not have access to that channel!\n");
	      return(0);
	   }
           if (p->pensflags&ms->chan)
           {
             sprintf(mssg," You stop blocking the %s channel\n",ms->name);
	     send_pager(p,mssg);
             p->pensflags&=~ms->chan;
	     return(0);
           }
           else
           {
             sprintf(mssg," You start blocking the %s channel\n",ms->name);
             send_pager(p,mssg);
             p->pensflags|=ms->chan;
	     return(0);
           }
         }
	ms++;
	}

 ms=muffle;
 while (ms->name)
       {
	if (p->privs&ms->priv)
        {
            if (cnt>65) {*stack++='\n'; cnt=0;}
            if (cnt)
               sprintf(stack,", %s",ms->name);
            else
               sprintf(stack," %s",ms->name);
            cnt+=strlen(stack);
            SNEXT;
	}
        ms++;
       }
 *stack++='\n'; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(1);
}
