/*
 * marry.c
 * ~~~~~~~ marriage commands
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "player.h"
#include "config.h"
#include "proto.h"

/*------------------------------Admin Fun-----------------------------*/
int medit(player* p,char* str)
{
 player* who;

 if(!*str)
 {
  send_pager(p," Format: medit <player> <name>\n");
  return(0);
 }

 who=player_arg(p,&str);
 if (!who) return(0);

 if(!bestprivsloud(p,who)) return(0);

 if(p==who)
 {
  send_pager(p," Medit yourself??? Don't think so\n");
  return(0);
 }

 if(!*str)
 {
  send_pager(p," Format: medit <player> <name>\n");
  return(0);
 }

 who->pensflags&=~PROPOSE;
 who->pensflags&=~ENGAGED;
 who->pensflags|=MARRIED;
 who->marry=strdup(str);

 su_wall2(p,"medits %s to %s.",who->name,str,HCADMIN);

 return(0);
}

/*-------------------------------Propose------------------------------*/
int propose(player*p, char* str)
{
 player* who;

 if(!*str)
 {
  send_pager(p," Format: propose <player>\n");
  return(0);
 }

 who=player_arg(p,&str);
 if (!who) return(0);


 if(p==who)
 {
  p->pensflags&=~PROPOSE;
  if (p->marry) p->marry[0]=0;
  return(0);
 }

 if(who->ignore&MARRY_PROP)
 {
  sprintf(mssg," Sorry %s is ignoring marrage proposals.\n",who->name);
  send_pager(p,mssg);
  return(0);
 }

 if(p->ignore&MARRY_PROP)
 {
  send_pager(p," You can't propose to someone while you are ignoring proposals.\n");
  return(0);
 }

 if(who->pensflags&ENGAGED || who->pensflags&MARRIED)
 {
  sprintf(mssg," Sorry %s is already taken.\n",who->name);
  send_pager(p,mssg);
  return(0);
 }

 if(p->pensflags&ENGAGED || p->pensflags&MARRIED)
 {
  send_pager(p," Sorry Bigamy is not allowed on here.\n");
  return(0);
 }

 p->pensflags|=PROPOSE;
 p->marry=strdup(who->lower_name);
 sprintf(mssg," You propose marrage to %s.\n",who->name);
 send_pager(p,mssg);
 sprintf(mssg," %s proposes marrage to you.\n",p->name);
 send_pager(who,mssg);
 return(0);
}

/*------------------------------un/Engage-----------------------------*/
int engage(player* p,char* str)
{
 player* who1;
 player* who2;

 if(!*str)
 {
  send_pager(p," Format: engage <player1> <player2>\n");
  return(0);
 }

 who1=player_arg(p,&str);
 if (!who1) return(0);

 if(!*str)
 {
  send_pager(p," Format: engage <player1> <player2>\n");
  return(0);
 }
 
 who2=player_arg(p,&str);
 if (!who2) return(0);

 if (!who1->pensflags&PROPOSE ||(who1->pensflags&PROPOSE&&strcmp(who1->marry,who2->lower_name)))
 {
  sprintf(mssg," %s has not praposed to %s.\n",who1->name,who2->name);
  send_pager(p,mssg);
  return(0);
 }

 if (!who2->pensflags&PROPOSE ||(who2->pensflags&PROPOSE&& strcmp(who2->marry,who1->lower_name)))
 {
  sprintf(mssg," %s has not praposed to %s.\n",who2->name,who1->name);
  send_pager(p,mssg);
  return(0);
 }

 who1->pensflags|=ENGAGED;
 who2->pensflags|=ENGAGED;
 who1->pensflags&=~PROPOSE;
 who2->pensflags&=~PROPOSE;

 sprintf(mssg," You engage %s to %s.\n",who1->name,who2->name);
 send_pager(p,mssg);
 sprintf(mssg," %s engages you to %s.\n",p->name,who2->name);
 send_pager(who1,mssg);
 sprintf(mssg," %s engages you to %s.\n",p->name,who1->name);
 send_pager(who2,mssg);
 return(0);
}

int unengage(player* p,char* str)
{
 player* who1;
 player* who2;

 if(!*str)
 {
  send_pager(p," Format: unengage <player1> <player2>\n");
  return(0);
 }

 who1=player_arg(p,&str);
 if (!who1) return(0);

 if(!*str)
 {
  send_pager(p," Format: unengage <player1> <player2>\n");
  return(0);
 }
 
 who2=player_arg(p,&str);
 if (!who2) return(0);

 if (!who1->pensflags&ENGAGED ||(who1->pensflags&ENGAGED && strcmp(who1->marry,who2->lower_name)))
 {
  sprintf(mssg," %s is not engaged to %s.\n",who1->name,who2->name);
  send_pager(p,mssg);
  return(0);
 }

 if (!who2->pensflags&ENGAGED ||(who2->pensflags&ENGAGED && strcmp(who2->marry,who1->lower_name)))
 {
  sprintf(mssg," %s is not engaged to %s.\n",who2->name,who1->name);
  send_pager(p,mssg);
  return(0);
 }

 who1->pensflags&=~ENGAGED;
 who2->pensflags&=~ENGAGED;
 who1->marry[0]=0;
 who2->marry[0]=0;

 sprintf(mssg," You anull the engagement of %s and %s.\n",who1->name,who2->name);
 send_pager(p,mssg);
 sprintf(mssg," %s anulls your engagement to %s.\n",p->name,who2->name);
 send_pager(who1,mssg);
 sprintf(mssg," %s anulls your engagement to %s.\n",p->name,who1->name);
 send_pager(who2,mssg);
 return(0);
}

/*----------------------------Marry-Divorce----------------------------*/
int marry(player* p,char* str)
{
 player* who1;
 player* who2;

 if(!*str)
 {
  send_pager(p," Format: marry <player1> <player2>\n");
  return(0);
 }

 who1=player_arg(p,&str);
 if (!who1) return(0);

 if(!*str)
 {
  send_pager(p," Format: marry <player1> <player2>\n");
  return(0);
 }
 
 who2=player_arg(p,&str);
 if (!who2) return(0);

 if (!who1->pensflags&ENGAGED || (who1->pensflags&ENGAGED&&strcmp(who1->marry,who2->lower_name)))
 {
  sprintf(mssg," %s is not engaged to %s.\n",who1->name,who2->name);
  send_pager(p,mssg);
  return(0);
 }

 if (!who2->pensflags&ENGAGED || (who2->pensflags&ENGAGED && strcmp(who2->marry,who1->lower_name)))
 {
  sprintf(mssg," %s is not engaged to %s.\n",who2->name,who1->name);
  send_pager(p,mssg);
  return(0);
 }

 who1->pensflags&=~ENGAGED;
 who2->pensflags&=~ENGAGED;
 who1->pensflags|=MARRIED;
 who2->pensflags|=MARRIED;

 sprintf(mssg," You marry %s to %s.\n",who1->name,who2->name);
 send_pager(p,mssg);
 sprintf(mssg," %s marries you to %s.\n",p->name,who2->name);
 send_pager(who1,mssg);
 sprintf(mssg," %s marries you to %s.\n",p->name,who1->name);
 send_pager(who2,mssg);
 return(0);
}

int divorce(player* p,char* str)
{
 player* who1;
 player* who2;

 if(!*str)
 {
  send_pager(p," Format: divorce <player1> <player2>\n");
  return(0);
 }

 who1=player_arg(p,&str);
 if (!who1) return(0);

 if(!*str)
 {
  send_pager(p," Format: divorce <player1> <player2>\n");
  return(0);
 }
 
 who2=player_arg(p,&str);
 if (!who2) return(0);

 if (!who1->pensflags&MARRIED ||( who1->pensflags&MARRIED && strcmp(who1->marry,who2->lower_name)))
 {
  sprintf(mssg," %s is not married to %s.\n",who1->name,who2->name);
  send_pager(p,mssg);
  return(0);
 }

 if (!who2->pensflags&MARRIED || (who2->pensflags&MARRIED && strcmp(who2->marry,who1->lower_name)))
 {
  sprintf(mssg," %s is not married to %s.\n",who2->name,who1->name);
  send_pager(p,mssg);
  return(0);
 }

 who1->pensflags&=~MARRIED;
 who2->pensflags&=~MARRIED;
 who1->marry[0]=0;
 who2->marry[0]=0;

 sprintf(mssg," You divorce %s from %s.\n",who1->name,who2->name);
 send_pager(p,mssg);
 sprintf(mssg," %s divorces you from %s.\n",p->name,who2->name);
 send_pager(who1,mssg);
 sprintf(mssg," %s divorces you from %s.\n",p->name,who1->name);
 send_pager(who2,mssg);
 return(0);
}

/*---------------------------Anull one player-------------------------*/
int anull_eng(player* p,char* str)
{
 player* who;
 
 if(!*str)
 {
  send_pager(p," Format: anull_eng <player>\n");
  return(0);
 }

 who=player_arg(p,&str);
 if (!who) return(0);

 if (!who->pensflags&ENGAGED)
 {
  sprintf(mssg," %s is not engaged.\n",who->name);
  send_pager(p,mssg);
  return(0);
 }

 who->pensflags&=~ENGAGED;
 who->marry[0]=0;

 sprintf(mssg," You anull the engagement of %s.\n",who->name);
 send_pager(p,mssg);
 sprintf(mssg," %s anulls your engagement.\n",p->name);
 send_pager(who,mssg);
 return(0);
}

int anull_mar(player* p,char* str)
{
 player* who;
 
 if(!*str)
 {
  send_pager(p," Format: anull_mar <player>\n");
  return(0);
 }

 who=player_arg(p,&str);
 if (!who) return(0);

 if (!who->pensflags&MARRIED)
 {
  sprintf(mssg," %s is not married.\n",who->name);
  send_pager(p,mssg);
  return(0);
 }

 who->pensflags&=~MARRIED;
 who->marry[0]=0;

 sprintf(mssg," You anull the marrage of %s.\n",who->name);
 send_pager(p,mssg);
 sprintf(mssg," %s anulls your marrage.\n",p->name);
 send_pager(who,mssg);
 return(0);
}
