/*
 * Make.c
 * ~~~~~~ Make help lists..
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "player.h"
#include "proto.h"
#include "config.h"

/*---------------------------Make Structure----------------------------*/
const struct make_struct make[]={
		"admin",ADMIN,
		"lawyers",LAWYER,
		"ministers",MINISTER,
		"spods",SPOD,
		"staff",SU,
		NULL,0,
		};

/*------------------------------Pick Make-----------------------------*/
int make_hfile2(player* p,char* str)
{
 char* oldstack; 
 int cnt=0;
 const struct make_struct* ms;
 ms=make;

 SLINK(oldstack);

 while (ms->name)
       {
        if (!mystrcasecmp(ms->name,str))
		return(make_hfile(p,ms->name,ms->priv));
	ms++;
	}

 ms=make;
 while (ms->name)
       {
            if (cnt>65) {*stack++='\n'; cnt=0;}
            if (cnt)
               sprintf(stack,", %s",ms->name);
            else
               sprintf(stack," %s",ms->name);
            cnt+=strlen(stack);
            SNEXT;
        ms++;
       }
 *stack++='\n'; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(1);
}

/*------------------------------Make File-----------------------------*/
int make_hfile(player* p,char* str,int priv)
{
 player*        f;
 DIR*           dr;
 FILE*		mf;
 char*          pname;
 char*          dpath;
 char		hpath[MAX_LINE];
 char*          oldstack;
 int		cnt=0;


 SLINK(oldstack);

 stackbar();
 sprintf(stack,"--==>  Talker %s  <==-- \n",str);
 SNEXT;
 stackbar();
 SNEXT;

 dpath=strdup(PFILES_DIR);

 dr=lsr_start(dpath);
 while ((pname=lsr_next(dr)))
       {
        if (cnt>1)
        {
         f=find_player_hard(pname);
	 if(f->privs&priv && !(f->privs&BANISHED)) 
	 {
	  sprintf(stack,"%-14s %-40s",f->name, f->title);
	  SNEXT;
          if(f->privs&HCADMIN && f->lsu)
                                sprintf(stack,"%s\n",f->lsu)  ;else
          if(f->privs&HCADMIN)  sprintf(stack,"HC Admin   \n");else
          if(f->privs&ADMIN)    sprintf(stack,"Admin      \n");else
          if(f->privs&CODER)    sprintf(stack,"Coder      \n");else
          if(f->privs&LA)       sprintf(stack,"Lower Admin\n");else
          if(f->privs&SU)       sprintf(stack,"Super User \n");else
          if(f->privs&LAWYER)   sprintf(stack,"Lawyer     \n");else
          if(f->privs&MINISTER) sprintf(stack,"Minister   \n");else
          if(f->privs&RESIDENT) sprintf(stack,"Resident   \n");
          else                  sprintf(stack,"Newbie     \n");
          SNEXT;
	 }        
	 unload_hard(f);
        }
        cnt++;
       }
 cnt=cnt - 2;
 stackbar();
 SNEXT; SEND;
 sprintf(hpath,HELP_PATH,str);
 mf=fopen(hpath,"w");
 if (!mf) return(0);
 fprintf(mf,oldstack);
 fclose(mf);
 sprintf(mssg," Help %s Created.\n",str);
 send_pager(p,mssg);
 return(1);
}
