/*
 * login.c
 * ~~~~~~~
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "player.h"
#include "proto.h"

/*--------------------------Miscalaneous------------------------------*/
int             match_banish(player * p, char *line)
{
   char           *addr;

   for (addr = p->ip_num; *addr; addr++, line++)
   {
   if (*line == '*')
   {
    while (isdigit(*addr))
       addr++;
    line++;
   } 
   else 
   if (*addr != *line)
       return(0);
  }
   return(1);
}

/*-------------------------------Login--------------------------------*/
int login_message(player* p)
{
 if (p->privs&NEWBIE)
    {
     send_pager(p,global_data[G_NEWBIEMSG]);
    }

 send_pager(p,global_data[G_LOGINMSG]);

/* Need player here for staff initilisation */

 if (!strcasecmp("admin",p->name))
    p->privs|=HCADMININIT;

 if (p->pensflags&NEW_MOTD)
    {
     send_pager(p,global_data[G_MOTD]);
     p->pensflags&=~NEW_MOTD;
    }

 if (p->pensflags&NEW_SUMOTD && p->privs&SU)
    {
     send_pager(p,global_data[G_SUMOTD]);
     p->pensflags&=~NEW_SUMOTD;
    }

 if (p->newmail || p->newnews || p->newsunews)
    {
     bold(p,1);
     if(p->newmail)
     {
       sprintf(mssg,"You have %d new mail(s).\n",p->newmail);
       send_pager(p,mssg);
     }
     if(p->newnews)
     {
       sprintf(mssg,"You have %d new news postings.\n",p->newnews);
       send_pager(p,mssg);
     }
     if(p->newsunews && p->privs&SU)
     {
       sprintf(mssg,"You have %d new sunews postings.\n",p->newsunews);
       send_pager(p,mssg);
     }
     bold(p,0); send_pager(p,"\n");
    }

 if (p->smess && !(p->smess[0]==0))
    {
     bold(p,1);
     sprintf(mssg," Saved Message from %s",p->smess);
     send_pager(p,mssg);
     bold(p,0); send_pager(p,"\n");
     p->smess[0]=0;
    }

 if (p->swarn && !(p->swarn[0]==0))
    {
     bold(p,1);
     sprintf(mssg,"\007 Saved Warning from %s",p->swarn);
     send_pager(p,mssg);
     bold(p,0); send_pager(p,"\n");
     p->swarn[0]=0;
    }

 return(0);
}

int start_login(player *p)
{
 send_pager(p,global_data[G_PICTURE]);
 p->active|=SCAN;
 return(get_name(p));
}

int join_game(player *p)
{
 player* oldp;
 char* oldstack;
 int ban;

 SLINK(oldstack);

 if(check_banish(p)) return(1);
 if(check_sitebanish(p)) return(1);
 if(p->privs&BANISHED)
 {
   send_pager(p,global_data[G_BAN]);
   save_player(p);
   kill_player(p);
   return(1);
 }

 login_message(p);    /* Send the player the login message */
 numlogins++;         /* Add one to the count */

 if ((oldp=find_player(p->name)))
    {
     sprintf(mssg,"%s re-connects.\n",p->name);
     tolog("connect",mssg);     
     save_player(oldp);
     logoff_player(oldp);
     bold(p,1);
     sprintf(stack,"<=- %s re-connects to the talker -=>\n",p->name);
     bold(p,0);
     SNEXT; 
     SEND;
     send_player_ignore(p,oldstack,LOGIN);
    }
 else
    {
     bold(p,1);
     sprintf(stack,"<=- %s %s -=>\n",p->name,p->loginmsg); 
     SNEXT;
     SEND;
     send_player_ignore(p,oldstack,LOGIN); 
     if (p->privs&NEWBIE) su_wall2(p, " logging in from site [%s(%s)] [NEWBIE]",p->ip_name,p->ip_num,SU);
     bold(p,0);
    }

 p->active|=GAME;

 sprintf(mssg,"%s [%lx] joins the game (%s)\n",p->name,p,p->ip_name);
 tolog("connect",mssg);

 look(p,"");


 SUNLINK(oldstack);
 save_player(p);
 return(1);
}

/*--------------------------Email Commands----------------------------*/

int get_email(player* p)	
{
 p->iofunc=got_email;

 send_pager(p,"What is your email Address? ");
 send_itsprompt(p);
 return(0);
}

int got_email(player* p,char* email)  	
{
 if (!strchr(email,'@')) 
 { 
 send_pager(p,"Invalid email\n"); 
 return(get_email(p));
 }
 setattrib(p,&p->email,"email",email);
 return(get_pass(p));
}

/*---------------------------Name Commands----------------------------*/
int get_name(player* p)
{
 p->iofunc=got_name;

 send_pager(p,"What is your name? ");
 send_itsprompt(p);
 return(0);
}

int got_name(player* p,char* name)
{
 char* t;
 player* ld;
 
 p->iofunc=NULL;

 while (isspace(*name)) name++;
 killendjunk(name);

 t=name; while (isalnum(*t)) t++; *t=0;

 if (!*name) return(get_name(p));
 
 if (!strcasecmp(name,"me")) return(get_name(p));

 if (strlen(name)>15) 
    { 
	send_pager(p,"Try a shorter Name\n");
      	return(get_name(p));
    }

 if ((ld=find_player(name)))
    {
     save_player(ld);
     ld=NULL;
    }

 ld=load_player(p,name);
 if (ld)
    {
     get_pass(ld);
     return(1);
    }

 p->name=strdup(name);
 p->lower_name=strdup(name);
 makelower(p->lower_name);

 join_game(p);
 return(1);
}

/*-------------------------Password Commands--------------------------*/
int get_pass(player* p)
{
 p->iofunc=got_pass;

 if (p->active&VERIFY_PASS)
    send_pager(p,"Please Re-Enter your Password: ");
 else
 if (!p->pass)
    send_pager(p,"Enter your new password: ");
 else
    send_pager(p,"Please Enter your Password: ");

 password_mode(p,1);
 send_itsprompt(p);
 return(0);
}

int got_pass(player* p,char* pass)
{
 char salt[MAX_LINE];

 p->iofunc=NULL;
 send_pager(p,"\n"); /* CR */
 password_mode(p,0);

 sprintf(salt,"_asf9[]mf",pass);

 if (!p->pass)
    {
     if (p->pass) free(p->pass); p->pass=strdup(crypt(pass,salt));
     p->active|=VERIFY_PASS;
     return(get_pass(p));
    }
 else
    {
     if (!strcmp(p->pass,crypt(pass,salt)))
        {
         p->active&=~VERIFY_PASS;
         if (p->active&GAME) return(1);
         else
         {
          save_player(p);
          join_game(p);
         }
         return(1);
        }

     if (p->active&VERIFY_PASS)
        {
         p->active&=~VERIFY_PASS;
         send_pager(p," -=> Your passwords did not match, try again.\n");
         p->pass=NULL;
         return(get_pass(p));
        }

     p->pass_fail++;
     if (p->pass_fail>=MAX_PASS_FAIL) 
     {
       if(p->privs&SU)
       {
         sprintf(mssg,"Password fail: %s (%s)\n",p->name,p->ip_name);
         tolog("passfail",mssg);
       }
       return(kill_player(p));
     }
     return(get_pass(p));
    }
}

/*-----------------------Check Banish Commands------------------------*/
check_banish(player* p)
{
 FILE*f_ptr;
 char bname[20];
 int i;

 if ((f_ptr = fopen("files/banish","r"))==NULL)
 {
  sprintf(mssg,"Banish file Missing!!!.\n",p->name);
  tolog("error",mssg);
  return(0);
 }
 while (bname[0]!='#')
 {
	fscanf(f_ptr,"%s",bname);
	if (!strcasecmp(p->name,bname)) 
	{
		fclose(f_ptr);
 		send_pager(p,global_data[G_BAN]);
		kill_player(p);
		return(1);
	}
 }
 fclose(f_ptr);
 return(0);
}

check_sitebanish(player* p)
{
 FILE*f_ptr;
 char bsite[20];
 char* ipsite;

 bsite[0]=0;

 ipsite=strdup(p->ip_num);
 if ((f_ptr = fopen("files/siteban","r"))==NULL)
 {
  sprintf(mssg,"Site Banish file Missing!!!.\n",p->name);
  tolog("error",mssg);
  return(0);
 }
 while (bsite[0]!='#')
 {
	fscanf(f_ptr,"%s",bsite);
	if (match_banish(p,bsite)) 
	{
		fclose(f_ptr);
 		send_pager(p,global_data[G_SITEBAN]);
 		kill_player(p);
		return(1);
	}
 }
 fclose(f_ptr);
 return(0);
}

