/*
 * list.c
 * ~~~~~~ Lists
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "player.h"
#include "config.h"
#include "proto.h"

/*----------------------------List of Lists---------------------------*/
int list_newbies(player* p,char* str)
{
 make_list(p,"Newbies---",NEWBIE);
 return(0);
}

int list_admin(player* p,char* str)
{
 make_list(p,"Admin-----",ADMIN);
 return(0);
}

int list_su(player* p,char* str)
{
 make_list(p,"Staff-----",SU);
 return(0);
}

int list_lawyer(player* p,char* str)
{
 make_list(p,"Lawyers---",LAWYER);
 return(0);
}

int list_minister(player* p,char* str)
{
 make_list(p,"Ministers-",MINISTER);
 return(0);
}

int list_spods(player* p,char* str)
{
 make_list(p,"Spods-----",SPOD);
 return(0);
}

int list_idle(player* p,char* str)
{
 make_list(p,"Idle Times",RESIDENT|NEWBIE);
 return(0);
}

/*------------------------------Make List-----------------------------*/
int make_list(player* p,char* list,int priv)	 
{
 player* f;
 int cnt=0;
 char* oldstack;

 SLINK(oldstack);

 sprintf(stack,"--------%-10s---------------------------"
               "-----------------------------\n",list);
 SNEXT;

 sprintf(stack,"-Name----------------location----Idle---"
               "----Rank--------------------------\n");
 SNEXT;

 f=first_player;
 while (f) 
 {
  if ((f->active&GAME || p->privs&HCADMIN) && f->privs&priv)
  {
  if ((priv==SU || priv==ADMIN) && !(f->pensflags&SU_DUTY)) 
  {
  }
  else
    {
      sprintf(stack," %-19s ",f->name);
      SNEXT;
      if(f->pensflags&HIDE && !(p->privs&ADMIN))
      sprintf(stack,"hiding      ");
      else
      sprintf(stack,"%-11s ",rooms[f->room].name);
      SNEXT;
      sprintf(stack,"%-10s",time2strshort(f->currentidle));
      SNEXT;
      if(f->privs&HCADMIN && f->lsu)  
 		  	    sprintf(stack,"%s\n",f->lsu)  ;else
      if(f->privs&HCADMIN)  sprintf(stack,"HC Admin   \n");else
      if(f->privs&ADMIN)    sprintf(stack,"Admin      \n");else
      if(f->privs&CODER)    sprintf(stack,"Coder      \n");else
      if(f->privs&LA)       sprintf(stack,"Lower Admin\n");else
      if(f->privs&SU)       sprintf(stack,"Super User \n");else
      if(f->privs&LAWYER)   sprintf(stack,"Lawyer     \n");else
      if(f->privs&MINISTER) sprintf(stack,"Minister   \n");else
      if(f->privs&RESIDENT) sprintf(stack,"Resident   \n");
      else                  sprintf(stack,"Newbie     \n");
      SNEXT;
      cnt++;
    }
 }
 f=f->next;
 }

 if (cnt > 1)
   sprintf(stack, "------------------- There are %2d people listed "
                     "---------------------------\n", cnt);
 else 
 if (cnt == 1)
   sprintf(stack, "------------------- There is only one person listed"
                     " ----------------------\n");
 else
   sprintf(stack, "------------------- There are no people listed ----"
                     "-----------------------\n");
 SNEXT;
 SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(0);
}

/*----------------------------List IP Sites---------------------------*/
int list_site(player* p,char* list)	 
{
 player* f;
 int cnt=0;
 char* oldstack;

 SLINK(oldstack);

 sprintf(stack,"--------Login Sites---------------------------"
               "----------------------------\n",list);
 SNEXT;

 f=first_player;
 while (f) 
 {
  if (f->active&GAME || p->privs&HCADMIN) 
    {
      sprintf(stack,"%-20s %s (%s)\n",f->name,f->ip_num,f->ip_name);
      SNEXT;
      cnt++;
    }
 f=f->next;
 }

 if (cnt > 1)
   sprintf(stack, "------------------- There are %2d people listed "
                     "---------------------------\n", cnt);
 else 
 if (cnt == 1)
   sprintf(stack, "------------------- There is only one person listed"
                     " ----------------------\n");
 else
   sprintf(stack, "------------------- There are no people listed ----"
                     "-----------------------\n");
 SNEXT;
 SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(0);
}
