/*
 * friends.c
 * ~~~~~~~~~
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "player.h"
#include "proto.h"
#include "config.h"

/*---------------------------Miscellaneous----------------------------*/
int add_tag_friends(player* p,Tag tag,int hard)
{
 friend* fp;
 int told=0;

 fp=p->friends;

 if (!fp)
    {
     send_pager(p," Your list is currently empty.\n");
     return(0);
    }

 while (fp)
       {
        player* who;
        if (hard)
           who=find_player_hard(fp->name);
        else
           who=find_player(fp->name);
        if (who && !(who->ignore&FRIEND)) 
           {
            add_tag(who,tag); told++;
           }
        fp=fp->next;
       }

 if (!told)
    send_pager(p," None of your friends are online at the moment.\n");

 return(told);
}

/*---------------------------Friend Channel---------------------------*/
int rf(player*p,char* str)
{
 friend* fp;
 int told=0;

 if (!*str)
    {
     send_pager(p,"Format: rf <message>\n");
     return(0);
    }

 fp=p->friends;
 if (!fp)
    {
     send_pager(p," Your list is currently empty.\n");
     return(0);
    }

 while (fp)
       {
        player* who;
        who=find_player(fp->name);
        if (who && !(who->ignore&FRIENDS))
           {
            bold(who,1);

            sprintf(mssg,"* %s %s",fullname(p),str);
	    send_pager(who,mssg);

            bold(who,0); send_pager(who,"\n");
            told++;
           }
        fp=fp->next;
       }
 if (!told)
    {
     send_pager(p," None of your friends are online at the moment.\n");
    }
 else
   {
    sprintf(mssg," You emote '%s %s' to your friends.\n",fullname(p),str);
    send_pager(p,mssg);
   }
 return(1);
}

int tf(player*p,char* str)
{
 friend* fp;
 int told=0;

 if (!*str)
    {
     send_pager(p,"Format: tf <message>\n");
     return(0);
    }

 fp=p->friends;

 if (!fp)
    {
     send_pager(p," Your list is currently empty.\n");
     return(0);
    }
 while (fp)
       {
        player* who;
        who=find_player(fp->name);
        if (who && !(who->ignore&FRIENDS))
           {
            bold(who,1);
            sprintf(mssg,"* %s tells his friends '%s'",p->name,str);
	    send_pager(who,mssg);
            bold(who,0); send_pager(who,"\n");
            told++;
           }
        fp=fp->next;
       }
 if (!told)
    sprintf(mssg," None of your friends are online at the moment.\n");
 else
    sprintf(mssg," You tell your friends '%s'\n",str);
 send_pager(p,mssg);
 return(1);
}

int rfo(player*p,char* str)
{
 player* who;
 friend* fp;
 int told=0;
 int isf=0;

 if (!*str)
    {
     send_pager(p,"Format: rfo <player> <message>\n");
     return(0);
    }

 who=player_arg(p,&str);
 if (!who) return(0);

 fp=who->friends;
 if (!fp)
    {
     send_pager(p," Their list is currently empty.\n");
     return(0);
    }

 while (fp)
   {
     player* fwho;
     fwho=find_player(fp->name);
     if (fwho==p) isf=1;
     fp=fp->next;
   }
 
 if (!isf)
   {
     sprintf(mssg," Sorry you are not on %s's friend list.\n",who->name);
     send_pager(p,mssg);
     return(0);
   }

 fp=who->friends;
 while (fp)
       {
        player* fwho;
        fwho=find_player(fp->name);
        if (fwho && !(fwho->ignore&FRIENDS) && !(fwho==p))
           {
            bold(fwho,1);

            sprintf(mssg,"* %s %s (%s's friends)",fullname(p),str,who->name);
	    send_pager(fwho,mssg);

            bold(fwho,0); send_pager(fwho,"\n");
            told++;
           }
        fp=fp->next;
       }
 if (!told)
    {
     sprintf(mssg," None of %s's friends are online at the moment.\n",who->name);
     send_pager(p,mssg);
    }
 else
   {
    sprintf(mssg," You emote '%s %s' to %s's friends.\n",fullname(p),str,who->name);
    send_pager(p,mssg);
    bold(who,1);
    sprintf(mssg,"* %s %s 'to your friends'",fullname(p),str);
    send_pager(who,mssg);
    bold(who,0); send_pager(who,"\n");
   }
 return(1);
}

int tfo(player*p,char* str)
{
 player* who;
 friend* fp;
 int told=0;
 int isf=0;

 if (!*str)
    {
     send_pager(p,"Format: tfo <player> <message>\n");
     return(0);
    }

 who=player_arg(p,&str);
 if (!who) return(0);

 fp=who->friends;
 if (!fp)
    {
     send_pager(p," Their list is currently empty.\n");
     return(0);
    }

 while (fp)
   {
     player* fwho;
     fwho=find_player(fp->name);
     if (fwho==p) isf=1;
     fp=fp->next;
   }
 
 if (!isf)
   {
     sprintf(mssg," Sorry you are not on %s's friend list.\n",who->name);
     send_pager(p,mssg);
     return(0);
   }

 fp=who->friends;
 while (fp)
       {
        player* fwho;
        fwho=find_player(fp->name);
        if (fwho && !(fwho->ignore&FRIENDS) && !(fwho==p))
           {
            bold(fwho,1);

            sprintf(mssg,"* %s tells %s's friends '%s'",fullname(p),who->name,str);
	    send_pager(fwho,mssg);

            bold(fwho,0); send_pager(fwho,"\n");
            told++;
           }
        fp=fp->next;
       }
 if (!told)
    {
     sprintf(mssg," None of %s's friends are online at the moment.\n",who->name);
     send_pager(p,mssg);
    }
 else
   {
    sprintf(mssg," You tell %s's friends '%s'.\n",who->name,str);
    send_pager(p,mssg);
    bold(who,1);
    sprintf(mssg,"* %s tells your friends '%s'",fullname(p),str);
    send_pager(who,mssg);
    bold(who,0); send_pager(who,"\n");
   }
 return(1);
}

/*-------------------------- Friend Commands--------------------------*/
int friend_cmd(player*p,char* str)
{
 player* who;

 if (!*str)
    {
     send_pager(p," Format: friend <player>\n");
     return(0);
    } 
 
 who=player_arg_hard(p,&str);
 if (!who) return(0);

 if (who==p)
    {
     send_pager(p," You can not make friends with yourself!\n");
     return(0);
    }

 if (friend_find(p,who->name))
    {
     sprintf(mssg," %s is already your friend.\n",who->name); 
     send_pager(p,mssg);
     unload_hard(who); return(0);
    }

 friend_add(p,who->lower_name,FRIEND);
 
 bold(who,1);
 if (p->gender==0) 
    sprintf(mssg," -=> %s makes you a friend.\n",p->name);
 else 
 if (p->gender==1)
    sprintf(mssg," -=> %s makes you his friend.\n",p->name);
 else
 if (p->gender==2)
    sprintf(mssg," -=> %s makes you her friend.\n",p->name);
 send_pager(who,mssg);
 bold(who,0);

 sprintf(mssg," -=> You make %s your friend.\n",who->name);
 send_pager(p,mssg);
 unload_hard(who);
 return(1);
}

int fwho(player* p,char* str)
{
 friend* fp;
 char* oldstack;
 int cnt=0;

 fp=p->friends;
 if (!fp)
    {
     send_pager(p," Your list is currently empty.\n");
     return(0);
    }

 SLINK(oldstack);

 while (fp)
       {
        player* who;
        if ((who=find_player(fp->name)))
           {
            if (who->ignore&FRIENDS)
               sprintf(stack,"%s %s (Ignoring)\n",fullname(who),who->title);
            else
               sprintf(stack,"%s %s\n",fullname(who),who->title);
            SNEXT; cnt++;
           }
        fp=fp->next;
       }
 if (!cnt)
    {
     send_pager(p," None of your friends are online at the moment.\n");
     return(0);     
    }
 stackbar(); SEND;

 sprintf(mssg,"-------------------    You have %2d friend(s) online"
               " ------------------------\n",cnt);
 send_pager(p,mssg);
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(1);
}

/*----------------------------Friend List-----------------------------*/
int clist(player* p,char* str)
{
 friend* fp;

 if (!*str)
    {
     send_pager(p,"Format: clist <player>\n");
     return(0);
    }

 fp=p->friends;
 if (!fp)
    {
     send_pager(p," Your list is currently empty.\n");
     return(0);
    }

 while (fp)
       {
        if (!strcasecmp(str,fp->name))
           {
            friend_remove(p,fp);
            sprintf(mssg," You remove %s from your list.\n",str);
	    send_pager(p,mssg);
            return(1);
           }
        fp=fp->next;
       }
 sprintf(mssg," %s is not on your list.\n",str);
 send_pager(p,mssg);
 return(0);
}

int friend_list(player*p,char* str)
{
 friend* fp;
 char* oldstack;
 int cnt=0;

 fp=p->friends;

 SLINK(oldstack);

 if (!fp)
    {
     send_pager(p," Your list is currently empty.\n");
     return(0);
    }

 while (fp)
       {
        sprintf(stack,"%-20s - ",fp->name); SNEXT;

        if (fp->flags&FRIEND)
           {   
            sprintf(stack,"[Friend] ");
            SNEXT;
           }
        if (fp->flags&IGNORE)
           {   
            sprintf(stack,"[Ignoring] ");
            SNEXT;
           }
 
        sprintf(stack,"\n"); SNEXT;
        cnt++; fp=fp->next;
       }

 stackbar();
 SEND;

 sprintf(mssg,"------------------- You have %2d player(s) on your list"
               " ------------------------\n",cnt);
 send_pager(p,mssg);
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(1);
}

/*----------------------------Friend Flags----------------------------*/
int friend_flags(player* p,char* name)
{
 friend* fp;
 fp=friend_find(p,name);
 if (!fp) return(0);
 return(fp->flags);
}

friend* friend_find(player* p,char* name)
{
 friend* fp;
 fp=p->friends;
 while (fp)
       {
        if (!strcasecmp(name,fp->name))
           return(fp);
        fp=fp->next;
       }
 return(NULL);
}

int friend_remove(player* p,friend* fp)
{
 if (fp->prev)
    fp->prev->next=fp->next;
 if (fp->next)
    fp->next->prev=fp->prev;

 if (p->friends==fp) p->friends=fp->next;

 if (fp->name) free(fp->name);
 free(fp);
 return(1);
}

int isignore(player* p,player* who)
{
 int flg;

 if (p->privs&ADMIN) return(0); /* Admin can't be ignored */

 flg=friend_flags(who,p->name);
 if (flg&IGNORE) return(1);
 return(0);
}

int friend_add(player* p, char* name,int flags)
{
 friend* fp;

 fp=friend_find(p,name);
 if (fp) 
    {
     if (flags==0)
        {
         friend_remove(p,fp);
         return(1);
        }
     fp->flags=flags;
     return(1);
    }

 fp=calloc(sizeof(friend),1);
 fp->name=strdup(name);
 fp->flags=flags;
 fp->next=p->friends;
 if (p->friends) p->friends->prev=fp;
 p->friends=fp;

 return(1); 
}
