/*
 * editor.c
 * ~~~~~~~~
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "player.h"
#include "proto.h"
#include "config.h"

int editor_on(player* p,int (*done)(struct player_struct*,char*,void*)
              ,void*extra)
{
 if (p->editor_page) free(p->editor_page);
 p->editor_page=NULL;
 p->editor_done=done;
 p->iofunc=editor_line;
 p->editor_extra=extra;

 send_pager(p,"editor>");
 send_itsprompt(p);
 return(1);
}

int editor_line(player* p,char* txt)
{
 char* newstuff;
 if (!p->editor_page) p->editor_page=strdup("");

 if (*txt=='.')
    {
     txt++;

     if (!strcasecmp("del",txt))
        {
         char* t=p->editor_page;
         while (*t) t++;

         /* Zero the first \n if there is one */

         if (t>p->editor_page) t--;
         if (*t=='\n') *t=0;

         /* Is that the end of the buffer? */

         if (t==p->editor_page)
            {
             send_pager(p," The buffer is empty.\n");
            }
         else
            {
             while (t>(p->editor_page) && *t!='\n') t--;
             if (t!=p->editor_page) t++; *t=0;
             send_pager(p," Line deleted.\n");
            }
        }
     else
     if (!strcasecmp("wipe",txt))
        {
         free(p->editor_page);
         p->editor_page=strdup("");
         send_pager(p," Buffer wiped.\n");
        }
     else
     if (!strcasecmp("view",txt))
        {
         send_pager(p,p->editor_page);
        }
     else
     if (!strcasecmp("quit",txt))
        {
         p->iofunc=NULL;
         if (p->editor_page) free(p->editor_page);
         p->editor_page=NULL; p->editor_done=NULL;
         return(1);
        }
     else
     if (!strcasecmp("end",txt))
        {
         p->iofunc=NULL;
         send_pager(p," Text Saved.\n");
         if (p->editor_done)
            {
             char* txt=p->editor_page;
             p->editor_page=NULL;
             (*p->editor_done)(p,txt,p->editor_extra);
             return(1);
            }
         else
            {
             free(p->editor_page); p->editor_page=NULL;
             return(1);
            }
         }
      else
         {
          send_pager(p," Invalid editor command.\n");
         }
    }
 else
    {
     newstuff=malloc(strlen(txt)+strlen(p->editor_page)+128);
     strcpy(newstuff,p->editor_page);
     strcat(newstuff,txt);
     strcat(newstuff,"\n");
     free(p->editor_page);
     p->editor_page=newstuff;
    }

 send_pager(p,"editor>");
 send_itsprompt(p);
 return(1);
}
