/*
 * Commands.c
 * ~~~~~~~~~~  Find command in clist.h and execute.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "player.h"
#include "proto.h"
#include "config.h"

#include "clist.h"

/*---------------------------Miscellaneous----------------------------*/
int mystrcasecmp(char* s1,char* s2)
{
 while (*s1 && *s2)
       {
        if (tolower(*s1)!=tolower(*s2)) return(1);
        s1++; s2++;
       }
 if (!*s1 && !*s2) return(0);
 return(1);
}

/*---------------------Find Command from CLIST.h----------------------*/
int dispatch_command(player* p,char* cmd,char* arg)
{
 const struct command_struct* cs;
 cs=cmds;

 while (cs->name && cs->func)
       {
        if (!mystrcasecmp(cs->name,cmd))
           {
            if ( cs->privs )
	    { 
		if (!(cs->privs&p->privs))
               {
                send_pager(p,"Sorry, you dont have high enough clearance to do that.\n");
                return(0);
               }
                if (!(p->pensflags&SU_DUTY) && mystrcasecmp(cs->name,"on_duty")
		 &&!(cs->privs&RESIDENT)&&!(cs->privs&MAIL)&&!(cs->privs&LIST)
                 &&!(cs->privs&ROOM)&&!(cs->privs&ECHOPRIV)&&!(cs->privs&NEWBIE))
               {
                send_pager(p,"Why not go back on duty first!!\n");
                return(0);
               }
	    }
            return(cs->func(p,arg));
           }
        cs++;
       }
 if(do_social(p,cmd,arg)) return(0);
 send_pager(p,"Unknown Command. \n");
 return(0);
}
