/*
 * clock.c
 * ~~~~~~~
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <time.h>

#include "player.h"
#include "proto.h"
#include "config.h"

#define CLOCK_PERIOD 5
#define TIMEOUT_SEC 0
#define TIMEOUT_USEC 1000000/CLOCK_PERIOD

void timer_expires(int);

char* time2asc(int tt)
{
 static char timebuf[MAX_LINE];
 time_t ttc=(time_t)tt;
 strcpy(timebuf,asctime(localtime(&ttc)));
 killendcr(timebuf);
 return(timebuf);
}

int current_time(void)
{
 return(time(NULL));
}

char* time2strshort(int tm)
{
 int hr,mn,sc;
 static char str[MAX_LINE];

 hr=tm/(60*60);
 tm-=hr*60*60;

 mn=tm/60;
 tm-=mn*60;

 sc=tm;

 sprintf(str,"%02d:%02d:%02d",hr,mn,sc);
 return(str);
}

char* time2str(int tm)
{
 int dy,hr,mn,sc;
 static char str[MAX_LINE];

 dy=tm/(60*60*24);
 tm-=dy*60*60*24;

 hr=tm/(60*60);
 tm-=hr*60*60;

 mn=tm/60;
 tm-=mn*60;

 sc=tm;

 if (dy)
     sprintf(str,"%d Days %d Hours %d Mins %d Secs",dy,hr,mn,sc);
 else
 if (hr)
     sprintf(str,"%d Hours %d Mins %d Secs",hr,mn,sc);
 else
     sprintf(str,"%d Mins %d Secs",mn,sc);

 return(str);
}

int check_uptime(player* p,char* str)
{
 sprintf(mssg," The program has been up for: %s.\n"
              " Total number of logins in that time is %d.\n"
              " The total combined spod time is %s.\n",
	      time2str(uptime),numlogins,time2str(spodtime));
 send_pager(p,mssg);
 return(1);
}

void timer_expires(int sig)
{
 static int nth=0;
 player *p,*who;
 
 nth++;

 if (signal(SIGALRM,timer_expires)<0)
    {
      sprintf(mssg,"Error setting signal.\n");
      tolog("error",mssg);
    }

 if (nth==CLOCK_PERIOD) 
    nth=0;
 else
    return;

 /* Global timer */

 uptime++;

 /* Players timers */

 p=first_player;
 while (p)
       {
        if (p->active&GAME)
           {
            p->login_time++; /* Login time */
            spodtime++;      /* Spod time */
            p->currentidle++; /* Idle up */
            p->login_idle++;   /* Idle up */
            p->currentlogin++; /* Current login time */

            if (p->active&WATCHED)
	    {
		who=find_player(p->who_spook);
		if (!who)  p->active&=~WATCHED;
	    }

           }
        p=p->next;
       }

 /* Shutdown stuff */

 shutdown_messages();
 if (shutdown_time>0) shutdown_time--;

 /* Session stuff */
 if (session_time>0) session_time --;
}

int shutdown_messages(void)
{
 char msg[MAX_LINE];

 if (shutdown_time<0) return(0);

 if ( ((shutdown_time<=60*5) && (shutdown_time%60)==0) ||
      ((shutdown_time<=60) && (shutdown_time%10)==0) ||
      shutdown_time==5
    )
    {
     sprintf(msg,"-=> Shutting down Talker in %s: %s\n",sec2str(shutdown_time),shutdown_reason);
     send_wall(msg,1);
    } 

 return(1);
}

char* sec2str(int secs)
{
 static char str[MAX_LINE];
 if (secs<60)
    sprintf(str,"%d seconds",secs);
 else
    sprintf(str,"%d minutes",secs/60);
 return(str);    
}

int settimeout(void)
{
 struct itimerval iv={0};
 struct itimerval oiv={0};

 iv.it_interval.tv_sec=TIMEOUT_SEC;
 iv.it_interval.tv_usec=TIMEOUT_USEC;
 iv.it_value.tv_sec=TIMEOUT_SEC;
 iv.it_value.tv_usec=TIMEOUT_USEC;
 if (setitimer(ITIMER_REAL,&iv,&oiv))
    {
     sprintf(mssg,"Error setting timer.\n");
     tolog("error",mssg);
    }
 return(0);
}

int start_timer()
{
 if (signal(SIGALRM,timer_expires)<0)
    {
    sprintf(mssg,"Error setting signal.\n");
    tolog("error",mssg);
    }
 settimeout(); 
}

