/*
 * Clist.h
 * ~~~~~~~ Command list
 */

/*-------------------------Command Structure--------------------------*/

/* example:-
 * 		"say",say,CCOMMS,0,
 *		  |    |    |    |-----------------> Command Priv Level.
 * 		  |    |    |----------------------> Command Classification. 
 * 		  |    |---------------------------> Command to execute.
 *		  |--------------------------------> Command Name.
 */

const struct command_struct cmds[]={
		"'",say,CCOMMS,0,
		"`",say,CCOMMS,0,
		"\"",say,CCOMMS,0,
		">",tell,CCOMMS,0,
		".",tell,CCOMMS,0,
		";",emote,CCOMMS,0,
		":",emote,CCOMMS,0,
		"::",pemote,CCOMMS,0,
		":;",pemote,CCOMMS,0,
		";:",pemote,CCOMMS,0,
		";;",pemote,CCOMMS,0,
		"<",remote,CCOMMS,0,
		"<:",premote,CCOMMS,0,
		"<;",premote,CCOMMS,0,
		",",remote,CCOMMS,0,
                ",:",premote,CCOMMS,0,
                ",;",premote,CCOMMS,0,
		"~",think,CCOMMS,0,
		"=",whisper,CCOMMS,0,
		"+",echo,CCOMMS,ECHOPRIV,
		"-",recho,CCOMMS,ECHOPRIV,
		"!",shout,CCOMMS,RESIDENT,
		"(",sing,CCOMMS,0,
		")",rsing,CCOMMS,0,
		"{",rfo,CLIST|CCOMMS,LIST,
		"}",tfo,CLIST|CCOMMS,LIST,
		"?",help,CINFO,0,
		"abort",abort_shutdown,CADMIN,SHUTDOWN,
		"ac",au_echo,CADMIN|CCOMMS,LA|ADMIN,
		"adhide",adhide,CADMIN,CAN_HIDE,
		"admins",list_admin,CINFO,0,
		"adnews",ad_read,CADMIN|CMISC,LA|ADMIN,
		"adpost",ad_post,CADMIN|CMISC,LA|ADMIN,
		"adread",ad_read,CADMIN|CMISC,LA|ADMIN,
		"adwall",wall_admin,CADMIN|CCOMMS,LA|ADMIN,
		"ae",au_emote,CADMIN|CCOMMS,LA|ADMIN,
		"aecho",aecho,CADMIN|CCOMMS,ADMIN,
		"age",age,CCUST,RESIDENT,
		"anull_eng",anull_eng,CLAW|CMIN,LAWYER|MINISTER,
		"anull_mar",anull_mar,CLAW,LAWYER,
		"ap",au_pemote,CADMIN|CCOMMS,LA|ADMIN,
		"as",au_sing,CADMIN|CCOMMS,LA|ADMIN,
		"assist",assist,CSU,SU,
		"at",au_think,CADMIN|CCOMMS,LA|ADMIN,
		"au",au_tell,CADMIN|CCOMMS,LA|ADMIN,
		"back",back,CCUST,RESIDENT,
		"backup",do_backup,CADMIN,ADMIN,
		"banish",banish_name,CADMIN,ADMIN,
		"becho",becho,CADMIN|CCOMMS,ADMIN,
		"birthday",birthday,CCUST,RESIDENT,
		"blank",blank,CSU,SU,
		"bop",bop,CMISC,RESIDENT,
		"bug",bug_report,CMISC,RESIDENT,
		"bump",bump,CADMIN,HCADMIN,
		"check",do_check,0,0,
		"clist",clist,CLIST,LIST,
		"comfy",go_comfy,CSU|CMOVE,SU|PSU,
		"commands",commands,CMISC,0,
		"comment",comment,CMISC,0,
		"comments",comments,CMISC,0,
		"con",confirm_res,CSU,SU,
		"confirm",confirm_res,CSU,SU|PSU,
		"dc",spod_echo,CCOMMS,SPOD,
		"de",spod_emote,CCOMMS,SPOD,
		"debug",debug,CCODER,CODER,
		"desc",desc,CCUST,RESIDENT,
		"description",desc,CCUST,RESIDENT,
		"dibbs",dibbs,CSU,SU,
		"disclaimer",disclaimer,CINFO,0,
		"divorce",divorce,CLAW,LAWYER,
		"drag",drag,CSU,SU,
		"dp",spod_pemote,CCOMMS,SPOD,
		"ds",spod_sing,CCOMMS,SPOD,
		"dt",spod_think,CCOMMS,SPOD,
		"du",spod_tell,CCOMMS,SPOD,
		"dw",list_spods,CINFO,0,
		"echo",echo,CCOMMS,ECHOPRIV,
		"edtime",edtime,CADMIN,ADMIN,
		"email",email,CCUST,RESIDENT,
		"emote",emote,CCOMMS,0,
		"engage",engage,CMIN,MINISTER,
		"entermsg",entermsg,CCUST,ROOM,
		"examine",examine,CINFO,0,
		"exits",list_rooms,CMOVE,ROOM,
		"f",finger,CINFO,0,
		"finger",finger,CINFO,0,
		"force",force,CADMIN,HCADMIN,
		"friend",friend_cmd,CLIST,LIST,
		"fwho",fwho,CLIST,LIST,
		"gag",gag,CSU,SU,
		"gender",set_gender,CCUST,RESIDENT,
		"genelist",genelist,CADMIN|CINFO,ADMIN,
		"go",go,CMOVE,ROOM,
		"grab",grab,CSU|CMOVE,SU,
		"grant",grant,CADMIN,ADMIN,
		"hc",hc_echo,CADMIN|CCOMMS,HCADMIN,
		"hccomment",hc_comment,CADMIN,HCADMIN,
		"hcwall",wall_hcadmin,CADMIN|CCOMMS,HCADMIN,
		"he",hc_emote,CADMIN|CCOMMS,HCADMIN,
		"help",help,CINFO,0,
		"helpme",helpme,CMISC|CINFO,NEWBIE,
		"hide",hide,CCUST|CMOVE,RESIDENT,
		"home",go_home,CMOVE,RESIDENT,
		"hp",hc_pemote,CADMIN|CCOMMS,HCADMIN,
		"hs",hc_sing,CADMIN|CCOMMS,HCADMIN,
		"ht",hc_think,CADMIN|CCOMMS,HCADMIN,
		"hu",hc_tell,CADMIN|CCOMMS,HCADMIN,
		"idea",idea_report,CMISC,0,
		"idle",list_idle,CINFO,0,
		"ignore",ignore,CLIST|CCUST,RESIDENT,
		"jail",jail,CSU,SU,
		"join",join,CMOVE,ROOM,
		"l",look,CINFO,0,
		"leave",go_main,CMOVE,ROOM,
		"list",friend_list,CLIST,LIST,
		"list_new",list_newbies,CINFO|CSU,SU|PSU,
		"list_pflag",list_pen_flags,CCODER|CINFO,CODER,
		"list_priv",list_priv_flags,CSU|CINFO,SU,
		"list_site",list_site,CINFO|CSU,SU,
		"list_su",list_su,CINFO,0,
		"loginmsg",loginmsg,CCUST,RESIDENT,
		"logoutmsg",logoutmsg,CCUST,RESIDENT,
		"look",look,CINFO,0,
		"lsa",list_admin,CINFO,0,
		"lsc",zz_list,CINFO|CADMIN,HCADMIN,
		"lsd",list_spods,CINFO,0,
		"lsl",list_lawyer,CINFO,0,
		"lsm",list_minister,CINFO,0,
                "lsp",list_priv_flags,CSU|CINFO,SU,
		"lsn",list_newbies,CINFO|CSU,SU|PSU,
		"lsu",list_su,CINFO,0,
		"lsw",watch_list,CINFO|CADMIN,SPOOK,
		"make",make_hfile2,CADMIN,ADMIN,
		"mail",mail_cmd,CMISC,MAIL,
		"main",go_main,CMOVE,ROOM,
		"man",help,CINFO,0,
		"marry",marry,CMIN,MINISTER,
		"medit",medit,CADMIN,HCADMIN,
		"motd",motd_check,CINFO,0,
		"muffle",muffle_chan,CCUST|CCOMMS,RESIDENT,
		"news",news_cmd,CMISC,MAIL,
		"nuke",nuke,CSU,NUKE,
		"off_duty",off_su,CSU,SU,
		"on_duty",on_su,CSU,SU,
		"ownpriv",ownpriv,CCUST,RESIDENT,
		"p",list_site,CSU|CINFO,SU,
		"password",password,CCUST,RESIDENT,
		"pemote",pemote,CCOMMS,0,
		"pinfo",pinfo,CINFO,0,
		"plan",plan,CCUST,0,
		"prefix",prefix,CCUST,RESIDENT,
		"premote",premote,CCOMMS,0,
		"private",private,CCUST,0,
		"privs",privs,CINFO,0,
		"prod",wake,CMISC,0,
		"prompt",prompt,CCUST,RESIDENT,
		"propose",propose,CMISC,RESIDENT,
		"quit",quit,CMISC,0,
		"qwho",fwho,CLIST,LIST,
		"rbc",robot_echo,CCOMMS|CROBOT,ROBOT_MASTER,
		"rbe",robot_emote,CCOMMS|CROBOT,ROBOT_MASTER,
		"rbop",rbop,CMISC,RESIDENT,
		"rbp",robot_pemote,CCOMMS|CROBOT,ROBOT_MASTER,
		"rbs",robot_sing,CCOMMS|CROBOT,ROBOT_MASTER,
		"rbt",robot_think,CCOMMS|CROBOT,ROBOT_MASTER,
		"rbu",robot_tell,CCOMMS|CROBOT,ROBOT_MASTER,
		"re",repeat,CCOMMS,0,
		"read",mail_read,CMISC,MAIL,
		"recap",recap,CCUST,0,
		"reload",reload,CADMIN,LA|ADMIN,
		"remote",remote,CCOMMS,0,
		"remove",revokep,CADMIN,ADMIN,
		"rename",rename_cmd,CSU,SU,
		"repeat",repeat,CCOMMS,0,
		"res_count",res_count,CINFO,0,
		"res",resident,CSU,SU,
		"reset_idle",reset_idle,CADMIN,ADMIN,
		"reset_motd",reset_motd,CADMIN,ADMIN,
		"reset_session",reset_session,CSU|CMISC,SU,
		"reset_sumotd",reset_sumotd,CADMIN,ADMIN,
		"resident",resident,CSU,SU|PSU,
		"recho",recho,CCOMMS,ECHOPRIV,
		"revoke",revokep,CADMIN,ADMIN,
		"reboot",shutdown_talker,CADMIN,SHUTDOWN,
		"rf",rf,CLIST,LIST,
		"rfo",rfo,CLIST,LIST,
		"rlloc",rlloc,CCUST,RESIDENT,
		"rlname",rlname,CCUST,RESIDENT,
		"rm_bop",rm_bop,CSU,SU,
		"rm_move",rm_move,CADMIN,ADMIN,
		"rm_shout",rm_shout,CSU,SU,
		"rm_sing",rm_sing,CSU,SU,
		"robot",robot_do,CMISC|CROBOT,ROBOT_MASTER,
		"rooms",list_rooms,CMOVE,0,
		"rsing",rsing,CCOMMS,0,
		"rt",rthink,CCOMMS,0,
		"rthink",rthink,CCOMMS,0,
		"rules",rules,CINFO,0,
		"save",save,CMISC,RESIDENT,
		"say",say,CCOMMS,0,
		"sc",su_echo,CSU|CCOMMS,SU|PSU,
		"scare",scare,CSU,SU,
		"se",su_emote,CSU|CCOMMS,SU|PSU,
		"seeecho",seeecho,CINFO,0,
		"seesess",see_session,CINFO,RESIDENT,
		"session",session,CMISC,0,
		"sethome",set_home,CMOVE,RESIDENT,
		"set_ipname",set_ipname,CADMIN|CCUST,HCADMIN,
                "set_ipnum",set_ipnum,CADMIN|CCUST,HCADMIN,
		"set_lsu",set_lsu,CADMIN|CCUST,HCADMIN,	
		"sh",showhelp,CSU,SU|PSU,
		"shout",shout,CCOMMS,RESIDENT,
		"showhelp",showhelp,CSU,SU,
		"shutdown",shutdown_talker,CADMIN,SHUTDOWN,
		"siteban",banish_site,CADMIN,ADMIN,
		"sing",sing,CCOMMS,0,
		"smess",saved_msg,CCOMMS,RESIDENT,
		"socials",list_socials,CMISC,0,
		"socs",list_socials,CMISC,0,
		"sp",su_pemote,CSU|CCOMMS,SU|PSU,
		"spods",list_spods,CINFO,0,
		"ss",su_sing,CSU|CCOMMS,SU|PSU,
		"st",su_think,CSU|CCOMMS,SU|PSU,
		"su",su_tell,CSU|CCOMMS,SU|PSU,
		"sucomment",su_comment,CSU,SU,
		"sumotd",sumotd_check,CINFO|CSU,SU|PSU,
		"sunew",snew,CSU|CMISC,SU|PSU,
		"sunews",sunews_cmd,CMISC|CSU,SU,
		"suwall",wall_su,CADMIN|CCOMMS,LA|ADMIN,
		"swarn",saved_warn,CCOMMS|CSU,SU,
		"tell",tell,CCOMMS,0,
		"tf",tf,CLIST|CCOMMS,LIST,
		"tfo",tfo,CLIST|CCOMMS,LIST,
		"think",think,CCOMMS,0,
		"time",telltime,CINFO,0,
		"title",title,CCUST,RESIDENT,
		"toggle",toggle,CCUST,RESIDENT,
		"trace",trace,CSU,TRACE,
		"unbanish",unbanish_name,CADMIN,ADMIN,
		"unengage",unengage,CMIN|CLAW,MINISTER|LAWYER,
		"ungag",ungag,CSU,SU,
		"unjail",unjail,CSU,SU,
		"update",update_players,CCODER,CODER,
		"uptime",check_uptime,CINFO,0,
		"url",url,CCUST,0,
		"validate_email",validate_email,CSU,SU,
		"vbanish",vbanish,CSU|CINFO,SU,
		"version",version,CINFO,0,
		"vlog",vlog,CADMIN|CINFO,VLOG,
		"vnew",vnew,CINFO,0,
		"w",who,CINFO,0,
		"wake",wake,CMISC,0,
		"wall",wall_talker,CADMIN|CCOMMS,LA|ADMIN,
		"warn",warn,CSU,SU,
		"watch",watch_player,CMISC|CADMIN,SPOOK,
		"web",make_web_index,CWEB,WEB,
		"where",where,CINFO,0,
		"whisper",whisper,CCOMMS,0,
		"who",who,CINFO,0,
		"whois",whois,CINFO,0,
		"x",examine,CINFO,0,
		"yoyo",yoyo,CSU,SU,
		"zc",zz_echo,CCOMMS,RESIDENT,
		"ze",zz_emote,CCOMMS,RESIDENT,
		"zp",zz_pemote,CCOMMS,RESIDENT,
		"zs",zz_sing,CCOMMS,RESIDENT,
		"zt",zz_think,CCOMMS,RESIDENT,
		"zu",zz_tell,CCOMMS,RESIDENT,
		"zw",zz_who,CCOMMS,RESIDENT,
		"zz",zz_join,CCOMMS,RESIDENT,
		NULL,NULL,0,0
};
