/*
 * Check.c
 * ~~~~~~~ Check command.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "player.h"
#include "proto.h"
#include "config.h"

/*-------------------------Check Structure----------------------------*/
const struct check_struct check[]={
		"info",check_info,ADMIN,
		"ip",list_site,SU,
		"mail",mail_check,MAIL,
		"news",news_check,MAIL,
		"pflags",list_pen_flags,CODER,
		"privs",list_priv_flags,ADMIN,
		"sunews",sunews_check,SU,
		NULL,NULL,0,
		};

/*------------------------------Pick Check----------------------------*/
int do_check(player* p,char* str)
{
 char* oldstack; 
 int cnt=0;
 char *txt,*t;
 const struct check_struct* cs;
 cs=check;

 txt=str;

 while (isspace(*txt)) txt++;
 t=txt; while (isalnum(*t)) t++;
 if (*t) {*t=0; t++;}
 while (isspace(*t)) t++; str=t;

 SLINK(oldstack);

 while (cs->name)
       {
        if (!mystrcasecmp(cs->name,txt) && p->privs&cs->priv)
		return(cs->func(p,str));
	cs++;
	}

 cs=check;
 while (cs->name)
       {
	if((p->privs&cs->priv)==cs->priv)
         {
            if (cnt>65) {*stack++='\n'; cnt=0;}
            if (cnt)
               sprintf(stack,", %s",cs->name);
            else
               sprintf(stack," %s",cs->name);
            cnt+=strlen(stack);
            SNEXT;
         }
        cs++;
       }
 *stack++='\n'; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(1);
}

