/*
 * Channel Commands   
 * ~~~~~~~~~~~~~~~~   Z-HC-Admin-SU-Spod-Robot
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "player.h"
#include "proto.h"
#include "config.h"


/*------------------------------Z Channel-----------------------------*/
int zz_list(player* p,char* str)
{
 player* who;
 char*   oldstack;

 who=first_player;

 SLINK(oldstack);

 stackbar();
 sprintf(stack,"Current ZChannels.\n");
 SNEXT
 stackbar();

 while (who)
 {
   if (who->zchan && !who->zchan[0]==0)  
   {
    sprintf(stack,"%-20s:%s ",who->name,who->zchan);
    SNEXT
   }
   who=who->next;
 }
 sprintf(stack,"\n");
 SNEXT;
 stackbar();
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(0);
}

int zz_who(player* p,char* str)
{
 player* who;
 char*   oldstack;

 who=first_player;

 SLINK(oldstack);

 stackbar();
 sprintf(stack,"People on ZChannel %s\n",p->zchan);
 SNEXT
 stackbar();

 while (who)
 {
   if (who->zchan && !who->zchan[0]==0)  
   {
     if(!strcasecmp(who->zchan,p->zchan))
     {
      sprintf(stack,"%s ",who->name);
      SNEXT
     }
   }
   who=who->next;
 }
 sprintf(stack,"\n");
 SNEXT;
 stackbar();
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(0);
}

int zz_join(player* p,char* str)
{
 if (strlen(str)>10)
 {
  send_pager(p," Try something a bit shorter.\n");
  return(1);
 }
 return(setattrib(p,&p->zchan,"ZZ channel",str));
}

int zz_think(player* p,char* str)			
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: zt <message> \n");
      return(0);
    }

 if (!p->zchan || p->zchan[0]==0)
    {
      send_pager(p," You need to join a channel first.\n");
      return(0);
    }

 add_tag_zchan(p,tag,0);
 channel_think(p,str,tag,p->zchan); free(tag);
 return(1);
}

int zz_tell(player* p,char* str)			 
{
 Tag tag=tag_new(); 

 if (!*str)
    {
      send_pager(p," Format: zu <message> \n");
      return(0);
    }

 if (!p->zchan || p->zchan[0]==0)
    {
      send_pager(p," You need to join a channel first.\n");
      return(0);
    }

 add_tag_zchan(p,tag,0);
 channel_tell(p,str,tag,p->zchan); free(tag);
 return(1);
}

int zz_emote(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: ze <message> \n");
      return(0);
    }

 if (!p->zchan || p->zchan[0]==0)
    {
      send_pager(p," You need to join a channel first.\n");
      return(0);
    }

 add_tag_zchan(p,tag,0);
 channel_emote(p,str,tag,p->zchan); free(tag);
 return(1);
}

int zz_sing(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: zs <message> \n");
      return(0);
    }

 if ( !p->zchan || p->zchan[0]==0)
    {
      send_pager(p," You need to join a channel first.\n");
      return(0);
    }


 add_tag_zchan(p,tag,0);
 channel_sing(p,str,tag,p->zchan); free(tag);
 return(1);
}

int zz_echo(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: zc <message> \n");
      return(0);
    }

 if (!p->zchan || p->zchan[0]==0)
    {
      send_pager(p," You need to join a channel first.\n");
      return(0);
    }


 add_tag_zchan(p,tag,0);
 channel_echo(p,str,tag,p->zchan); free(tag);
 return(1);
}

int zz_pemote(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: zp <message> \n");
      return(0);
    }

 if (!p->zchan || p->zchan[0]==0)
    {
      send_pager(p," You need to join a channel first.\n");
      return(0);
    }


 add_tag_zchan(p,tag,0);
 channel_pemote(p,str,tag,p->zchan); free(tag);
 return(1);
}

/*---------------------------Robot Channel-----------------------------*/
int robot_think(player* p,char* str)			
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: rbt <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,ROBOT_MASTER,tag,M_ROBOT);
 channel_think(p,str,tag,"Robot"); free(tag);
 return(1);
}

int robot_tell(player* p,char* str)			 
{
 Tag tag=tag_new(); 

 if (!*str)
    {
      send_pager(p," Format: rbu <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,ROBOT_MASTER,tag,M_ROBOT);
 channel_tell(p,str,tag,"Robot"); free(tag);
 return(1);
}

int robot_emote(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: rbe <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,ROBOT_MASTER,tag,M_ROBOT);
 if (p->active&IS_ROBOT)
     channel_emote2(p,str,tag,"Robot");  
 else
     channel_emote(p,str,tag,"Robot"); 
 free(tag);
 return(1);
}

int robot_sing(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: rbs <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,ROBOT_MASTER,tag,M_ROBOT);
 channel_sing(p,str,tag,"Robot"); free(tag);
 return(1);
}

int robot_echo(player* p,char* str)			 
{
 Tag tag=tag_new(); 

 if (!*str)
    {
      send_pager(p," Format: rbc <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,ROBOT_MASTER,tag,M_ROBOT);
 channel_echo(p,str,tag,"Robot"); free(tag);
 return(1);
}

int robot_pemote(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: rbp <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,ROBOT_MASTER,tag,M_ROBOT);
 channel_pemote(p,str,tag,"Robot"); free(tag);
 return(1);
}

/*--------------------------HC-Admin Channel---------------------------*/

int hc_think(player* p,char* str)			
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: ht <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,HCADMIN,tag,M_HCADMIN);
 channel_think(p,str,tag,"HCAdmin"); free(tag);
 return(1);
}

int hc_tell(player* p,char* str)			 
{
 Tag tag=tag_new(); 

 if (!*str)
    {
      send_pager(p," Format: hu <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,HCADMIN,tag,M_HCADMIN);
 channel_tell(p,str,tag,"HCAdmin"); free(tag);
 return(1);
}

int hc_emote(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: he <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,HCADMIN,tag,M_HCADMIN);
 channel_emote(p,str,tag,"HCAdmin"); free(tag);
 return(1);
}

int hc_sing(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: hs <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,HCADMIN,tag,M_HCADMIN);
 channel_sing(p,str,tag,"HCAdmin"); free(tag);
 return(1);
}

int hc_echo(player* p,char* str)			 
{
 Tag tag=tag_new(); 

 if (!*str)
    {
      send_pager(p," Format: hc <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,HCADMIN,tag,M_HCADMIN);
 channel_echo(p,str,tag,"HCAdmin"); free(tag);
 return(1);
}

int hc_pemote(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: hp <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,HCADMIN,tag,M_HCADMIN);
 channel_pemote(p,str,tag,"HCAdmin"); free(tag);
 return(1);
}

/*----------------------------Admin Channel---------------------------*/

int au_think(player* p,char* str)			
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: at <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,ADMIN|LA,tag,M_ADMIN);
 channel_think(p,str,tag,"Admin"); free(tag);
 return(1);
}

int au_tell(player* p,char* str)			 
{
 Tag tag=tag_new(); 

 if (!*str)
    {
      send_pager(p," Format: au <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,ADMIN|LA,tag,M_ADMIN);
 channel_tell(p,str,tag,"Admin"); free(tag);
 return(1);
}

int au_emote(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: ae <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,ADMIN|LA,tag,M_ADMIN);
 channel_emote(p,str,tag,"Admin"); free(tag);
 return(1);
}

int au_sing(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: as <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,ADMIN|LA,tag,M_ADMIN);
 channel_sing(p,str,tag,"Admin"); free(tag);
 return(1);
}

int au_echo(player* p,char* str)			 
{
 Tag tag=tag_new(); 

 if (!*str)
    {
      send_pager(p," Format: ac <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,ADMIN|LA,tag,M_ADMIN);
 channel_echo(p,str,tag,"Admin"); free(tag);
 return(1);
}

int au_pemote(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: ap <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,ADMIN|LA,tag,M_ADMIN);
 channel_pemote(p,str,tag,"Admin"); free(tag);
 return(1);
}

/*--------------------------Spod Channel------------------------------*/
int spod_think(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: dt <message> \n");
      return(0);
    }
 add_tag_chan_privs(p,SPOD,tag,M_SPOD);
 channel_think(p,str,tag,"Spod"); free(tag);
 return(1);
}

int spod_tell(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: du <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,SPOD,tag,M_SPOD);
 channel_tell(p,str,tag,"Spod"); free(tag);
 return(1);
}

int spod_emote(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: de <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,SPOD,tag,M_SPOD);
 channel_emote(p,str,tag,"Spod"); free(tag);
 return(1);
}

int spod_sing(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: ds <message> \n");
      return(0);
    }

 add_tag_privs(p,SPOD,tag,0);
 channel_sing(p,str,tag,"SPOD"); free(tag);
 return(1);
}

int spod_echo(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: dc <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,SPOD,tag,M_SPOD);
 channel_echo(p,str,tag,"Spod"); free(tag);
 return(1);
}

int spod_pemote(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: dp <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,SPOD,tag,M_SPOD);
 channel_pemote(p,str,tag,"Spod"); free(tag);
 return(1);
}

/*----------------------------SU Channel------------------------------*/

int su_think(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: st <message> \n");
      return(0);
    }
 add_tag_chan_privs(p,SU,tag,M_SU);
 channel_think(p,str,tag,"SU"); free(tag);
 return(1);
}

int su_tell(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: su <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,SU,tag,M_SU);
 channel_tell(p,str,tag,"SU"); free(tag);
 return(1);
}

int su_emote(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: se <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,SU,tag,M_SU);
 channel_emote(p,str,tag,"SU"); free(tag);
 return(1);
}

int su_sing(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: ss <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,SU,tag,M_SU);
 channel_emote(p,str,tag,"SU"); free(tag);
 return(1);
}

int su_echo(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: sc <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,SU,tag,M_SU);
 channel_echo(p,str,tag,"SU"); free(tag);
 return(1);
}

int su_pemote(player* p,char* str)			 
{
 Tag tag=tag_new();

 if (!*str)
    {
      send_pager(p," Format: sp <message> \n");
      return(0);
    }

 add_tag_chan_privs(p,SU,tag,M_SU);
 channel_pemote(p,str,tag,"SU"); free(tag);
 return(1);
}

/*--------------------------Channel Command's---------------------------*/

int channel_emote(player* p,char* str,Tag tw,char* nm)	 
{
 sprintf(cmsg,"[%s] <%s %s>\n",nm,p->name,str);
 send_pager(p,cmsg);

 while (*tw)
       {
        bold(*tw,1);
        send_pager(*tw,cmsg);
        bold(*tw,0);
        tw++;
       }
 return(1);
}

int channel_emote2(player* p,char* str,Tag tw,char* nm)	 
{
 sprintf(cmsg,"[%s] !<%s>\n",nm,str);

 while (*tw)
       {
        bold(*tw,1);
        send_pager(*tw,cmsg);
        bold(*tw,0);
        tw++;
       }
 return(1);
}

int channel_think(player* p,char* str,Tag tw,char* nm)  
{
 sprintf(cmsg,"[%s] <%s thinks . o O ( %s )>\n",nm,p->name,str);
 send_pager(p,cmsg);

 while (*tw)
       {
        bold(*tw,1);
        send_pager(*tw,cmsg);
        bold(*tw,0);
        tw++;
       }
 return(1);
}

int channel_tell(player* p,char* str,Tag tw,char* nm)  
{
 sprintf(cmsg,"[%s] <%s> %s\n",nm,p->name,str);
 send_pager(p,cmsg);

 while (*tw)
       {
        bold(*tw,1);
        send_pager(*tw,cmsg);
        bold(*tw,0);
        tw++;
       }
 return(1);
}

int channel_sing(player* p,char* str,Tag tw,char* nm)  
{
 sprintf(cmsg,"[%s] <%s sings o*~( %s )~*\n",nm,p->name,str);
 send_pager(p,cmsg);

 while (*tw)
       {
        bold(*tw,1);
        send_pager(*tw,cmsg);
        bold(*tw,0);
        tw++;
       }
 return(1);
}

int channel_echo(player* p,char* str,Tag tw,char* nm)  
{
 sprintf(cmsg,"[%s] <+ [%s] %s\n",nm,p->name,str);
 send_pager(p,cmsg);

 while (*tw)
       {
        bold(*tw,1);
        send_pager(*tw,cmsg);
        bold(*tw,0);
        tw++;
       }
 return(1);
}

int channel_pemote(player* p,char* str,Tag tw,char* nm)  
{
 sprintf(cmsg,"[%s] <%s's %s>\n",nm,p->name,str);
 send_pager(p,cmsg);

 while (*tw)
       {
        bold(*tw,1);
        send_pager(*tw,cmsg);
        bold(*tw,0);
        tw++;
       }
 return(1);
}
