/*
 * Basic.c
 * ~~~~~~~ Basic commands
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "player.h"
#include "proto.h"
#include "config.h"

/*----------------------Miscellaneous Commands------------------------*/
int set_gender(player* p,char* str)
{
 player* who;

 if (!*str)
 {
   send_pager(p," Format: gender <male/female>\n");
   return(0);
 }

 if (!strcmp(str,"male") || !strcmp(str,"m"))
 {
   p->gender=1;
   send_pager(p," You set your Gender to be male\n");
   return(0);
 }
 else
 if (!strcmp(str,"female") || !strcmp(str,"f"))
 {
   p->gender=2;
   send_pager(p," You set your Gender to be female\n");
   return(0);
 }
 else
 {
   send_pager(p," Format: gender <male/female>\n");
   return(0);
 }
}

int session(player* p,char* str)
{
 player* who;
 char*   oldstack;

 if (!*str || session_time>0)
 {
   SLINK(oldstack);

   sprintf(stack," The session is currently '%s'\n",session_is);
   SNEXT;
   if (session_time<=0)
      sprintf(stack,"   It was set by %s and can be reset in no time at all.\n",session_did);
   else
      sprintf(stack,"   It was set by %s and can be reset in %s.\n",session_did,sec2str(session_time));

   SNEXT; SEND;
   send_pager(p,oldstack);
   SUNLINK(oldstack);
 }
 else
 {
   who=first_player;
   while(who)
   {
     if (who->comment) who->comment[0]=0;
     who=who->next;
   }
   strcpy(session_is,str);
   session_time=600;
   strcpy(session_did,p->name);
   sprintf(mssg," %s sets the session to '%s'\n",p->name,str);
   send_wall(mssg,1);
   sprintf(mssg,"%s\n",str);
   do_debug("code",mssg);
 }
 return(0);
}

int comments(player* p,char* str)
{
 player* who;
 char*   oldstack;

 SLINK(oldstack);
 stackbar();
 sprintf(stack," Session: %s\n",session_is);
 SNEXT;
 stackbar();

 who=first_player;
 while (who)
 {
   if (who->comment && who->comment[0]!=0)
     sprintf(stack,"%-20s : %s\n",who->name,who->comment);
   else
     sprintf(stack,"%-20s :\n",who->name);
   SNEXT;
   who=who->next;
 }

 stackbar();
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(0);
}

int save(player* p,char* str)    
{
 save_player(p);
 send_pager(p," -=> Character Saved.  'Have a Nice Day!' <=-\n");
 return(1);
}

int quit(player* p,char* str) 
{
 do_debug("code","Player quit!\n");
 return(logoff_player(p));
}

/*-----------------------Information Commands-------------------------*/
int vnew(player* p,char* txt)    
{
 return(show_file(p,"vnew"));
}

int disclaimer(player* p,char* txt)
{
 return(show_file(p,"disclaimer"));
}

int rules(player* p,char* txt)
{
 return(show_file(p,"rules"));
}

int version(player* p, char* str)        
{
 send_pager(p,global_data[G_VERSION]);
 return(1);
}

int whois(player* p,char* str)   
{
 char* buf;
 char* fname;

 if(!*str)
 {
  send_pager(p," Format: whois <name>\n");
  return(0);
 } 

 fname=malloc(strlen(str)+1+strlen(WHOIS_PATH));
 sprintf(fname,WHOIS_PATH,str);
 buf=strap_file(fname); free(fname);
 if (!buf)
    {
    sprintf(mssg," Sorry there is no 'whois %s'.\n",str);
    send_pager(p,mssg);
    return(0);
    }
 send_pager(p,buf);
 free(buf);
 return(0);
}

int pinfo(player* p,char* str)
{
 player* who;
 char* oldstack;
 SLINK(oldstack);

 who=p;

 if(p->privs&SU)
 {
  if(!*str)
  {
   who=p;
  }
  else
  {
   who=player_arg_hard(p,&str);
   if (!who) who=p;
  }
 }

 stackbar();
 sprintf(stack,"Player Information:        <%s>\n",who->name);
 SNEXT;
 stackbar();
 sprintf(stack,"Entermsg: %s %s\n",who->name,who->emsg);
 SNEXT;
 stackbar();
 sprintf(stack,"Loginmsg: %s %s\n",who->name,who->loginmsg);
 SNEXT;
 stackbar();
 sprintf(stack,"Logoutmsg: %s %s\n",who->name,who->logoutmsg);
 SNEXT;
 stackbar();
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 unload_hard(who);
 return(0);
}

int telltime(player* p,char* str)                
{
 char* oldstack;
 SLINK(oldstack);
 sprintf(stack," Talker Time is -> %s\n",time2asc(current_time()));
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(1);
}

int res_count(player*p,char* str) 
{
 player*        who;
 DIR*           dr;
 char*          pname;
 char*          dpath;
 char*          oldstack;
 int hc=0,ad=0,la=0,su=0,code=0,psu=0,res=0;
 int spod=0,law=0,min=0;
 int mar=0,eng=0,cnt=0;

 dpath=strdup(PFILES_DIR);

 dr=lsr_start(dpath);
 while ((pname=lsr_next(dr)))
       {
	if (cnt>1)
	{
	 who=find_player_hard(pname);
         if(!(who->privs&BANISHED))
	 {
	  if (who->privs&HCADMIN) hc++;
	  else
	  if (who->privs&ADMIN) ad++;
	  else
	  if (who->privs&LA) la++;
	  else
	  if (who->privs&SU) su++;
          else
          if (who->privs&PSU) psu++;
	  else res++;
	  if (who->privs&CODER)       code++;
	  if (who->privs&SPOD)        spod++;
	  if (who->privs&LAWYER)      law++;
	  if (who->privs&MINISTER)    min++;
	  if (who->pensflags&MARRIED) mar++;
	  if (who->pensflags&ENGAGED) eng++;
         }
	 unload_hard(who);
	}
	cnt++;
       }

 cnt=cnt - 2;
 SLINK(oldstack);
 sprintf(stack,global_data[G_RCOUNT],hc,ad,la,su,code,psu,spod,law,min,mar,eng,res,cnt);
 SNEXT; SEND;
 send_pager(p,oldstack);
 return(1);
}

int motd_check(player* p,char* str)              
{
 send_pager(p,global_data[G_MOTD]);
}

int where(player* p,char* str) 
{
 player* f;
 int cnt=0;
 char* oldstack;

 f=first_player;
 while (f) {if (f->active&GAME || p->privs&HCADMIN) cnt++; f=f->next;}

 SLINK(oldstack);

 if (cnt<=1)
 {
  sprintf(stack,"-------------------  You are alone on the program ---"
		"--------------------------\n",cnt);
  SNEXT;
  if(p->privs&ADMIN) stackwhereadmin(p);
  else  stackwhere(p);
  SNEXT; 
  stackbar();
  SEND;
  send_pager(p,oldstack);
  SUNLINK(oldstack);
  return(0);
 }

 sprintf(stack,"-------------------  There are %2d people on the program"
	       " -----------------------\n",cnt);
 SNEXT;

 f=first_player;
 while (f)
       {
	if (p->privs&ADMIN)
	{
	 if (!(f->active&GAME) && p->privs&HCADMIN) 
	 {
	  sprintf(stack,"(HIDE) "); SNEXT;
	  stackwhereadmin(f);
	 }
	 if (f->active&GAME) stackwhereadmin(f);
	}
	else
	 if (f->active&GAME) stackwhere(f);
	f=f->next;
       } 

 stackbar();
 SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(0);
}

int who(player* p,char* str)     
{
 player* f;
 int cnt=0;
 char* oldstack;

 if (p->pensflags&SEE_SESS)
 {
 comments(p,NULL);
 return(0);
 }

 f=first_player;
 while (f) {if (f->active&GAME || p->privs&HCADMIN) cnt++; f=f->next;}

 SLINK(oldstack);

 if (cnt<=1)
    {
     sprintf(stack,"You are all alone on the program\n");
     SNEXT; SEND;
     send_pager(p,oldstack);
     SUNLINK(oldstack);
     return(0);
    }

 sprintf(stack,"-------------------  There are %2d people on the program"
	       " -----------------------\n",cnt);
 SNEXT;

 f=first_player;
 while (f)
       {
	if (!(f->active&GAME) && p->privs&HCADMIN) 
	{
	sprintf(stack,"(HIDE) "); SNEXT;
	stackfullname(f);
	}
	if (f->active&GAME) stackfullname(f);
	f=f->next;
       } 

 stackbar();
 SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(0);
}

int look(player* p,char* str)            
{
 player* f;
 int cnt=0;
 char* oldstack;

 f=first_player;
 while (f) {if ((f->active&GAME || p->privs&HCADMIN)&&(f->room==p->room)) cnt++; f=f->next;}
 SLINK(oldstack);
 if (cnt<=1) 
	{ 
	 send_pager(p,room_data[rooms[p->room].desc]);
	 sprintf(stack,"You are alone here\n");
	 SNEXT; SEND;
	 send_pager(p,oldstack);
	 SUNLINK(oldstack);
	 return(0);
	}
 f=first_player;
 while(f)
 while (f)
       {
	if (!(f->active&GAME) && p->privs&HCADMIN && (f->room==p->room))
	{
	sprintf(stack,"(HIDE) "); SNEXT;
	stackfullname(f);
	}
	if (f->active&GAME && (f->room==p->room)) stackfullname(f);
	f=f->next;
       }
 SEND;
 send_pager(p,room_data[rooms[p->room].desc]);
 send_pager(p,"In the room you see...\n");
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(0);
}

int help(player* p,char* str)    
{
 char* txt;
 char* buf;
 char* fname;

 txt=str; while (isalnum(*txt) || *txt=='_') txt++; *txt=0;
 if (!*str) str="help";
 fname=malloc(strlen(str)+1+strlen(HELP_PATH));
 sprintf(fname,HELP_PATH,str);
 buf=strap_file(fname); free(fname);
 if (!buf)
    {
     sprintf(mssg," There is no help on the subject of '%s'\n",str);
     send_pager(p,mssg);
     return(0);
    }
 if(((*buf=='S') && !(p->privs&PSU))||((*buf=='L') && !(p->privs&LA))||
    ((*buf=='A') && !(p->privs&ADMIN))||((*buf=='H') && !(p->privs&HCADMIN))
    ||((*buf=='C') && !(p->privs&CODER)))
    {
     send_pager(p," Sorry You Can not Read that Help File!\n");
     return(0);
    }
 buf[0]=13;
 send_pager(p,buf);
 free(buf);
 return(1);
}

int commands(player* p,char* str) 
{
 int cnt=0;
 int com=0;
 int did=0;
 const struct command_struct* cs;
 char* oldstack; SLINK(oldstack);

 if (!*str)
 {
 send_pager(p," Format: commands\n      " 
	      "[all|comms|move|info|custom|list|misc|soc");
 if (p->privs&LAWYER) send_pager(p,"|law");
 if (p->privs&MINISTER) send_pager(p,"|min");
 if (p->privs&SU) send_pager(p,"|su");
 if (p->privs&LA || p->privs&ADMIN) send_pager(p,"|admin");
 if (p->privs&CODER) send_pager(p,"|coder");
 if (p->privs&ROBOT_MASTER) send_pager(p,"|robot");
 send_pager(p,"]\n");
 return(0);
 }

 if (!strcmp("comms",str)) { com|=CCOMMS; did=1; }
 if (!strcmp("move",str)) {com|=CMOVE; did=1; }
 if (!strcmp("info",str)) {com|=CINFO; did=1; }
 if (!strcmp("custom",str)) {com|=CCUST; did=1; }
 if (!strcmp("list",str)) {com|=CLIST; did=1; }
 if (!strcmp("misc",str)) {com|=CMISC; did=1; }
 if (!strcmp("law",str)) {com|=CLAW; did=1; }
 if (!strcmp("min",str)) {com|=CMIN; did=1; }
 if (!strcmp("su",str)) {com|=CSU; did=1; }
 if (!strcmp("admin",str)) {com|=CADMIN; did=1; }
 if (!strcmp("coder",str)) {com|=CCODER; did=1; }
 if (!strcmp("robot",str)) {com|=CROBOT; did=1; }
 if (!strcmp("soc",str)) 
 {
  send_pager(p,"Socials:-\n");
  list_socials(p,NULL);
  return(0);
 }

 if (!strcmp("all",str)) 
 { 
  com=-1;
  did=1;
 }

 if (!did)
 {
 send_pager(p," Format: commands\n      "
	      "[all|comms|move|info|custom|list|misc|soc");
 if (p->privs&LAWYER) send_pager(p,"|law");
 if (p->privs&MINISTER) send_pager(p,"|min");
 if (p->privs&SU) send_pager(p,"|su");
 if (p->privs&LA || p->privs&ADMIN) send_pager(p,"|admin");
 if (p->privs&CODER) send_pager(p,"|coder");
 if (p->privs&ROBOT_MASTER) send_pager(p,"|robot");
 send_pager(p,"]\n");
 return(0);
 }

 cs=cmds;
 send_pager(p,"Commands available to you are:-\n");
 stackbar();
 while (cs->name)
       {
	if (((p->privs&cs->privs)==cs->privs) && com&cs->comtype) 
	   {
	    if (cnt>65) {*stack++='\n'; cnt=0;}
	    if (cnt)
	       sprintf(stack,", %s",cs->name);
	    else
	       sprintf(stack," %s",cs->name);
	    cnt+=strlen(stack);
	    SNEXT;
	   }
	cs++;
       }
 sprintf(stack,"\n"); SNEXT;
 stackbar(); SNEXT;
 *stack++='\n'; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);

 return(1);
}

int showignore(player* p,player* who) 
{
 friend* fp;
 int dn=0;

 if (who->ignore&SAY)
    {
     send_pager(p,"You are ignoring says.\n");
     dn++;
    }
 if (who->ignore&FRIENDS)
    {
     send_pager(p,"You are ignoring friends.\n");
     dn++;
    }
 if (who->ignore&LOGIN)
    {
     send_pager(p,"You are ignoring login/logout messages.\n");
     dn++;
    }
 if (who->ignore&MARRY_PROP)
    {
     send_pager(p,"You are ignoring marrage proposals.\n");
     dn++;
    } 
 if (who->ignore&SHOUTS)
    {
     send_pager(p,"You are ignoring shouts.\n");
     dn++;
    }
fp=who->friends;
 while (fp)
       {
	if (fp->flags&IGNORE)
	   {
	    sprintf(mssg,"You are ignoring %s\n",fp->name);
	    send_pager(p,mssg);
	    dn++;
	   }
	fp=fp->next;
       }
 if (!dn)
    send_pager(p," You are not ignoring anyone.\n");
 return(1);
}

/*-------------------------Examine - Finger---------------------------*/
int examine(player* p,char* str) 
{
 player* who;
 char* oldstack;

 if (!*str)
    {
     send_pager(p," Format: examine <player>\n");
     return(0);
    }
 who=player_arg_hard(p,&str); 
 if (!who) return(0);

 if (who->privs&BANISHED)
    {
     send_pager(p," Banished Player.\n");
     unload_hard(who);
     return(0);
    }

 SLINK(oldstack);

 stackbar();
 stackfullname(who);
 stackbar();
 if (p->privs&SU) stacksucomment(who,p);
 stackdesc(who);
 stackirl(who);
 stackmarry(who);
 stackcurrentlogin(who);
 stacklogintime(who);
 if (p==who || p->privs&ADMIN) stackidletime(who);
 sprintf(stack,"Rank: ");
 SNEXT;
 if (who->lsu) sprintf(stack,"[%s] ",who->lsu); else
 if (who->privs&HCADMIN) sprintf(stack,"[HCAdmin] "); else
 if (who->privs&ADMIN) sprintf(stack,"[Admin] "); else
 if (who->privs&LA) sprintf(stack,"[Lower Admin] "); else
 if (who->privs&SU) sprintf(stack,"[Super User] "); else
 if (who->privs&PSU) sprintf(stack,"[Trainee Super User] "); else
 if (who->privs&RESIDENT) sprintf(stack,"[Resident] "); else
 sprintf(stack,"[Newbie] ");
 SNEXT;
 if (who->privs&SADMIN) 
    sprintf(stack,"[Site Admin] ");
 SNEXT;
 if (who->privs&LAWYER)
    sprintf(stack,"[Lawyer] ");
 SNEXT;
 if (who->privs&MINISTER)
    sprintf(stack,"[Minister] ");
 SNEXT;
 if (who->privs&SPOD)
    sprintf(stack,"[Spod] ");
 SNEXT;
 if (who->ownpriv && who->ownpriv[0]!=0)
    sprintf(stack,"[%s]",who->ownpriv);
 SNEXT;
 sprintf(stack,"\n");
 SNEXT
 stackbar();
 if (p->privs&TRACE || p==who || who->pensflags&IP_PUB) stackip(who);
 stackemail(p,who);
 stackurl(who);
 unload_hard(who);
 SEND; send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(1);
}

int finger(player* p,char* str) 
{
 player* who;
 char* oldstack;

 if (!*str)
    {
     send_pager(p," Format: examine <player>\n");
     return(0);
    }
 who=player_arg_hard(p,&str); 
 if (!who) return(0);

 if (who->privs&BANISHED)
    {
     send_pager(p," Banished Player.\n");
     unload_hard(who);
     return(0);
    }

 SLINK(oldstack);

 stackbar();
 stackfullname(who);
 stackbar();
 if (p->privs&SU) stacksucomment(who,p);
 stackdesc(who);
 stackirl(who);
 stackmarry(who);
 stackcurrentlogin(who);
 stacklogintime(who);
 if (p==who || p->privs&ADMIN) stackidletime(who);
 sprintf(stack,"Rank: ");
 SNEXT;
 if (who->lsu) sprintf(stack,"[%s] ",who->lsu); else
 if (who->privs&HCADMIN) sprintf(stack,"[HCAdmin] "); else
 if (who->privs&ADMIN) sprintf(stack,"[Admin] "); else
 if (who->privs&LA) sprintf(stack,"[Lower Admin] "); else
 if (who->privs&SU) sprintf(stack,"[Super User] "); else
 if (who->privs&PSU) sprintf(stack,"[Trainee Super User] "); else
 if (who->privs&RESIDENT) sprintf(stack,"[Resident] "); else
 sprintf(stack,"[Newbie] ");
 SNEXT;
 if (who->privs&SADMIN) 
    sprintf(stack,"[Site Admin] ");
 SNEXT;
 if (who->ownpriv && who->ownpriv[0]!=0)
    sprintf(stack,"[%s]",who->ownpriv);
 SNEXT;
 sprintf(stack,"\n");
 SNEXT
 stackbar();
 if (p->privs&TRACE || p==who || who->pensflags&IP_PUB) stackoldip(who);
 stackemail(p,who);
 stackurl(who);
 stackplan(who);
 stackback(who);
 unload_hard(who);
 SEND; send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(1);
}

/*-------------------------Customise Commands-------------------------*/
int password(player* p,char* str) 
{
 p->pass=NULL;
 get_pass(p);
 return(1);
}

int desc(player* p,char* str)    
{
 if (strlen(str)>160)
 {
  send_pager(p," Try something a bit shorter.\n");
  return(1);
 }
 return(setattrib(p,&p->desc,"description",str));
}

int email(player* p,char* str)   
{
 if (!strchr(str,'@'))
 {
 send_pager(p,"Invalid email\n");
 return(0);
 }
 return(setattrib(p,&p->email,"email",str));
}

int prefix(player* p,char* str)  
{
 if (strlen(str)>15)
 {
  send_pager(p," Try something a bit shorter.\n");
  return(1);
 }
 return(setattrib(p,&p->prefix,"prefix",str));
}

int url(player* p,char* str)                            
{
 return(setattrib(p,&p->url,"url",str));
}

int age(player* p,char* str)
{
 int age;
 age=atoi(str);
 p->age=age;
 return(0);
}

int rlloc(player* p,char* str)
{
 if (strlen(str)>50)
 {
  send_pager(p," Try something a bit shorter.\n");
  return(1);
 }
 return(setattrib(p,&p->rlloc,"IRL Location",str));
}

int rlname(player* p,char* str)
{
 if (strlen(str)>40)
 {
  send_pager(p," Try something a bit shorter.\n");
  return(1);
 }
 return(setattrib(p,&p->rlname,"IRL Name",str));
}

int entermsg(player* p,char* str)
{
 if (strlen(str)>80)
 {
  send_pager(p," Try something a bit shorter.\n");
  return(1);
 }
 return(setattrib(p,&p->emsg,"entermsg",str));
}

int loginmsg(player* p,char* str)
{
 if (strlen(str)>80)
 {
  send_pager(p," Try something a bit shorter.\n");
  return(1);
 }
 return(setattrib(p,&p->loginmsg,"loginmsg",str));
}

int logoutmsg(player* p,char* str)
{
 if (strlen(str)>80)
 {
  send_pager(p," Try something a bit shorter.\n");
  return(1);
 }
 return(setattrib(p,&p->logoutmsg,"logoutmsg",str));
}

int plan(player* p,char* str)
{
 if (strlen(str)>160)
 {
  send_pager(p," Try something a bit shorter.\n");
  return(1);
 }
 return(setattrib(p,&p->plan,"plan",str));
}

int ownpriv(player* p,char* str) 
{
 if (strlen(str)>20)
 {
  send_pager(p," Try something a bit shorter.\n");
  return(1);
 }
 return(setattrib(p,&p->ownpriv,"ownpriv",str));
}

int back(player* p,char* str) 
{
 if (strlen(str)>160)
 {
  send_pager(p," Try something a bit shorter.\n");
  return(1);
 }
 return(setattrib(p,&p->back,"back",str));
}

int comment(player* p,char* str)
{
 if (strlen(str)>100)
 {
  send_pager(p," Try something a bit shorter.\n");
  return(1);
 }
 sprintf(mssg," -=> %s comments.\n",p->name);
 send_wall_bar(p,mssg,1);
 return(setattrib(p,&p->comment,"comment",str));
}

int title(player* p,char* str) 
{
 if (strlen(str)>40)
 {
  send_pager(p," Try something a bit shorter.\n");
  return(1);
 }
 return(setattrib(p,&p->title,"title",str));
}

int prompt(player* p,char* str)  
{
 return(setattrib(p,&p->prompt,"prompt",str));
}

int birthday(player* p,char* str)
{
 int day,month,year;
 char* oldstack;

 if (!*str)
 {
   send_pager(p," Format: birthday <day> <month> <year>\n");
   return(0);
 }

 sscanf(str,"%d %d %d",&day,&month,&year);

 SLINK(oldstack);

 sprintf(stack,"%d",day); SNEXT;
 if (day==1 || day==21 || day==31)
 sprintf(stack,"st "); 
 else
 if (day==2 || day==22 || day==32)
 sprintf(stack,"nd "); 
 else
 if (day==3 || day==23 || day==33)
 sprintf(stack,"rd "); 
 else
 sprintf(stack,"th "); 
 SNEXT;
 sprintf(stack,"of "); SNEXT;
 if (month==1)
 {
    sprintf(stack,"January");
    if (day<=20) p->star_sign=strdup("Capricorn");
    else p->star_sign=strdup("Aquarius");
 }
 if (month==2)
 {
    sprintf(stack,"February"); 
    if (day<=19) p->star_sign=strdup("Aquarius");
    else p->star_sign=strdup("Pisces");
 }
 if (month==3)
 {
    sprintf(stack,"March"); 
    if (day<=21) p->star_sign=strdup("Pisces");
    else p->star_sign=strdup("Aries");
 }
 if (month==4)
 {
    sprintf(stack,"April"); 
    if (day<=19) p->star_sign=strdup("Aries");
    else p->star_sign=strdup("Taurus");
 }
 if (month==5)
 {
    sprintf(stack,"May"); 
    if (day<=20) p->star_sign=strdup("Taurus");
    else p->star_sign=strdup("Gemini");
 }
 if (month==6)
 {
    sprintf(stack,"June"); 
    if (day<=21) p->star_sign=strdup("Gemini");
    else p->star_sign=strdup("Cancer");
 }
 if (month==7)
 {
    sprintf(stack,"July"); 
    if (day<=22) p->star_sign=strdup("Cancer");
    else p->star_sign=strdup("Leo");
 }
 if (month==8)
 {
    sprintf(stack,"August"); 
    if (day<=22) p->star_sign=strdup("Leo");
    else p->star_sign=strdup("Virgo");
 }
 if (month==9)
 {
    sprintf(stack,"September"); 
    if (day<=23) p->star_sign=strdup("Virgo");
    else p->star_sign=strdup("Libra");
 }
 if (month==10)
 {
    sprintf(stack,"October"); 
    if (day<=23) p->star_sign=strdup("Libra");
    else p->star_sign=strdup("Scorpio");
 }
 if (month==11)
 {
    sprintf(stack,"November"); 
    if (day<=22) p->star_sign=strdup("Scorpio");
    else p->star_sign=strdup("Sagittarius");
 }
 if (month==12)
 {
    sprintf(stack,"December"); 
    if (day<=21) p->star_sign=strdup("Sagittarius");
    else p->star_sign=strdup("Capricorn");
 }
 SNEXT;
 sprintf(stack," %d",year);
 SNEXT; SEND;
 p->bday=strdup(oldstack);
 sprintf(mssg," You set your birthday to be the %s\n",oldstack);
 send_pager(p,mssg);
 SUNLINK(oldstack);
 return(0);
}

int see_session(player* p,char* str)
{
 if (p->pensflags&SEE_SESS)
   {
     send_pager(p," -=> Your will no longer see session on who.\n");
     p->pensflags&=~SEE_SESS;
     return(1);
   }
 p->pensflags|=SEE_SESS;
 send_pager(p," -=> Your will now see session on who.\n");
 return(1);
}

int private(player* p,char* str)
{
 if (p->pensflags&PRIVATE)
   {
     send_pager(p," -=> Your email Address is now visible to other users.\n");
     p->pensflags&=~PRIVATE;
     return(1);
   }
 p->pensflags|=PRIVATE;
 send_pager(p," -=> Your email Address is now hidden from other users.\n");
 return(1);
}

int toggle(player* p,char* str)
{
 if (!*str)
 {
 send_pager(p," Format: toggle email/site\n");
 return(1);
 }

 if (!strcmp(str,"email"))
 {
  if (p->pensflags&PRIVATE)
    {
     send_pager(p," -=> Your email Address is now visible to other users.\n");
     p->pensflags&=~PRIVATE;
     return(1);
    }
  p->pensflags|=PRIVATE;
  send_pager(p," -=> Your email Address is now hidden from other users.\n");
 }

 else
 if (!strcmp(str,"site"))
 {
  if (p->pensflags&IP_PUB)
    {
     send_pager(p," -=> Your login site is now hidden from other users.\n");
     p->pensflags&=~IP_PUB;
     return(1);
    }
  p->pensflags|=IP_PUB;
  send_pager(p," -=> Your login site is now visible to other users.\n");
 }

 return(1);
}

int seeecho(player* p,char* str) 
{
 if (p->pensflags&SEE_ECHO)
    {
     send_pager(p," You will nolonger see who echos what.\n");
     p->pensflags&=~SEE_ECHO;
     return(1);
    }
 p->pensflags|=SEE_ECHO;
 send_pager(p," You will now see who echos what.\n");
 return(1);
}

int hide(player* p,char* str)
{
 if (p->pensflags&HIDE)
    {
     send_pager(p," -=> You are no longer hidden from other users.\n");
     p->pensflags&=~HIDE;
     return(1);
    }
 p->pensflags|=HIDE;
 send_pager(p," -=> You hide yourself away from other users.\n");
 return(1);
}

int ignore(player* p,char* str)          
{
 player* who;
 int fl;

 if (!*str)
    {
     showignore(p,p);
     return(1);
    }
 if (!strcasecmp("propose",str) || !strcasecmp("marry",str))
    {
     if (p->ignore&MARRY_PROP)
	{
	 p->ignore&=~MARRY_PROP;
	 send_pager(p,"You are now not ignoring marrage proposals.\n");
	 return(1);
	}
     p->ignore|=MARRY_PROP;
     send_pager(p,"You are now ignoring marrage proposals.\n");
     return(1);
    }
 if (!strcasecmp("shout",str) || !strcasecmp("shouts",str))
    {
     if (p->ignore&SHOUTS)
	{
	 p->ignore&=~SHOUTS;
	 send_pager(p,"You are now not ignoring shouts.\n");
	 return(1);
	}
     p->ignore|=SHOUTS;
     send_pager(p,"You are now ignoring shouts.\n");
     return(1);
    }
 if (!strcasecmp("friends",str))
    {
     if (p->ignore&FRIENDS)
	{
	 p->ignore&=~FRIENDS;
	 send_pager(p,"You are now not ignoring friends.\n");
	 return(1);
	}
     p->ignore|=FRIENDS;
     send_pager(p,"You are now ignoring friends.\n");
     return(1);
    }
 if (!strcasecmp("say",str) || !strcasecmp("says",str))
    {
     if (p->ignore&SAY)
	{
	 p->ignore&=~SAY;
	 send_pager(p,"You are now not ignoring says.\n");
	 return(1);
	}
     p->ignore|=SAY;
     send_pager(p,"You are now ignoring says.\n");
     return(1);
    }
 if (!strcasecmp("login",str) || !strcasecmp("logins",str))
    {
     if (p->ignore&LOGIN)
	{
	 p->ignore&=~LOGIN;
	 send_pager(p,"You are now not ignoring login/logout messages.\n");
	 return(1);
	}
     p->ignore|=LOGIN;
     send_pager(p,"You are now ignoring login/logout messages.\n");
     return(1);
    }
 if (!(p->privs&LIST))
    {
     send_pager(p," You do not have permissions to ignore people.\n");
     return(0);
    }
 who=player_arg_hard(p,&str);
 if (!who) return(0);
 if (who==p)
    {
     send_pager(p," You can not ignore yourself!\n");
     unload_hard(who);
     return(0);
    }
 fl=friend_flags(p,who->name);
 if (fl&IGNORE)
    {
     fl&=~IGNORE;
     sprintf(mssg," You stop ignoring %s\n",who->name);
     send_pager(p,mssg);
     sprintf(mssg," -=> %s stops ignoring you.\n",p->name);
     send_pager(who,mssg);
    } 
 else
    {
     fl|=IGNORE;
     sprintf(mssg," You start ignoring %s\n",who->name);
     send_pager(p,mssg);
     sprintf(mssg," -=> %s starts ignoring you.\n",p->name);
     send_pager(who,mssg);
    }
 friend_add(p,who->name,fl);
 unload_hard(who);
 return(1);
}

/*---------------------------Log Commands-----------------------------*/
int idea_report(player* p, char* str)    
{
 char* oldstack;
 SLINK(oldstack);

 if (!*str)
    {
      send_pager(p,"No Idea?.  Are you Blonde?? :P\n");
      send_pager(p,"Format:  Idea  <idea>\n");
      return(0);
    }

 if (strlen(str)>100)
 {
  send_pager(p," Try something shorter please.\n");
  return(1);
 }

 SNEXT; SEND;
 sprintf(mssg,"%s thinks:  %s\n",p->name,str);
 tolog("idea",mssg);
 send_pager(p,"Thank you. Your idea has been noted.\n");
 su_wall1(p," has the idea: '%s'",str,SU);
 SNEXT; SEND;
 SUNLINK(oldstack);
 return(1);
}  

int bug_report(player* p, char* str)     
{
 char* oldstack;

 SLINK(oldstack);
 if (!*str)
    {
      send_pager(p,"Er, ok, i wont bug report that :P\n");
      return(0);
    }

 if (strlen(str)>150)
 {
  send_pager(p," Thats not a bug, its a monster.\n");
  send_pager(p," Try something shorter please.\n");
  return(1);
 }

 SNEXT; SEND;
 sprintf(mssg,"%s reports:  %s\n",p->name,str);
 tolog("bug",mssg);
 send_pager(p,"  Thank you. Your bug has been logged. The admin will\n");
 send_pager(p,"  view it as soon as possible.\n");
 SNEXT; SEND;
 SUNLINK(oldstack);
 return(1);
}  
