/*
 * Basic.c
 * ~~~~~~~ Basic commands
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "player.h"
#include "proto.h"
#include "config.h"

/*----------------------Communication Commands------------------------*/
int repeat(player* p,char* str)
{
 char* oldstack;

 SLINK(oldstack);

 sprintf(stack,"%s ",str);
 SNEXT;
 sprintf(stack,"%s",p->repeat_str);
 SNEXT; SEND;
 killendcr(p->repeat_type);
 dispatch_command(p,p->repeat_type,oldstack);
 SUNLINK(oldstack);
 return(0);
}

int tell(player* p,char* str) 
{
 Tag who,lp;
 char* oldstack;

 if (!*str)
    {
     send_pager(p," Format: tell <player> <msg>\n");
     return(0);
    }
 who=player_arg_tag(p,&str); 
 strncpy(p->repeat_str, str, MAX_LINE);
 strcpy(p->repeat_type, "tell");
 if (!who) return(0);

 if (!*str)
    {
     send_pager(p," Format: tell <player> <msg>\n");
     return(0);
    }
 SLINK(oldstack);
 sprintf(stack," You tell %s '%s'\n",tag2str(p,who),str);
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 /* Loop on the tag */
 lp=who;
 while (*lp)
       {
	sprintf(stack,"> %s tells %s '%s'",fullname(p),tag2str(*lp,who),str);
	SNEXT; SEND;
	bold(*lp,1); send_pager(*lp,oldstack);
	bold(*lp,0); send_pager(*lp,"\n");
	lp++;
	SUNLINK(oldstack);
       }

 free_tag(who); /* Free tags */
 return(1);
}

int rthink(player* p,char* str)
{
 Tag who,s;
 char* oldstack;

 if (!*str)
    {
     send_pager(p," Format: rthink <player> <msg>\n");
     return(0);
    }
 who=player_arg_tag(p,&str);
 strncpy(p->repeat_str, str, MAX_LINE);
 strcpy(p->repeat_type, "rthink");
 if (!who) return(0);

 if (!*str)
    {
     send_pager(p," Format: rthink <player> <msg>\n");
     return(0);
    }

 if (p->active&GAG)
    {
     send_pager(p," You apear to be unable to talk. It could be that gag you are wearing!\n");
     return(0);
    }

 SLINK(oldstack);
 sprintf(stack," You think . o O ( %s ) to %s\n",str,tag2str(p,who));
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 s=who;
 while (*s)
       {
	sprintf(stack,"> %s thinks . o O ( %s) (to %s)",fullname(p),str,tag2str(*s,who));
	SNEXT; SEND;
	bold(*s,1); send_pager(*s,oldstack);
	bold(*s,0); send_pager(*s,"\n");
	SUNLINK(oldstack); s++;
       }
 free_tag(who); /* Free tags */
 return(1);
}

int recho(player* p,char* str)
{
 player* who;
 char* oldstack;

 if (!*str)
    {
     send_pager(p," Format: recho <player> <msg>\n");
     return(0);
    }
 who=player_arg(p,&str);
 strncpy(p->repeat_str, str, MAX_LINE);
 strcpy(p->repeat_type, "recho");
 if (!who) return(0);

 if (!*str)
    {
     send_pager(p," Format: recho <player> <msg>\n");
     return(0);
    }

 if (p->active&GAG)
    {
     send_pager(p," You apear to be unable to talk. It could be that gag you are wearing!\n");
     return(0);
    }

 SLINK(oldstack);
 sprintf(stack," You recho '%s' to %s\n",str,who->name);
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 if(who->pensflags&SEE_ECHO)
 sprintf(stack,"+ [%s] ",fullname(p));
 else
 sprintf(stack,"+ ");
 SNEXT;
 sprintf(stack,"%s",str);
 SNEXT; SEND;
 bold(who,1); send_pager(who,oldstack);
 bold(who,0); send_pager(who,"\n");
 SUNLINK(oldstack);
 return(1);
}

int rsing(player* p,char* str)
{
 Tag who,s;
 char* oldstack;

 if (!*str)
    {
     send_pager(p," Format: rsing <player> <msg>\n");
     return(0);
    }
 who=player_arg_tag(p,&str);
 strncpy(p->repeat_str, str, MAX_LINE);
 strcpy(p->repeat_type, "rsing");
 if (!who) return(0);

 if (!*str)
    {
     send_pager(p," Format: rsing <player> <msg>\n");
     return(0);
    }

 if (p->active&GAG)
    {
     send_pager(p," You apear to be unable to talk. It could be that gag you are wearing!\n");
     return(0);
    }

 if (p->active&SING)
    {
     send_pager(p," Sorry you have been prevented from singing!\n");
     return(0);
    }

 SLINK(oldstack);
 sprintf(stack," You sing : o*~( %s )~*o to %s\n",str,tag2str(p,who));
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 s=who;
 while (*s)
       {
	sprintf(stack,"> %s sings o*~( %s )~*o (to %s)",fullname(p),str,tag2str(*s,who));
	SNEXT; SEND;
	bold(*s,1); send_pager(*s,oldstack);
	bold(*s,0); send_pager(*s,"\n");
	SUNLINK(oldstack); s++;
       }
 free_tag(who); /* Free tags */
 return(1);
}

int remote(player* p,char* str)  
{
 Tag who,s;
 char* oldstack;

 if (!*str)
    {
     send_pager(p," Format: remote <player> <msg>\n");
     return(0);
    }
 who=player_arg_tag(p,&str); 
 strncpy(p->repeat_str, str, MAX_LINE);
 strcpy(p->repeat_type, "remote");
 if (!who) return(0);

 if (!*str)
    {
     send_pager(p," Format: remote <player> <msg>\n");
     return(0);
    }

 if (p->active&GAG)
    {
     send_pager(p," You apear to be unable to talk. It could be that gag you are wearing!\n");
     return(0);
    }

 SLINK(oldstack);
 sprintf(stack," You emote '%s %s' to %s\n",p->name,str,tag2str(p,who));
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 s=who;
 while (*s)
       {
	sprintf(stack,"> %s %s (to %s)",fullname(p),str,tag2str(*s,who));
	SNEXT; SEND;
	bold(*s,1); send_pager(*s,oldstack);
	bold(*s,0); send_pager(*s,"\n");
	SUNLINK(oldstack); s++;
       }
 free_tag(who); /* Free tags */
 return(1);
}

int whisper(player* p,char* str) 
{
 player* pen;
 Tag who,lp;
 char* oldstack;

 if (!*str)
    {
     send_pager(p," Format: whisper <player> <msg>\n");
     return(0);
    }

 who=player_arg_tag(p,&str);
 strncpy(p->repeat_str, str, MAX_LINE);
 strcpy(p->repeat_type, "whisper");
 if (!who) return(0);

 if (!*str)
    {
     send_pager(p," Format: whisper <player> <msg>\n");
     return(0);
    }

 if (p->active&GAG)
    {
     send_pager(p," You apear to be unable to talk. It could be that gag you are wearing!\n");
     return(0);
    }

 SLINK(oldstack);
 sprintf(stack," You whisper '%s' to %s\n",str,tag2str(p,who));
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 p->active|=TEMP;
 /* Loop on the tag */

 lp=who;
 
 while (*lp)
       {
	sprintf(stack,"> %s whispers '%s' to %s",fullname(p),str,tag2str(*lp,who));
	SNEXT; SEND;
	
	pen=*lp;
	pen->active|=TEMP;
   
	bold(*lp,1); send_pager(*lp,oldstack);
	bold(*lp,0); send_pager(*lp,"\n");
	lp++;
	SUNLINK(oldstack);
       }
 /* free_tag(who);  Free tags */

 pen=first_player;
 while(pen)
 {
  if(!(pen->active&TEMP)&&(pen->room==p->room))
 {
   sprintf(mssg,"%s whispers something to %s\n",p->name,tag2str(p,who));
   send_pager(pen,mssg);
   pen->active&=~TEMP;
 }
 pen->active&=~TEMP;
 pen=pen->next;
 }
 free_tag(who);
 return(1);
}

int echo(player* p,char* str)            
{
 player* who;
 char* oldstack; 
 SLINK(oldstack);

 if (!*str)
    {
     send_pager(p,"Format: Echo <message>\n");
     return(0);
    }

 if (p->active&GAG)
    {
     send_pager(p," You apear to be unable to talk. It could be that gag you are wearing!\n");
     return(0);
    }
 
 SNEXT; SEND; 
 who=first_player;
 while (who)
       {
	if (p!=who) 
	{
	if ((who->room==p->room) && (who->pensflags&SEE_ECHO || who->privs&ADMIN))
	   {
	    sprintf(stack,"+[%s] %s \n",p->name,str);
	    send_pager(who,stack);
	   }
	else
	if (who->room==p->room)
	   {
	    sprintf(stack,"+ %s \n",str);
	    send_pager(who,stack);
	   }
	}
	who=who->next;
	}       
	
 SUNLINK(oldstack);
 sprintf(stack," You echo : %s \n",str);
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(1);
}

int say(player* p,char* str) 
{
 char* oldstack;

 SLINK(oldstack);

 if (!*str)
    {
     send_pager(p," Format: say <message>\n");
     return(0);
    }

 if (p->active&GAG)
    {
     send_pager(p," You apear to be unable to talk. It could be that gag you are wearing!\n");
     return(0);
    }

 sprintf(stack,"%s says '%s'\n",fullname(p),str);
 SNEXT; SEND;
 send_player_ignore(p,oldstack,SAY);
 SUNLINK(oldstack);
 sprintf(stack," You say '%s'\n",str);
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(1);
}

int shout(player* p,char* str) 
{
 char* oldstack;
 player* who;

 if (!*str)
    {
     send_pager(p,"Format: shout <message>\n");
     return(0);
    }

 if (p->active&GAG)
    {
     send_pager(p," You apear to be unable to talk. It could be that gag you are wearing!\n");
     return(0);
    }
 
 if (p->pensflags&SHOUT)
    {
     send_pager(p," You have been prevented from shouting!\n");
     return(0);
    }

 who=first_player;

 while (who)
       {
	if(!(p==who) && !(who->ignore&SHOUTS))
	{
	 sprintf(mssg,"%s shouts '%s'\n",fullname(p),str);
	 send_pager(who,mssg);
	}
	who=who->next;
       }
 sprintf(mssg," You shout '%s'\n",str);
 send_pager(p,mssg);
 return(1);
}

int think(player* p,char* str)   
{
 char* oldstack; SLINK(oldstack);

 if (!*str)
    {
     send_pager(p,"Format: think <message>\n");
     return(0);
    }

 if (p->active&GAG)
    {
     send_pager(p," You apear to be unable to talk. It could be that gag you are wearing!\n");
     return(0);
    }

 sprintf(stack,"%s thinks . o O ( %s )\n",fullname(p),str);
 SNEXT; SEND;
 send_player_ignore(p,oldstack,SAY);
 SUNLINK(oldstack);
 sprintf(stack," You think . o O ( %s )\n",str);
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(1);
}

int emote(player* p,char* str)   
{
 char* oldstack; SLINK(oldstack);
 if (!*str)
    {
     send_pager(p,"Format: emote <message>\n");
     return(0);
    }

 if (p->active&GAG)
    {
     send_pager(p," You apear to be unable to talk. It could be that gag you are wearing!\n");
     return(0);
    }

 sprintf(stack,"%s %s\n",fullname(p),str);
 SNEXT; SEND;
 send_player_ignore(p,oldstack,SAY);
 SUNLINK(oldstack);
 sprintf(stack," You emote: %s %s\n",p->name,str);
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(1);
}

int premote(player* p,char* str)
{
 Tag who,s;
 char* oldstack;

 if (!*str)
    {
     send_pager(p," Format: premote <player> <msg>\n");
     return(0);
    }

 if (p->active&GAG)
    {
     send_pager(p," You apear to be unable to talk. It could be that gag you are wearing!\n");
     return(0);
    }

 who=player_arg_tag(p,&str);
 strncpy(p->repeat_str, str, MAX_LINE);
 strcpy(p->repeat_type, "premote");
 if (!who) return(0);
 if (!*str)
    {
     send_pager(p," Format: premote <player> <msg>\n");
     return(0);
    }
 SLINK(oldstack);
 sprintf(stack," You emote '%s's %s' to %s\n",p->name,str,tag2str(p,who));
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 s=who;
 while (*s)
       {
	sprintf(stack,"> %s's %s (to %s)",fullname(p),str,tag2str(*s,who));
	SNEXT; SEND;
	bold(*s,1); send_pager(*s,oldstack);
	bold(*s,0); send_pager(*s,"\n");
	SUNLINK(oldstack); s++;
       }
 free_tag(who); /* Free tags */
 return(1);
}

int pemote(player* p,char* str) 
{
 char* oldstack; SLINK(oldstack);

 if (!*str)
    {
     send_pager(p,"Format: pemote <message>\n");
     return(0);
    }

 if (p->active&GAG)
    {
     send_pager(p," You apear to be unable to talk. It could be that gag you are wearing!\n");
     return(0);
    }

 sprintf(stack,"%s's %s\n",fullname(p),str);
 SNEXT; SEND;
 send_player_ignore(p,oldstack,SAY);
 SUNLINK(oldstack);
 sprintf(stack," You pemote: %s's %s\n",p->name,str);
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(1);
}

int sing(player* p,char* str)    
{
 char* oldstack; SLINK(oldstack);

 if (!*str)
    {
     send_pager(p,"Format: Sing <message>\n");
     return(0);
    }

 if (p->active&GAG)
    {
     send_pager(p," You apear to be unable to talk. It could be that gag you are wearing!\n");
     return(0);
    }

 if (p->active&SING)
    {
     send_pager(p," Sorry you have been prevented from singing!\n");
     return(0);
    }

 sprintf(stack,"%s sings o*~( %s )~*o\n",fullname(p),str);
 SNEXT; SEND;
 send_player_ignore(p,oldstack,SAY);
 SUNLINK(oldstack);
 sprintf(stack," You sing : o*~( %s )~*o\n",str);
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(1);
}

int helpme(player* p,char* txt)
{
 su_wall(p,"I need some Help..  !![NEWBIE]!!\n",SU);
 return(0);
}

int wake(player* p,char* str) 
{
 player* who;
 char* oldstack;

 if (!*str)
    {
     send_pager(p," Format: wake <player>\n");
     return(0);
    }

 who=player_arg(p,&str);
 if (!who) return(0);

 SLINK(oldstack);
 sprintf(stack," You shout and prod at '%s' in an attempt to wake them.\n",who->name);
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);

 SLINK(oldstack);
 sprintf(stack,"\a %s Prods you repeatedly with cries of 'WAKE UP!!!!'",fullname(p));
 SNEXT; SEND;
 bold(who,1); send_pager(who,oldstack);
 bold(who,0); send_pager(who,"\n");
 SUNLINK(oldstack);
 
 sprintf(mssg,"%s attempts to wake %s\n",p->name,who->name);
 send_room_wall_bar(p,who,mssg,p->room);

 return(1);
}

int saved_msg(player* p,char* str)           
{
 player* who;

 if (!*str)
 {
  send_pager(p," Format: smess <player> <message>\n");
  return(0);
 }

 who=player_arg_hard(p,&str);
 if (!who) return(0);

 if (who->smess && !(who->smess[0]==0))
  {
  send_pager(p," Sorry that person already has a Saved Message\n");
  return(0);
  }

 sprintf(mssg,"%s: %s",p->name,str);
 who->smess=strdup(mssg);
 sprintf(mssg," Saveing message for %s.\n",who->name);
 send_pager(p,mssg);
 unload_hard(who);
 return(0);
}

int bop(player* p,char* str) 
{
 player* pen;
 player* who;
 char* oldstack;

 if (!*str)
    {
     send_pager(p," Format: bop <player>\n");
     return(0);
    }

 if (p->pensflags&BOP)
    {
     send_pager(p," Sorry you have been prevented from bopping!\n");
     return(0);
    }

 who=player_arg(p,&str);
 if (!who) return(0);

 if (who->room==p->room)
 {
   SLINK(oldstack);
   sprintf(stack,"\a --==> %s bops you!!!! <==-- ",fullname(p));
   SNEXT; SEND;
   bold(who,1); send_pager(who,oldstack);
   bold(who,0); send_pager(who,"\n");
   SUNLINK(oldstack);
 }
 else
 {
   sprintf(mssg," Sorry you are not in the same room as %s!\n",who->name);
   send_pager(p,mssg);
   return(0);
 }

 SLINK(oldstack);
 sprintf(stack," You bop %s\n",who->name);
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 sprintf(mssg,"%s bops %s\n",p->name,who->name);
 send_room_wall_bar(p,who,mssg,p->room);

 return(1);
}

int rbop(player* p,char* str)
{
 player* who;
 char* oldstack;

 if (!*str)
    {
     send_pager(p," Format: rbop <player>\n");
     return(0);
    }
 who=player_arg(p,&str);
 if (!who) return(0);

 if (p->pensflags&BOP)
    {
     send_pager(p," Sorry you have been prevented form bopping!\n");
     return(0);
    }

 SLINK(oldstack);
 sprintf(stack," You bop %s\n",who->name);
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 sprintf(stack,"\007 --==> %s bops you. <==--",p->name);
 SNEXT; SEND;
 bold(who,1); send_pager(who,oldstack);
 bold(who,0); send_pager(who,"\n");
 SUNLINK(oldstack);
 return(1);
}
