/*
 * Base.c 
 * ~~~~~~ All base commands not actual commands
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "player.h"
#include "proto.h"
#include "config.h"

/*---------------------------Miscellaneous----------------------------*/
char           *bit_string(int flags)
{
   static char     out[33];
   int             i;
   for (i = 0; i < 32; i++, flags >>= 1)
      if (flags & 1)
    out[i] = '*';
      else
    out[i] = ' ';
   out[32] = 0;
   return out;
}

int reset_flag(player*p,char* str,int flag)
{
 player* who;
 DIR* dr;
 char* pname;
 char* dpath;
 int count=0;

 dpath=strdup(PFILES_DIR);

 dr=lsr_start(dpath);
 while ((pname=lsr_next(dr)))
 {
   if(count>1) 
   {
     who=find_player_hard(pname);
     who->pensflags|=flag;
     unload_hard(who);
   }
   count++;
 }

 who=first_player;
 while(who)
 {
   who->pensflags|=flag;
   who=who->next;
 }
 su_wall1(p,"Resets the %s.",str,SU);
 return(1);
}

int update_newnews(player*p,char* str)
{
 player* who;
 DIR* dr;
 char* pname;
 char* dpath;
 int count=0;

 dpath=strdup(PFILES_DIR);

 dr=lsr_start(dpath);
 while ((pname=lsr_next(dr)))
 {
   if(count>1) 
   {
     who=find_player_hard(pname);
     if (!strcmp(str,"news")) who->newnews++;
     if (!strcmp(str,"sunews")) who->newsunews++;
     unload_hard(who);
   }
   count++;
 }
 return(1);
}

char* nextword(char** dat)
{
 static char* mem=NULL;
 char *pt,*str;

 str=*dat;
 if (!str) return(NULL);

 if (mem) free(mem); mem=NULL;

 mem=calloc(sizeof(char),strlen(str)+1);
 pt=mem;

 while (isspace(*str)) str++;
 if (!*str) {*dat=str; return(NULL);}
 while (*str && !isspace(*str)) *pt++=*str++; *pt=0;
 while (isspace(*str)) str++;

 *dat=str;
 return(mem);
}

int setattrib(player* p,char** attrib,char* name,char* value)
{
 if (*attrib) free(*attrib);
 *attrib=strdup(value);

 if (**attrib)
    {
    sprintf(mssg," You set your %s to: %s\n",name,value);
    send_pager(p,mssg);
    }
 else
    {
    sprintf(mssg," You blank your %s.\n",name);
    send_pager(p,mssg);
    }
 return(1);
}

char* fullname(player* p)
{
 static char fn[MAX_LINE];
 if (p->prefix && *p->prefix)
    sprintf(fn,"%s %s",p->prefix,p->name);
 else
    sprintf(fn,"%s",p->name);
 return(fn);
}

/*------------------------File Based Commands-------------------------*/
int show_file(player* p,char* txt)
{
 char* buf;
 char* fname;

 fname=malloc(strlen(txt)+1+strlen(TXT_PATH));
 sprintf(fname,TXT_PATH,txt);
 buf=strap_file(fname); free(fname);
 if (!buf)
    {
     send_pager(p,"Sorry that file is currently unavailable.\n");	
     return(0);
    }
 send_pager(p,buf);
 free(buf);
 return(0);
}

char* strap_file(char* name)
{
 int sz;
 struct stat sb;
 char* buf; 
 FILE* han;

 if (stat(name,&sb)) return(NULL);

 han=fopen(name,"r");
 if (!han) return(NULL);

 buf=calloc(sizeof(char),sb.st_size+1);
 fread(buf,sizeof(char),sb.st_size,han);
 fclose(han);
 return(buf);
}

/*-------------------------Log Based Commands-------------------------*/
int log_count(player*p,char* str)                      
{
 DIR* dr;
 char* pname;
 char* dpath;
 int count=0;

 dpath=strdup(LOG_DIR);
 send_pager(p," Current system Logs...\n ");
 dr=lsr_start(dpath);
 while ((pname=lsr_next(dr)))
       {
        if (count >1) 
	{
	sprintf(mssg,"(%s) ",pname);
	send_pager(p,mssg);
	}
        count++;
       }
 count=count-2;
 sprintf(mssg,"\n There is a total of %d Logs.\n",count);
 send_pager(p,mssg);
 return(1);
}

int tolog(char* filetosave,char* str)
{
 FILE* han;
 player* who;
 char file2[60];

 sprintf(file2,"files/logs/%s",filetosave);
 han=fopen(file2,"a");
 if (!han) return(0);
 fprintf(han,time2asc(current_time()));
 fprintf(han," : ");
 fprintf(han,str); 
 fclose(han);
 do_debug(filetosave,str);
 return(0);
}

int do_debug(char* filetosave,char* str)
{
 player* who;
 char debugfile[400];

 who=first_player;
 while(who)
 {
   if (who->pensflags&DEBUG)
   {
     bold(who,1);
     sprintf(debugfile,"[DEBUG] <%s> %s",filetosave,str);
     send_pager(who,debugfile);
     bold(who,0);
   }
   who=who->next;
 }
 return(0);
}

/*------------------------------SU Wall-------------------------------*/
int su_wall(player* p,char* str,int wallpriv)			
{
 return(su_wall2(p,str,"","",wallpriv));
}

int su_wall1(player* p,char* str,char* arg,int wallpriv)
{
 return(su_wall2(p,str,arg,"",wallpriv));
}

int su_wall2(player* p,char* str,char* arg,char* arg2,int wallpriv)
{
 char* oldstack;
 player* s;

 SLINK(oldstack);
 sprintf(stack,"-=> %s ",p->name);
 SNEXT;
 sprintf(stack,str,arg,arg2);
 SNEXT;SEND;
 
 s=first_player;
 while (s)
       {
        if (s->active&GAME && s->privs&wallpriv)
           {
            bold(s,1);
            send_pager(s,oldstack);
            bold(s,0); send_pager(s,"\n");
           }
        s=s->next;
       } 
 SUNLINK(oldstack);
 return(1);
}

/*--------------------------Strack Settings---------------------------*/
void stackcurrentlogin(player* who)
{
 if (who->currentlogin)
    {
     sprintf(stack,"%s has been logged in for: %s\n"
        ,who->name,time2str(who->currentlogin));
    }
 else
    {
     if (!(who->last_login))
        sprintf(stack,"%s has never logged in.\n",who->name);
     else
        sprintf(stack,"%s was last seen on %s\n"
               ,who->name,time2asc(who->last_login));
    }
 SNEXT;
}

void stacklogintime(player* who)
{
 if (who->gender==1)  sprintf(stack,"His ");
 if (who->gender==2)  sprintf(stack,"Her ");
 SNEXT;
 sprintf(stack,"True login time: %s\n",time2str(who->login_time-who->login_idle));
 SNEXT;
}

void stackidletime(player* who)
{
 sprintf(stack,"Idle login time: %s\n",time2str(who->login_idle));
 SNEXT;
}

void stackip(player* who)
{
 if (!who->ip_name) return;
 sprintf(stack,"%s is logged in from: %s (%s)\n",who->name,who->ip_name,who->ip_num);
 SNEXT;
}

void stackoldip(player* who)
{
 if (!who->old_ip) return;
 sprintf(stack,"%s was last logged in from: %s\n",who->name,who->old_ip);
 SNEXT;
}

void stackdesc(player* who)
{
 if (!who->desc || !*who->desc) return;

 sprintf(stack,"%s\n",who->desc);
 SNEXT;
 stackbar();
 return;
}

void stackemail(player*p, player* who)
{
  if (p==who || p->privs&ADMIN || !(who->pensflags&PRIVATE))
  {
  	if (!who->email || !*who->email) 
  		{
    		sprintf(stack,"Email: Not Set\n",who->name);
 		SNEXT;
 		return;
  		}
  	else
  		{
		if(who->pensflags&PRIVATE) 
			{		
			sprintf(stack,"Email: %s (PRIVATE)\n",who->email);
			SNEXT;
			return;
			}
		sprintf(stack,"Email: %s\n",who->email);
		SNEXT;
 		return;
  		}
  }
  else
  	{
  	sprintf(stack,"Email: (private)\n");
  	}
 SNEXT;
 return;
}

void stacksucomment(player* who,player* p)
{
 if((!who->sucom || !*who->sucom)&&(!who->hccom || !*who->hccom)) return;

 if (p->privs&HCADMIN) 
 {
  sprintf(stack,"HC comment: %s\n",who->hccom);
  SNEXT;
 }
 sprintf(stack,"SU comment: %s\n",who->sucom);
 SNEXT;
 stackbar();
 return;
}

void stackurl(player* who)
{
 if(!who->url || !*who->url)
 {
  stackbar();
  return;
 }
 sprintf(stack,"URL: %s\n",who->url);
 SNEXT;
 stackbar();
 return;
}

void stackmarry(player* who)
{
 if(!who->marry || who->marry[0]==0) return;
 
 if(who->pensflags&PROPOSE)
	sprintf(stack,"%s is proposing marrage to %s\n",who->name,who->marry);
 else
 if(who->pensflags&ENGAGED)
	sprintf(stack,"%s is engaged to %s\n",who->name,who->marry);
 else
 if(who->pensflags&MARRIED)
	sprintf(stack,"%s is married to %s\n",who->name,who->marry);
 SNEXT;
 stackbar();
 return;
}

void stackirl(player* who)
{
 int irl=0;
 if(who->rlname && !(who->rlname[0]==0))
 {
  sprintf(stack,"Name: %s\n",who->rlname);
  SNEXT;
  irl=1;
 }
 if(who->age)
 {
 sprintf(stack,"Age: %d\n",who->age);
 SNEXT;
 irl=1;
 }
 if(who->bday && !(who->bday[0]==0))
 {
  sprintf(stack,"Birthday: %s makeing them a %s\n",who->bday,who->star_sign);
  SNEXT;
  irl=1;
 } 
 if(who->rlloc && !(who->rlloc[0]==0))
 {
  sprintf(stack,"Location: %s\n",who->rlloc);
  SNEXT;
  irl=1;
 }
 if(irl) stackbar();
 return;
}

void stackback(player* who)
{
 if(!who->back || !*who->back) return;

 sprintf(stack,"Back: %s\n",who->back);
 SNEXT;
 stackbar();
 return;
}

void stackplan(player* who)
{
 if(!who->plan || !*who->plan) return;

 sprintf(stack,"Plan: %s\n",who->plan);
 SNEXT;
 stackbar();
 return;
}

void stackwhereadmin(player* who)
{
 sprintf(stack,"%s %s (%s)\n",fullname(who),rooms[who->room].where,rooms[who->room].name);
 SNEXT;
}

void stackwhere(player* who)
{
 if(who->pensflags&HIDE)
 sprintf(stack,"%s is hiding away!!\n",fullname(who));
 else
 sprintf(stack,"%s %s\n",fullname(who),rooms[who->room].where);
 SNEXT;
}

void stackfullname(player* who)
{
 sprintf(stack,"%s %s\n",fullname(who),who->title);
 SNEXT;
}

void stackbar(void)
{
 sprintf(stack,"---------------------------------------------"
               "----------------------------------\n");
 SNEXT;
}

/*-------------------------Player Arg Stuff---------------------------*/
player* player_arg(player* p,char** s)
{
 char *txt,*t;
 player* who;
 txt=*s;

 while (isspace(*txt)) txt++;
 t=txt; while (isalnum(*t)) t++;
 if (*t) {*t=0; t++;}
 while (isspace(*t)) t++; *s=t;
 
 who=find_player_soft(txt);
 if (!who)
    {
     sprintf(mssg," No-one of the name '%s' is on at the moment.\n",txt);
     send_pager(p,mssg);
     return(NULL);
    } 
 return(who);
}

Tag player_arg_tag(player* p,char** s)
{
 return(player_arg_tag_multi(p,s,0));
}

Tag player_arg_tag_hard(player* p,char** s)
{
 return(player_arg_tag_multi(p,s,1));
}

Tag player_arg_tag_multi(player* p,char** s,int hard)
{
 char *txt,*t;
 Tag who;
 txt=*s;

 while (isspace(*txt)) txt++;
 t=txt; while (isalnum(*t) || *t==',') t++;
 if (*t) {*t=0; t++;}
 while (isspace(*t)) t++; *s=t;
 
 if (hard)
    who=tag_byname_hard(p,txt);
 else
    who=tag_byname(p,txt);

 if (!who) return(NULL); /* Error case */

 if (!strncmp(t,BUT_STRING,BUT_STRING_LEN))
    {
     Tag tag2;
     t+=BUT_STRING_LEN;
     tag2=player_arg_tag_multi(p,&t,hard); *s=t;
     if (!tag2) {free_tag(who); return(NULL);}
     tag_minus_tag(who,tag2); free_tag(tag2);

     if (!*who)
        {
         free_tag(who);
         send_pager(p," Nobody of that description is online right now.\n");
         return(NULL);
        }

     return(who);
    }

 if (!strncmp(t,AND_STRING,AND_STRING_LEN))
    {
     Tag tag2;
     t+=AND_STRING_LEN;
     tag2=player_arg_tag_multi(p,&t,hard); *s=t;
     if (!tag2) {free_tag(who); return(NULL);}
     tag_plus_tag(who,tag2); free_tag(tag2);
     return(who);
    }

 return(who);
}

player* player_arg_hard(player* p,char** s)
{
 char *txt,*t;
 player* who;
 txt=*s;

 while (isspace(*txt)) txt++;
 t=txt; while (isalnum(*t)) t++;
 if (*t) {*t=0; t++;}
 while (isspace(*t)) t++; *s=t;
 
 if (!*txt)
    {
     send_pager(p," Invalid player name.\n");
     return(NULL);
    }

 who=find_player_hard(txt);
 if (!who)
    {
     sprintf(mssg," No-one of the name '%s' exists.\n",txt);
     send_pager(p,mssg);
     return(NULL);
    } 
 return(who);
}
