/*
 * Adcom.c
 * ~~~~~~~  Admin commands
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "player.h"
#include "proto.h"
#include "config.h"

/*---------------------------Reset flags------------------------------*/
int reset_motd(player* p, char* str)
{
  return(reset_flag(p,"MOTD",NEW_MOTD));
}

int reset_sumotd(player* p, char* str)
{
  return(reset_flag(p,"Staff MOTD",NEW_SUMOTD));
}

/*--------------------------Miscellaneous-----------------------------*/
int force(player*p,char* str)
{
 player* who;
 char* cmd;

  #ifndef FORCE
   send_pager(p," Sorry. Force has been Disabled!.\n");
   return(0);
  #endif

 if (!*str)
 {
    send_pager(p," Format: force <player> <command>\n");
    return(0);
 }

 who=player_arg(p,&str);
 if (!who) return(0);

 if (!bestprivsloud(p,who))
    {
     unload_hard(who);
     return(0);
    }

 su_wall2(p," forces %s to do %s",who->name,str,HCADMIN);

 cmd=nextword(&str);

 dispatch_command(who,cmd,str);

 return(0);
}

int genelist(player*p,char* str)
{
 char fname[]="email";
 FILE* han;
 player* who;
 DIR* dr;
 char* pname;
 char* dpath;
 int count=0;

 han=fopen(fname,"w");
 if (!han) return(0);

 dpath=strdup(PFILES_DIR);

 dr=lsr_start(dpath);
 while ((pname=lsr_next(dr)))
       {
        if (count >1)
         {
          who=find_player_hard(pname);
          fprintf(han,"%s\n",who->email);
          unload_hard(who);
         }
       count++;
       }
 fclose(han);
 su_wall(p,"makes an email list.",ADMIN);
 return(1);
}

int check_info(player* p,char* str)
{
 player* who;
 char* txt;

 txt=str;

 if (!*str)
 {
    send_pager(p," Format: check info <player>\n");
    return(0);
 }

 who=player_arg_hard(p,&str);
 if (!who) return(0);
 unload_hard(who);

 list_priv_flags(p,txt);
 list_pen_flags(p,txt);
 pinfo(p,txt);

 return(0);
}

int list_pen_flags(player* p,char* str)
{
 player* who;
 char* oldstack;

 if (!*str)
 {
    send_pager(p," Format: list_pflag <player>\n");
    return(0);
 }

 who=player_arg_hard(p,&str);
 if (!who) return(0);

 SLINK(oldstack);

 stackbar();
 sprintf(stack,"Pens flags for player %s\n",who->name);
 SNEXT;
 stackbar();
 sprintf(stack,"PSHDdPEMms    SI    SB         \n");
 SNEXT;
 sprintf(stack,"0123456789012345678901234567890\n");
 SNEXT;
 sprintf(stack,bit_string(who->pensflags));
 SNEXT;
 sprintf(stack,"\n");
 SNEXT;
 stackbar();

 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 unload_hard(who);
 return(0);
}

int bump(player* p,char* str)
{
 player* who;
 char* pname;

 if (!*str)
    {
     send_pager(p," Format: bump <playername>\n");
     return(0);
    }

 who=player_arg(p,&str);
 if (!who) return(0);

  if (p==who)
    {
     send_pager(p," One question. Why??\n");
     return(0);
    }

 if (!bestprivsloud(p,who))
    {
     unload_hard(who);
     return(0);
    }
 pname=strdup(who->name);

 unload_hard(who);
 save_player(who);
 kill_player(who);

 su_wall1(p,"bumps %s off the talker.",pname,ADMIN);

 sprintf(mssg,"%s bumps %s of the talker\n",p->name,pname);
 tolog("bump",mssg);
 free(pname);
 return(0);
}

int debug(player* p,char* str)
{
 if (p->pensflags&DEBUG)
    {
     send_pager(p," -=> Your leave Debug mode.\n");
     p->pensflags&=~DEBUG;
     return(1);
    }
 p->pensflags|=DEBUG;
 send_pager(p," -=> Your enter Debug mode.\n");
 return(1);
}

/*------------------------------Files---------------------------------*/
int reload(player* p,char* str)	
{
 load_globals();
 su_wall(p,"reloads all globals.",SU);
 sprintf(mssg,"%s reloads the global text files\n",p->name);
 tolog("globals",mssg);
 load_rooms();
 su_wall(p,"reloads all rooms.",SU);
 sprintf(mssg,"%s reloads the room text files\n",p->name);
 tolog("globals",mssg);
 return(1);
}

/*------------------------------Backup--------------------------------*/
int do_backup(player* p,char* str)
{
 char fname[MAX_LINE];

 sprintf(mssg,"  --==> Start of backup process <==-- \n");
 send_wall(mssg,0);
 strcpy(fname,ROOT);
 strcat(fname,"/bin/backup");
 system(fname);
 sprintf(mssg,"  --==> End of backup process <==-- \n");
 send_wall(mssg,0);
 return(0);
}

/*-----------------------------Shutdown-------------------------------*/
int abort_shutdown(player* p,char* str)	
{
  shutdown_talker(p,"-1 Aborting");
}

int shutdown_talker(player* p,char* str)	
{
 char* txt;
 int time=0;

 txt=nextword(&str);
 if (!txt || ! (isdigit(*txt) || *txt=='-'))
    {
     if (shutdown_time<0) 
        sprintf(mssg," -=> There is no Shutdown in progress\n");
     else
        sprintf(mssg," -=> Shutting down the Talker in %s: %s\n",sec2str(shutdown_time),shutdown_reason);
     send_pager(p,mssg);
     return(0);
    }
 time=atoi(txt);

 if (!*str)
    txt="Important work.";
 else
    txt=str;

 strcpy(shutdown_reason,txt);
 if (time<0) time=-1;
 shutdown_time=time;

 if (time<0)
    {
     sprintf(mssg,"%s stops the talker shutting down\n",p->name);
     tolog("shutdown",mssg);
     su_wall(p,"stops the shutdown sequence.",SU);
    }
 else
    {
     sprintf(mssg,"%s sets the talker to shutdown\nReason: %s\n",p->name,str);
     tolog("shutdown",mssg);
     su_wall(p,"sets the talker to shutdown.",SU);
    }
 return(1);
}

/*-------------------------HCadmin Settings---------------------------*/
int set_lsu(player* p,char* str)	 
{
 if (strlen(str)>15)
 {
  send_pager(p," Try something a bit shorter.\n");
  return(1);
 }
 return(setattrib(p,&p->lsu,"LSU entry",str));
}

int set_ipname(player* p,char* str)
{
 if (strlen(str)>30)
 {
  send_pager(p," Try something a bit shorter.\n");
  return(1);
 }
 p->hcip=1;
 return(setattrib(p,&p->ip_name,"IP Name",str));
}

int set_ipnum(player* p,char* str)
{
 if (strlen(str)>15)
 {
  send_pager(p," Try something a bit shorter.\n");
  return(1);
 }
 p->hcip=1;
 return(setattrib(p,&p->ip_num,"IP Number",str));
}

int hc_comment(player* p,char* str)           
{
 player* who;

 if (!*str)
 {
  send_pager(p," Format: hccomment <player> <comment>\n");
  return(0);
 }

 who=player_arg_hard(p,&str);
 if(!who) return(0);
 if(!bestprivsloud(p,who)) return(0);
 sprintf(mssg,"(%s) %s",p->name,str);
 who->hccom=strdup(mssg);
 su_wall1(p,"sets a HC comment for %s.",who->name,HCADMIN);
 unload_hard(who);
 return(0);
}

int adhide(player* p,char* str)	
{
 if (p->active&GAME)
    {
     send_pager(p," -=> You are now hidden from other users.\n");
     p->active&=~GAME;
     sprintf(mssg,"%s disactiveates their game flag\n",p->name);
     do_debug("code",mssg);
     return(1);
    }
 p->active|=GAME;
 send_pager(p," -=> You are now visible to other users.\n");
 sprintf(mssg,"%s activates their game flag\n",p->name);
 do_debug("code",mssg);
 return(1);
}

/*--------------------------Blank's & Edits---------------------------*/
int edtime(player* p, char* str)
{
 player* who;
 int days, hours, mins;
 int ttime;

 if (!*str)
    {
     send_pager(p," Format: edtime <player> <days> <hours> <minutes>\n");
     return(0);
    }

 who=player_arg_hard(p,&str);
 if (!who) return(0); 

 if (!str)
  {
     send_pager(p," Format: edtime <player> <days> <hours> <minutes>\n");
     return(0);
  }

 if(!bestprivsloud(p,who)) return(0);

 who->login_time=0;

 sscanf(str, "%d %d %d", &days, &hours, &mins);
 ttime = 60*mins;
 ttime = ttime + 60*60*hours;
 ttime = ttime + 60*60*24*days;

 sprintf(mssg,"%s edits %s's login time to %s\n",p->name,who->name,time2str(ttime));
 su_wall1(p,"Changed %s's login time",who->name,SU);
 tolog("edtime",mssg);
 who->login_time=ttime;
 unload_hard(who);
 return(0);
}

int reset_idle(player* p, char* str)	
{
 player* who;

 if (!*str)
    {
     send_pager(p," Format: reset_idle <player>\n");
     return(0);
    }

 who=player_arg_hard(p,&str);
 if (!who) return(0);

 if(!bestprivsloud(p,who)) return(0);

 who->login_idle=0;
 sprintf(mssg,"%s blanks %s's idle time\n",p->name,who->name);
 su_wall1(p,"blanks %s's idle time",who->name,SU);
 tolog("edtime",mssg);
 unload_hard(who);
 return(0);
}

/*-------------------------Bannish Commands---------------------------*/
int vbanish(player* p,char* txt)
{
 return(show_file(p,"siteban"));
}

int unbanish_name(player* p, char* name)
{
 FILE* f_ptr;
 player* who;
 char* oldstack;
 char bname[20];
 char banfile[]="files/banish";

 if (!*name)
 {
 send_pager(p," Format: Unbanish <player>\n");
 return(0);
 }

 who=find_player_hard(name);

 if (!who)
 {
   SLINK(oldstack);
   if ((f_ptr = fopen("files/banish","r"))==NULL)
   {
      sprintf(mssg,"Banish file Missing!!!.\n");
      tolog("error",mssg);
      return(0);
   }

   while (bname[0]!='#')
   {
        fscanf(f_ptr,"%s",bname);
        if (!strcasecmp(name,bname))
        {
          SNEXT;
	}
	else
	{
          sprintf(stack,"%s\n",bname);
          SNEXT;
        }
   }
   SNEXT; SEND;
   fclose(f_ptr);
   f_ptr = fopen("files/banish","w");
   fputs(oldstack,f_ptr);
   fclose(f_ptr);
   SUNLINK(oldstack);
   su_wall1(p,"has un-banished the name '%s'",name,SU);
   sprintf(mssg,"%s has un-banished the name '%s'\n",p->name,name);
   tolog("ban",mssg);
 }
 else
 {
   if(!bestprivsloud(p,who)) 
   {
     unload_hard(who);
     return(0);
   }
   who->privs&=~BANISHED;
   unload_hard(who);
   su_wall1(p,"has un-banished the player '%s'",name,SU);
   sprintf(mssg,"%s has un-banished the player '%s'\n",p->name,name);
   tolog("ban",mssg);
 }
 return(1);
}

int banish_name(player* p, char* name)
{
 FILE* f_ptr;
 player* who; 
 char* msg;
 char* buf;
 char banfile[]="files/banish";

 if (!*name)
 {
 send_pager(p," Format: Banish <player>\n");
 return(0);
 }

 who=find_player_hard(name);

 if (!who)
 {
   SLINK(msg);
   sprintf(msg,"%s\n",name);
   buf=strap_file(banfile);
   if (!buf)
    {
      send_pager(p," Warning There is no banish file!!!\n");
      return(0);
    }
   f_ptr=fopen(banfile,"w");
   fprintf(f_ptr,msg);
   fprintf(f_ptr,buf);
   fclose(f_ptr);
   SUNLINK(msg);
   free(buf);
   su_wall1(p,"has banished the name '%s'",name,SU);
   sprintf(mssg,"%s has banished the name '%s'\n",p->name,name);
   tolog("ban",mssg);
 }
 else
 {
   if(!bestprivsloud(p,who))
   {
     unload_hard(who);
     return(0);
   }
   who->privs|=BANISHED;
   unload_hard(who);
   su_wall1(p,"has banished the player '%s'",name,SU);
   sprintf(mssg,"%s has banished the player '%s'\n",p->name,name);
   tolog("ban",mssg); 
 }
 return(1);
}

int banish_site(player* p, char* name)
{
 FILE* f_ptr;
 char* msg;
 char* buf;
 char banfile[]="files/siteban";

 SLINK(msg);

 if (!*name)
 {
 send_pager(p," Format: SiteBan <Numerical IP>\n");
 return(0);
 }

 su_wall1(p,"has banished the site '%s'",name,SU);
 sprintf(mssg,"%s has banished the site '%s'\n",p->name,name);
 tolog("ban",mssg);

 sprintf(msg,"%s\n",name);
 buf=strap_file(banfile);
 if (!buf)
    {
     send_pager(p," Warning There is no site banish file!!!\n");
     return(0);
    }
 f_ptr=fopen(banfile,"w");
 fprintf(f_ptr,msg);
 fprintf(f_ptr,buf);
 fclose(f_ptr);
 SUNLINK(msg);
 free(buf);
 return(1);
}

/*-------------------------------Wall---------------------------------*/
int wall_talker(player* p, char* str)	
{
  if (!*str)
     { 
	send_pager(p," Format: wall <message>\n");
       	return(0);
     }

  sprintf(mssg,"\007 -=> %s screams %s <=-\n",p->name,str);
  send_wall(mssg,1);
  return(0);
}

int wall_su(player* p, char* str)	
{
  if (!*str)
     { 
	send_pager(p," Format: suwall <message>\n");
       	return(0);
     }

  su_wall1(p,"\007 -=> %s <=- [SU]\n",str,SU);
  return(0);
}

int wall_admin(player* p, char* str)	
{
  if (!*str)
     { 
	send_pager(p," Format: adwall <message>\n");
       	return(0);
     }

  su_wall1(p,"\007 -=> %s <=- [Admin]\n",str,LA|ADMIN);
  return(0);
}

int wall_hcadmin(player* p, char* str)
{
  if (!*str)
     {
        send_pager(p," Format: hcadwall <message>\n");
        return(0);
     }

  su_wall1(p,"\007 -=> %s <=- [HCAdmin]\n",str,HCADMIN);
  return(0);
}
/*-------------------------------Logs---------------------------------*/
int vlog(player* p,char* str)
{
 char* txt;
 char* buf;
 char* fname;

 txt=str; while (isalnum(*txt) || *txt=='_') txt++; *txt=0;

 if (!*str)
     {
        send_pager(p," Format: vlog <log file>\n");
	log_count(p,NULL);
        return(0);
     }

 fname=malloc(strlen(str)+1+strlen("files/logs/"));
 sprintf(fname,"files/logs/%s",str);

 if(!strcmp("files/logs/banish",fname))  sprintf(fname,"files/banish"); 
 if(!strcmp("files/logs/siteban",fname)) sprintf(fname,"files/siteban");
 buf=strap_file(fname); free(fname);
 if (!buf)
    {
     sprintf(mssg," There is no log called %s\n",str);
     send_pager(p,mssg);
     return(0);
    }
 
 send_pager(p,buf);
 free(buf);
 return(1);
}

/*----------------------------Admin Echo------------------------------*/
int aecho(player* p, char* str)	
{
  if (!*str)
     { 
       send_pager(p," Format: aecho <message>\n");
       return(0);
     }
      
  sprintf(mssg,"%s\n",str);
  send_wall(mssg,0);
  sprintf(mssg,"%s aechos '%s'\n",p->name,str);
  do_debug("code",mssg);
  return(0);
}

int becho(player* p, char* str)	
{
  if (!*str)
     { 
       send_pager(p," Format: becho <message>\n");
       return(0);
     }
      
  sprintf(mssg,"%s\n",str);
  send_room_wall(p,mssg,p->room);
  send_pager(p,mssg);
  sprintf(mssg,"%s bechos '%s'\n",p->name,str);
  do_debug("code",mssg);
  return(0);
}

/*--------------------------Player Commands---------------------------*/
int rm_move(player* p,char* str)
{
 player* who;

 if (!*str)
 {
   send_pager(p," Format: rm_move <player>\n");
   return(0);
 }

 who=player_arg_hard(p,&str);
 if (!who) return(0);

 if(!bestprivsloud(p,who)) return(0);

 if (who->privs&ROOM)
    {
      who->privs&=~ROOM;
      send_pager(who," -=> You apear to be stuck to the ground!!\n");
      su_wall1(p,"removes %s's movement commands",who->name,SU);
      sprintf(mssg,"%s rm_moves %s\n",p->name,who->name);
      tolog("rm_move",mssg);
      sprintf(mssg," You remove %s's movement commands\n",who->name);
      send_pager(p,mssg);
    }

 else
    {
      who->privs|=ROOM;
      send_pager(who," -=> You no longer apear to be stuck to the ground!!\n");
      su_wall1(p,"returns %s's movement commands",who->name,SU);
      sprintf(mssg,"%s un - rm_moves %s\n",p->name,who->name);
      tolog("rm_move",mssg);
      sprintf(mssg," You return %s's movement commands\n",who->name);
      send_pager(p,mssg);
    }

 unload_hard(who);
 return(1);
}

/*-------------------------------SPY----------------------------------*/
int watch_player(player* p,char* str)
{
 player* who;

 if (!*str)
 {
  send_pager(p," Format: watch <player>\n");
  return(0);
 }

 who=player_arg(p,&str);
 if (!who) return(0);

 if (!bestprivsloud(p,who))
    {
     send_pager(p," Sorry you cant spy on your equals!!!!\n");
     return(0);
    }

 if (who->active&WATCHED)
 {
  if(strcmp(p->name,who->who_spook))
  {
    send_pager(p," Sorry that player is already being watched.\n");
    return(0);
  }
  else
  {
    who->active&=~WATCHED;
    sprintf(mssg," You stop watching %s\n",who->name);
    su_wall1(p," Stops watching %s.",who->name,SPOOK);
    send_pager(p,mssg);
    return(0);
  }
 }
 who->active|=WATCHED;
 who->who_spook=strdup(p->name);
 sprintf(mssg," You start watching %s\n",who->name);
 su_wall1(p," Starts watching %s.",who->name,SPOOK);
 send_pager(p,mssg);
 return(0);
}

int watch_list(player* p,char* str)
{
 player* who;
 char*   oldstack;

 who=first_player;

 SLINK(oldstack);

 stackbar();
 sprintf(stack,"People Under Watch.\n");
 SNEXT
 stackbar();

 while (who)
 {
   if (who->active&WATCHED)
   {
    sprintf(stack,"%-20s:watched by %s ",who->name,who->who_spook);
    SNEXT
   }
   who=who->next;
 }
 sprintf(stack,"\n");
 SNEXT;
 stackbar();
 SNEXT; SEND;
 send_pager(p,oldstack);
 SUNLINK(oldstack);
 return(0);
}
